/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.jlan.server.config.ServerConfigurationAccessor;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FilesystemsConfigSection;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.BaseAlfrescoTestCase;

public class CifsIntegrationTest
extends BaseAlfrescoTestCase {
    public void testGetServerName() {
        ServerConfigurationAccessor config = (ServerConfigurationAccessor)this.ctx.getBean("fileServerConfiguration");
        CifsIntegrationTest.assertNotNull((String)"No file server config available", (Object)config);
        if (!config.isServerRunning("CIFS")) {
            return;
        }
        String serverName = config.getServerName();
        CifsIntegrationTest.assertNotNull((String)"No server name available", (Object)serverName);
        CifsIntegrationTest.assertTrue((String)"No server name available (zero length)", (serverName.length() > 0 ? 1 : 0) != 0);
        FilesystemsConfigSection filesysConfig = (FilesystemsConfigSection)config.getConfigSection("Filesystems");
        DiskSharedDevice mainFilesys = (DiskSharedDevice)filesysConfig.getShares().enumerateShares().nextElement();
        if (mainFilesys != null) {
            String shareName = mainFilesys.getName();
            CifsIntegrationTest.assertNotNull((String)"No share name available", (Object)shareName);
            CifsIntegrationTest.assertTrue((String)"No share name available (zero length)", (shareName.length() > 0 ? 1 : 0) != 0);
            ContentContext filesysCtx = (ContentContext)mainFilesys.getContext();
            CifsIntegrationTest.assertNotNull((String)"Content context is null", (Object)((Object)filesysCtx));
            CifsIntegrationTest.assertNotNull((String)"Store id is null", (Object)filesysCtx.getStoreName());
            CifsIntegrationTest.assertNotNull((String)"Root path is null", (Object)filesysCtx.getRootPath());
            CifsIntegrationTest.assertNotNull((String)"Root node is null", (Object)filesysCtx.getRootNode());
            NodeService nodeService = (NodeService)this.ctx.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
            NodeRef shareNodeRef = filesysCtx.getRootNode();
            CifsIntegrationTest.assertNotNull((String)"No share root node available", (Object)shareNodeRef);
            CifsIntegrationTest.assertTrue((String)"Share root node doesn't exist", (boolean)nodeService.exists(shareNodeRef));
        }
    }
}

