/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import org.alfresco.jlan.util.MemorySize;

public class UserQuotaDetails {
    private String m_userName;
    private long m_quota;
    private long m_curUsage;
    private long m_lastUpdate;

    public UserQuotaDetails(String userName, long quota) {
        this.m_userName = userName;
        this.m_quota = quota;
    }

    public final String getUserName() {
        return this.m_userName;
    }

    public final boolean hasUserQuota() {
        return this.m_quota != -1L;
    }

    public final long getUserQuota() {
        return this.m_quota;
    }

    public final long getCurrentUsage() {
        return this.m_curUsage;
    }

    public final long getLastUpdated() {
        return this.m_lastUpdate;
    }

    public final long getAvailableSpace() {
        if (this.getUserQuota() == 0L) {
            return -1L;
        }
        long availSpace = this.getUserQuota() - this.getCurrentUsage();
        if (availSpace < 0L) {
            availSpace = 0L;
        }
        return availSpace;
    }

    public final void setUserQuota(long quota) {
        this.m_quota = quota;
    }

    public final void setCurrentUsage(long usage) {
        this.m_curUsage = usage;
        this.m_lastUpdate = System.currentTimeMillis();
    }

    public final long addToCurrentUsage(long usage) {
        this.m_curUsage += usage;
        this.m_lastUpdate = System.currentTimeMillis();
        return this.m_curUsage;
    }

    public final long subtractFromCurrentUsage(long usage) {
        this.m_curUsage -= usage;
        this.m_lastUpdate = System.currentTimeMillis();
        return this.m_curUsage;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getUserName());
        str.append(",quota=");
        str.append(MemorySize.asScaledString((long)this.getUserQuota()));
        str.append(",current=");
        str.append(this.getCurrentUsage());
        str.append(",available=");
        str.append(this.getAvailableSpace());
        str.append("/");
        str.append(MemorySize.asScaledString((long)this.getAvailableSpace()));
        str.append("]");
        return str.toString();
    }
}

