/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.query;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.alfresco.jcr.dictionary.JCRNamespace;
import org.alfresco.jcr.query.QueryImpl;
import org.alfresco.jcr.query.XPathQueryImpl;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.service.namespace.QName;

public class QueryManagerImpl
implements QueryManager {
    public static QName JCRPATH_COLUMN = QName.createQName((String)JCRNamespace.JCR_URI, (String)"path");
    public static QName JCRSCORE_COLUMN = QName.createQName((String)JCRNamespace.JCR_URI, (String)"score");
    private static Map<String, Class<? extends QueryImpl>> supportedLanguages = new HashMap<String, Class<? extends QueryImpl>>();
    private SessionImpl session;

    public QueryManagerImpl(SessionImpl session) {
        this.session = session;
    }

    public Query createQuery(String statement, String language) throws InvalidQueryException, RepositoryException {
        if (!this.isSupportedLanguage(language)) {
            throw new InvalidQueryException("Query language " + language + " is not supported");
        }
        Class<? extends QueryImpl> queryClass = supportedLanguages.get(language);
        try {
            Constructor<? extends QueryImpl> constructor = queryClass.getConstructor(SessionImpl.class, String.class);
            QueryImpl queryImpl = constructor.newInstance(this.session, statement);
            queryImpl.isValidStatement();
            return queryImpl.getProxy();
        }
        catch (InstantiationException e) {
            throw new RepositoryException("Failed to create query " + statement + " (language: " + language + ")");
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException("Failed to create query " + statement + " (language: " + language + ")");
        }
        catch (Exception e) {
            throw new RepositoryException("Failed to create query " + statement + " (language: " + language + ")");
        }
    }

    public Query getQuery(Node node) throws InvalidQueryException, RepositoryException {
        throw new InvalidQueryException("Persistent queries are not supported by the Repository.");
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException {
        return supportedLanguages.keySet().toArray(new String[supportedLanguages.size()]);
    }

    private boolean isSupportedLanguage(String language) {
        return supportedLanguages.containsKey(language);
    }

    static {
        supportedLanguages.put("xpath", XPathQueryImpl.class);
    }
}

