/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.TransformActionExecuter;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NoTransformerException;
import org.alfresco.service.cmr.repository.NodeRef;

public class ImageTransformActionExecuter
extends TransformActionExecuter {
    private TransformerDebug transformerDebug;
    public static final String NAME = "transform-image";
    public static final String PARAM_CONVERT_COMMAND = "convert-command";
    private ContentTransformer imageMagickContentTransformer;

    public void setImageMagickContentTransformer(ContentTransformer imageMagickContentTransformer) {
        this.imageMagickContentTransformer = imageMagickContentTransformer;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        super.addParameterDefinitions(paramList);
        paramList.add(new ParameterDefinitionImpl(PARAM_CONVERT_COMMAND, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_CONVERT_COMMAND)));
    }

    public void setTransformerDebug(TransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTransform(Action ruleAction, NodeRef sourceNodeRef, ContentReader contentReader, NodeRef destinationNodeRef, ContentWriter contentWriter) {
        String convertCommand = (String)((Object)ruleAction.getParameterValue(PARAM_CONVERT_COMMAND));
        ImageTransformationOptions imageOptions = new ImageTransformationOptions();
        imageOptions.setCommandOptions(convertCommand);
        imageOptions.setSourceNodeRef(sourceNodeRef);
        String sourceMimetype = contentReader.getMimetype();
        String targetMimetype = contentWriter.getMimetype();
        long sourceSize = contentReader.getSize();
        try {
            this.transformerDebug.pushAvailable(contentReader.getContentUrl(), sourceMimetype, targetMimetype, imageOptions);
            ArrayList<ContentTransformer> transformers = new ArrayList<ContentTransformer>(1);
            if (this.imageMagickContentTransformer.isTransformable(sourceMimetype, contentReader.getSize(), targetMimetype, imageOptions)) {
                transformers.add(this.imageMagickContentTransformer);
            }
            this.transformerDebug.availableTransformers(transformers, sourceSize, "ImageTransformActionExecuter.doTransform(...)");
            if (transformers.size() == 0) {
                throw new NoTransformerException(sourceMimetype, targetMimetype);
            }
            this.imageMagickContentTransformer.transform(contentReader, contentWriter, imageOptions);
        }
        finally {
            this.transformerDebug.popAvailable();
        }
    }
}

