/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.scheduled;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.repo.action.scheduled.FreeMarkerWithLuceneExtensionsModelFactory;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.TemplateException;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public class FreeMarkerModelLuceneFunctionTest
extends TestCase {
    private static SimpleDateFormat SDF2 = new SimpleDateFormat("yyyy-MM-dd");
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuthenticationComponent authenticationComponent;
    private ServiceRegistry serviceRegistry;
    private UserTransaction tx;

    public FreeMarkerModelLuceneFunctionTest() {
    }

    public FreeMarkerModelLuceneFunctionTest(String arg0) {
        super(arg0);
    }

    public void setUp() throws Exception {
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        TransactionService transactionService = (TransactionService)ctx.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        this.tx = transactionService.getUserTransaction();
        this.tx.begin();
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        this.tx.rollback();
        super.tearDown();
    }

    public void testDate() {
        String template = "${date?date?string(\"yyyy-MM-dd\")}";
        FreeMarkerWithLuceneExtensionsModelFactory mf = new FreeMarkerWithLuceneExtensionsModelFactory();
        mf.setServiceRegistry(this.serviceRegistry);
        String result = this.serviceRegistry.getTemplateService().processTemplateString("freemarker", template, mf.getModel());
        FreeMarkerModelLuceneFunctionTest.assertEquals((String)result, (String)SDF2.format(new Date()));
    }

    public void testLuceneDateRangeFunction() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, 2001);
        cal.set(2, 1);
        cal.set(5, 1);
        String isoStartDate = ISO8601DateFormat.format((Date)cal.getTime());
        cal.add(5, 1);
        String isoEndDate = ISO8601DateFormat.format((Date)cal.getTime());
        String template = "${luceneDateRange(\"" + isoStartDate + "\", \"P1D\")}";
        FreeMarkerWithLuceneExtensionsModelFactory mf = new FreeMarkerWithLuceneExtensionsModelFactory();
        mf.setServiceRegistry(this.serviceRegistry);
        String result = this.serviceRegistry.getTemplateService().processTemplateString("freemarker", template, mf.getModel());
        FreeMarkerModelLuceneFunctionTest.assertEquals((String)result, (String)("[" + isoStartDate + " TO " + isoEndDate + "]"));
    }

    public void testLuceneDateRangeFunctionToDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, 2001);
        cal.set(2, 1);
        cal.set(5, 1);
        String isoStartDate = ISO8601DateFormat.format((Date)cal.getTime());
        cal.add(5, 4);
        String isoEndDate = ISO8601DateFormat.format((Date)cal.getTime());
        String template = "${luceneDateRange(\"" + isoStartDate + "\", \"" + isoEndDate + "\")}";
        FreeMarkerWithLuceneExtensionsModelFactory mf = new FreeMarkerWithLuceneExtensionsModelFactory();
        mf.setServiceRegistry(this.serviceRegistry);
        String result = this.serviceRegistry.getTemplateService().processTemplateString("freemarker", template, mf.getModel());
        FreeMarkerModelLuceneFunctionTest.assertEquals((String)result, (String)("[" + isoStartDate + " TO " + isoEndDate + "]"));
    }

    public void testLuceneDateRangeFunctionTodayPlus4() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        String isoStartDate = ISO8601DateFormat.format((Date)cal.getTime());
        cal.add(5, 4);
        String isoEndDate = ISO8601DateFormat.format((Date)cal.getTime());
        String template = "${luceneDateRange(today, \"P4D\")}";
        FreeMarkerWithLuceneExtensionsModelFactory mf = new FreeMarkerWithLuceneExtensionsModelFactory();
        mf.setServiceRegistry(this.serviceRegistry);
        String result = this.serviceRegistry.getTemplateService().processTemplateString("freemarker", template, mf.getModel());
        FreeMarkerModelLuceneFunctionTest.assertNotNull((Object)result);
        FreeMarkerModelLuceneFunctionTest.assertEquals((String)result, (String)("[" + isoStartDate + " TO " + isoEndDate + "]"));
    }

    public void testLuceneDateRangeFunctionTodayMinus4() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        String isoStartDate = ISO8601DateFormat.format((Date)cal.getTime());
        cal.add(5, -4);
        String isoEndDate = ISO8601DateFormat.format((Date)cal.getTime());
        String template = "${luceneDateRange(today, \"-P4D\")}";
        FreeMarkerWithLuceneExtensionsModelFactory mf = new FreeMarkerWithLuceneExtensionsModelFactory();
        mf.setServiceRegistry(this.serviceRegistry);
        String result = this.serviceRegistry.getTemplateService().processTemplateString("freemarker", template, mf.getModel());
        FreeMarkerModelLuceneFunctionTest.assertEquals((String)result, (String)("[" + isoEndDate + " TO " + isoStartDate + "]"));
    }

    public void testLuceneDateRangeFunctionTodayToday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        String isoStartDate = ISO8601DateFormat.format((Date)cal.getTime());
        String template = "${luceneDateRange(today, today)}";
        FreeMarkerWithLuceneExtensionsModelFactory mf = new FreeMarkerWithLuceneExtensionsModelFactory();
        mf.setServiceRegistry(this.serviceRegistry);
        String result = this.serviceRegistry.getTemplateService().processTemplateString("freemarker", template, mf.getModel());
        FreeMarkerModelLuceneFunctionTest.assertEquals((String)result, (String)("[" + isoStartDate + " TO " + isoStartDate + "]"));
    }

    public void testSelectSingleNode() {
        String renderingSpaceNodeRef = "workspace://SpacesStore/rendering_actions_space";
        String rendering_space = "rendering_actions";
        String path = "'PATH:\"/app:company_home/app:dictionary/app:" + rendering_space + "\"'";
        String template = "${selectSingleNode('workspace://SpacesStore', 'lucene', " + path + " )}";
        FreeMarkerWithLuceneExtensionsModelFactory mf = new FreeMarkerWithLuceneExtensionsModelFactory();
        mf.setServiceRegistry(this.serviceRegistry);
        String result = this.serviceRegistry.getTemplateService().processTemplateString("freemarker", template, mf.getModel());
        FreeMarkerModelLuceneFunctionTest.assertEquals((String)result, (String)renderingSpaceNodeRef);
        String invalidSpace = "DOESnotEXISTspace";
        path = "'PATH:\"/app:company_home/app:dictionary/app:" + invalidSpace + "\"'";
        template = "${selectSingleNode('workspace://SpacesStore', 'lucene', " + path + " )}";
        try {
            result = this.serviceRegistry.getTemplateService().processTemplateString("freemarker", template, mf.getModel());
            FreeMarkerModelLuceneFunctionTest.fail((String)("Shouldn't find anything, but got" + result));
        }
        catch (TemplateException e) {
            // empty catch block
        }
    }
}

