/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import org.alfresco.repo.activities.ActivityPostServiceImpl;
import org.alfresco.repo.activities.feed.FeedGenerator;
import org.alfresco.repo.activities.feed.RepoCtx;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;

public abstract class AbstractFeedGenerator
implements FeedGenerator {
    private static Log logger = LogFactory.getLog(AbstractFeedGenerator.class);
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"ActivityFeedGenerator");
    private static final long LOCK_TTL = 30000L;
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener(AbstractFeedGenerator.class.getName());
    private int maxItemsPerCycle = 100;
    private ActivityPostDAO postDAO;
    private ActivityPostServiceImpl activityPostServiceImpl;
    private AuthenticationService authenticationService;
    private SysAdminParams sysAdminParams;
    private TransactionService transactionService;
    private JobLockService jobLockService;
    private String repoEndPoint;
    private boolean userNamesAreCaseSensitive = false;
    private RepoCtx ctx = null;
    private volatile boolean busy;

    public void setActivityPostServiceImpl(ActivityPostServiceImpl activityPostServiceImpl) {
        this.activityPostServiceImpl = activityPostServiceImpl;
    }

    public void setPostDAO(ActivityPostDAO postDAO) {
        this.postDAO = postDAO;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setRepoEndPoint(String repoEndPoint) {
        this.repoEndPoint = repoEndPoint;
    }

    public void setUserNamesAreCaseSensitive(boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
    }

    public void setMaxItemsPerCycle(int maxItemsPerCycle) {
        this.maxItemsPerCycle = maxItemsPerCycle;
    }

    public int getMaxItemsPerCycle() {
        return this.maxItemsPerCycle;
    }

    public ActivityPostDAO getPostDaoService() {
        return this.postDAO;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public RepoCtx getWebScriptsCtx() {
        return this.ctx;
    }

    public void init() throws Exception {
        this.ctx = new RepoCtx(this.sysAdminParams, this.repoEndPoint);
        this.ctx.setUserNamesAreCaseSensitive(this.userNamesAreCaseSensitive);
        this.busy = false;
    }

    private void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"postDAO", (Object)this.postDAO);
        this.activityPostServiceImpl.setEstimatedGridSize(this.getEstimatedGridSize());
    }

    @Override
    public abstract int getEstimatedGridSize();

    protected boolean isActive() {
        return this.busy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void execute() throws JobExecutionException {
        block13: {
            this.checkProperties();
            if (!this.transactionService.getAllowWrite()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Activities feed generator not running due to read-only server");
                }
                return;
            }
            String lockToken = null;
            try {
                LockCallback lockCallback = new LockCallback();
                lockToken = this.acquireLock(lockCallback);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Activities feed generator started");
                }
                this.generate();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Activities feed generator completed");
                }
                this.releaseLock(lockToken);
            }
            catch (LockAcquisitionException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Activities feed generator already underway");
                }
            }
            catch (Throwable e2) {
                if (!vmShutdownListener.isVmShuttingDown()) {
                    logger.error((Object)"Exception during generation of feeds", e2);
                }
                this.releaseLock(lockToken);
                break block13;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.releaseLock(lockToken);
            }
        }
    }

    protected abstract boolean generate() throws Exception;

    private String acquireLock(JobLockService.JobLockRefreshCallback lockCallback) throws LockAcquisitionException {
        String lockToken = this.jobLockService.getLock(LOCK_QNAME, 30000L);
        this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 30000L, lockCallback);
        this.busy = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("lock aquired:  " + lockToken));
        }
        return lockToken;
    }

    private void releaseLock(String lockToken) {
        if (lockToken != null) {
            this.busy = false;
            this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
            if (logger.isInfoEnabled()) {
                logger.debug((Object)("Lock released (refresh failed): " + LOCK_QNAME + ", lock token " + lockToken));
            }
        }
    }

    private class LockCallback
    implements JobLockService.JobLockRefreshCallback {
        private LockCallback() {
        }

        @Override
        public boolean isActive() {
            return AbstractFeedGenerator.this.busy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lockReleased() {
            LockCallback lockCallback = this;
            synchronized (lockCallback) {
                if (logger.isInfoEnabled()) {
                    logger.debug((Object)("Lock released (refresh failed): " + LOCK_QNAME));
                }
                AbstractFeedGenerator.this.busy = false;
            }
        }
    }
}

