/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.URLDecoder;

public class AVMToADMRemoteStorePatch
extends AbstractPatch {
    private static final Log logger = LogFactory.getLog(AVMToADMRemoteStorePatch.class);
    private static final String MSG_MIGRATION_COMPLETE = "patch.avmToAdmRemoteStore.complete";
    private static final String SITE_CACHE_ID = "_SITE_CACHE";
    private static final Pattern USER_PATTERN_1 = Pattern.compile(".*/components/.*\\.user~(.*)~.*");
    private static final Pattern USER_PATTERN_2 = Pattern.compile(".*/pages/user/(.*?)(/.*)?$");
    private static final Pattern SITE_PATTERN_1 = Pattern.compile(".*/components/.*\\.site~(.*)~.*");
    private static final Pattern SITE_PATTERN_2 = Pattern.compile(".*/pages/site/(.*?)(/.*)?$");
    private static final String SURF_CONFIG = "surf-config";
    private static final int SITE_BATCH_THREADS = 4;
    private static final int SITE_BATCH_SIZE = 250;
    private static final int MIGRATE_BATCH_THREADS = 4;
    private static final int MIGRATE_BATCH_SIZE = 250;
    private Map<String, NodeRef> siteReferenceCache = null;
    private SortedMap<String, AVMNodeDescriptor> paths;
    private SortedMap<String, AVMNodeDescriptor> retryPaths;
    private NodeRef surfConfigRef = null;
    private ThreadLocal<Pair<String, NodeRef>> lastFolderCache = new ThreadLocal<Pair<String, NodeRef>>(){

        @Override
        protected Pair<String, NodeRef> initialValue() {
            return new Pair((Object)"", null);
        }
    };
    private ContentService contentService;
    private FileFolderService fileFolderService;
    private SiteService siteService;
    private AVMService avmService;
    private RuleService ruleService;
    private HiddenAspect hiddenAspect;
    private String avmStore;
    private String avmRootPath = "/";

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setAvmStore(String avmStore) {
        this.avmStore = avmStore;
    }

    public void setAvmRootPath(String avmRootPath) {
        if (avmRootPath != null && avmRootPath.length() != 0) {
            this.avmRootPath = avmRootPath;
        }
    }

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    @Override
    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull(this.avmService, "avmService");
        this.checkPropertyNotNull(this.avmStore, "avmStore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String applyInternal() throws Exception {
        this.retryPaths = new TreeMap<String, AVMNodeDescriptor>();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Exception {
                long start = System.currentTimeMillis();
                AVMToADMRemoteStorePatch.this.paths = AVMToADMRemoteStorePatch.this.retrieveAVMPaths();
                logger.info((Object)("Retrieved: " + AVMToADMRemoteStorePatch.this.paths.size() + " AVM paths in " + (System.currentTimeMillis() - start) + "ms"));
                AVMToADMRemoteStorePatch.this.surfConfigRef = AVMToADMRemoteStorePatch.this.getSurfConfigNodeRef(AVMToADMRemoteStorePatch.this.siteService.getSiteRoot());
                ArrayList<String> folderPath = new ArrayList<String>(4);
                folderPath.add("components");
                FileFolderUtil.makeFolders(AVMToADMRemoteStorePatch.this.fileFolderService, AVMToADMRemoteStorePatch.this.surfConfigRef, folderPath, ContentModel.TYPE_FOLDER);
                folderPath.clear();
                folderPath.add("pages");
                folderPath.add("user");
                FileFolderUtil.makeFolders(AVMToADMRemoteStorePatch.this.fileFolderService, AVMToADMRemoteStorePatch.this.surfConfigRef, folderPath, ContentModel.TYPE_FOLDER);
                return null;
            }
        };
        this.transactionHelper.doInTransaction(work, false, true);
        try {
            this.siteReferenceCache = new ConcurrentHashMap<String, NodeRef>(16384);
            String systemUser = AuthenticationUtil.getSystemUserName();
            final String tenantSystemUser = this.tenantAdminService.getDomainUser(systemUser, this.tenantAdminService.getCurrentUserDomain());
            final HashSet<String> sites = new HashSet<String>(this.paths.size());
            for (String path : this.paths.keySet()) {
                String siteName = null;
                Matcher matcher = SITE_PATTERN_1.matcher(path);
                if (matcher.matches()) {
                    siteName = matcher.group(1);
                } else {
                    matcher = SITE_PATTERN_2.matcher(path);
                    if (matcher.matches()) {
                        siteName = matcher.group(1);
                    }
                }
                if (siteName == null) continue;
                sites.add(siteName);
            }
            final Iterator siteItr = sites.iterator();
            BatchProcessWorkProvider<String> siteWorkProvider = new BatchProcessWorkProvider<String>(){

                @Override
                public synchronized Collection<String> getNextWork() {
                    int batchCount = 0;
                    ArrayList<String> siteBatch = new ArrayList<String>(250);
                    while (siteItr.hasNext() && batchCount++ != 250) {
                        siteBatch.add((String)siteItr.next());
                    }
                    return siteBatch;
                }

                @Override
                public synchronized int getTotalEstimatedWorkSize() {
                    return sites.size();
                }
            };
            BatchProcessor<String> siteBatchProcessor = new BatchProcessor<String>("AVMToADMRemoteStorePatch", this.transactionHelper, siteWorkProvider, 4, 250, this.applicationEventPublisher, logger, 2500);
            BatchProcessor.BatchProcessWorker<String> siteWorker = new BatchProcessor.BatchProcessWorker<String>(){

                @Override
                public void beforeProcess() throws Throwable {
                    AVMToADMRemoteStorePatch.this.ruleService.disableRules();
                    AuthenticationUtil.setRunAsUser((String)tenantSystemUser);
                }

                @Override
                public void afterProcess() throws Throwable {
                    AVMToADMRemoteStorePatch.this.ruleService.enableRules();
                    AuthenticationUtil.clearCurrentSecurityContext();
                }

                @Override
                public String getIdentifier(String entry) {
                    return entry;
                }

                @Override
                public void process(String siteName) throws Throwable {
                    NodeRef siteRef = AVMToADMRemoteStorePatch.this.getSiteNodeRef(siteName);
                    if (siteRef != null) {
                        NodeRef surfConfigRef = AVMToADMRemoteStorePatch.this.getSurfConfigNodeRef(siteRef);
                        AVMToADMRemoteStorePatch.this.siteReferenceCache.put(siteName, surfConfigRef);
                        ArrayList<String> folderPath = new ArrayList<String>(4);
                        folderPath.add("components");
                        FileFolderUtil.makeFolders(AVMToADMRemoteStorePatch.this.fileFolderService, surfConfigRef, folderPath, ContentModel.TYPE_FOLDER);
                        folderPath.clear();
                        folderPath.add("pages");
                        folderPath.add("site");
                        FileFolderUtil.makeFolders(AVMToADMRemoteStorePatch.this.fileFolderService, surfConfigRef, folderPath, ContentModel.TYPE_FOLDER);
                    } else {
                        logger.info((Object)("WARNING: unable to find site id: " + siteName));
                    }
                }
            };
            long start = System.currentTimeMillis();
            siteBatchProcessor.process(siteWorker, true);
            logger.info((Object)("Created 'surf-config' folders for: " + this.siteReferenceCache.size() + " sites in " + (System.currentTimeMillis() - start) + "ms"));
            final Iterator<String> pathItr = this.paths.keySet().iterator();
            BatchProcessWorkProvider<AVMNodeDescriptor> migrateWorkProvider = new BatchProcessWorkProvider<AVMNodeDescriptor>(){

                @Override
                public synchronized Collection<AVMNodeDescriptor> getNextWork() {
                    int batchCount = 0;
                    ArrayList<AVMNodeDescriptor> nodes = new ArrayList<AVMNodeDescriptor>(250);
                    while (pathItr.hasNext() && batchCount++ != 250) {
                        nodes.add((AVMNodeDescriptor)AVMToADMRemoteStorePatch.this.paths.get(pathItr.next()));
                    }
                    return nodes;
                }

                @Override
                public synchronized int getTotalEstimatedWorkSize() {
                    return AVMToADMRemoteStorePatch.this.paths.size();
                }
            };
            BatchProcessor<AVMNodeDescriptor> batchProcessor = new BatchProcessor<AVMNodeDescriptor>("AVMToADMRemoteStorePatch", this.transactionHelper, migrateWorkProvider, 4, 250, this.applicationEventPublisher, logger, 2500);
            BatchProcessor.BatchProcessWorker<AVMNodeDescriptor> worker = new BatchProcessor.BatchProcessWorker<AVMNodeDescriptor>(){

                @Override
                public void beforeProcess() throws Throwable {
                    AVMToADMRemoteStorePatch.this.ruleService.disableRules();
                    AuthenticationUtil.setRunAsUser((String)tenantSystemUser);
                }

                @Override
                public void afterProcess() throws Throwable {
                    AVMToADMRemoteStorePatch.this.ruleService.enableRules();
                    AuthenticationUtil.clearCurrentSecurityContext();
                }

                @Override
                public String getIdentifier(AVMNodeDescriptor entry) {
                    return entry.getPath();
                }

                @Override
                public void process(AVMNodeDescriptor entry) throws Throwable {
                    AVMToADMRemoteStorePatch.this.migrateNode(entry);
                }
            };
            batchProcessor.process(worker, true);
            if (this.retryPaths.size() != 0) {
                logger.info((Object)("Retrying " + this.retryPaths.size() + " paths..."));
                work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    @Override
                    public Void execute() throws Exception {
                        for (String path : AVMToADMRemoteStorePatch.this.retryPaths.keySet()) {
                            AVMToADMRemoteStorePatch.this.migrateNode((AVMNodeDescriptor)AVMToADMRemoteStorePatch.this.retryPaths.get(path));
                        }
                        return null;
                    }
                };
                this.transactionHelper.doInTransaction(work, false, true);
            }
            logger.info((Object)("Migrated: " + this.paths.size() + " AVM nodes to DM in " + (System.currentTimeMillis() - start) + "ms"));
        }
        finally {
            this.siteReferenceCache = null;
        }
        return I18NUtil.getMessage((String)MSG_MIGRATION_COMPLETE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateNode(AVMNodeDescriptor avmNode) {
        block29: {
            String path = avmNode.getPath();
            boolean debug = logger.isDebugEnabled();
            int index = path.indexOf(this.avmRootPath);
            if (index != -1) {
                String folderKey;
                NodeRef surfConfigRef;
                path = path.substring(index + this.avmRootPath.length());
                if (debug) {
                    logger.debug((Object)("...processing path: " + path));
                }
                ArrayList<String> pathElements = new ArrayList<String>(4);
                StringTokenizer t = new StringTokenizer(path, "/");
                while (t.hasMoreTokens()) {
                    pathElements.add(t.nextToken());
                }
                String userId = null;
                String siteName = null;
                Matcher matcher = USER_PATTERN_1.matcher(path);
                if (matcher.matches()) {
                    userId = URLDecoder.decode((String)matcher.group(1));
                } else {
                    matcher = USER_PATTERN_2.matcher(path);
                    if (matcher.matches()) {
                        userId = URLDecoder.decode((String)matcher.group(1));
                    } else {
                        matcher = SITE_PATTERN_1.matcher(path);
                        if (matcher.matches()) {
                            siteName = matcher.group(1);
                        } else {
                            matcher = SITE_PATTERN_2.matcher(path);
                            if (matcher.matches()) {
                                siteName = matcher.group(1);
                            }
                        }
                    }
                }
                if (siteName != null) {
                    if (debug) {
                        logger.debug((Object)("...resolved site id: " + siteName));
                    }
                    if ((surfConfigRef = this.siteReferenceCache.get(siteName)) == null) {
                        logger.info((Object)("WARNING: unable to migrate path as site id cannot be found: " + siteName));
                    }
                } else if (userId != null) {
                    if (debug) {
                        logger.debug((Object)("...resolved user id: " + userId));
                    }
                    surfConfigRef = this.surfConfigRef;
                } else {
                    if (debug) {
                        logger.debug((Object)"...resolved generic path.");
                    }
                    surfConfigRef = this.surfConfigRef;
                }
                List<String> folderPath = pathElements.subList(0, pathElements.size() - 1);
                NodeRef parentFolder = null;
                Pair<String, NodeRef> lastFolderCache = this.lastFolderCache.get();
                String string = folderKey = siteName != null ? siteName + folderPath.toString() : folderPath.toString();
                if (folderKey.equals(lastFolderCache.getFirst())) {
                    if (debug) {
                        logger.debug((Object)("...cache hit - matched last folder reference: " + folderKey));
                    }
                    parentFolder = (NodeRef)lastFolderCache.getSecond();
                }
                if (parentFolder == null) {
                    try {
                        parentFolder = FileFolderUtil.makeFolders(this.fileFolderService, surfConfigRef, folderPath, ContentModel.TYPE_FOLDER).getNodeRef();
                    }
                    catch (FileExistsException fe) {
                        logger.warn((Object)("Unable to create folder: " + fe.getName() + " for path: " + avmNode.getPath() + " - as another txn is busy, will retry later."));
                        this.retryPaths.put(avmNode.getPath(), avmNode);
                        return;
                    }
                    lastFolderCache.setFirst((Object)folderKey);
                    lastFolderCache.setSecond((Object)parentFolder);
                }
                try {
                    if (userId != null) {
                        AuthenticationUtil.pushAuthentication();
                        AuthenticationUtil.setFullyAuthenticatedUser((String)userId);
                        try {
                            FileInfo fileInfo = this.fileFolderService.create(parentFolder, avmNode.getName(), ContentModel.TYPE_CONTENT);
                            HashMap<QName, Boolean> aspectProperties = new HashMap<QName, Boolean>(1, 1.0f);
                            aspectProperties.put(ContentModel.PROP_IS_INDEXED, false);
                            this.nodeService.addAspect(fileInfo.getNodeRef(), ContentModel.ASPECT_INDEX_CONTROL, aspectProperties);
                            ContentWriter writer = this.contentService.getWriter(fileInfo.getNodeRef(), ContentModel.PROP_CONTENT, true);
                            writer.guessMimetype(fileInfo.getName());
                            writer.putContent(this.avmService.getContentReader(-1, avmNode.getPath()));
                            break block29;
                        }
                        finally {
                            AuthenticationUtil.popAuthentication();
                        }
                    }
                    FileInfo fileInfo = this.fileFolderService.create(parentFolder, avmNode.getName(), ContentModel.TYPE_CONTENT);
                    HashMap<QName, Boolean> aspectProperties = new HashMap<QName, Boolean>(1, 1.0f);
                    aspectProperties.put(ContentModel.PROP_IS_INDEXED, false);
                    this.nodeService.addAspect(fileInfo.getNodeRef(), ContentModel.ASPECT_INDEX_CONTROL, aspectProperties);
                    ContentWriter writer = this.contentService.getWriter(fileInfo.getNodeRef(), ContentModel.PROP_CONTENT, true);
                    writer.guessMimetype(fileInfo.getName());
                    writer.putContent(this.avmService.getContentReader(-1, avmNode.getPath()));
                }
                catch (InvalidNodeRefException refErr) {
                    logger.warn((Object)("Parent folder does not exist yet: " + refErr.getNodeRef() + " for path: " + avmNode.getPath() + " - as another txn is busy, will retry later."));
                    this.retryPaths.put(avmNode.getPath(), avmNode);
                }
            }
        }
    }

    private NodeRef getSiteNodeRef(String shortName) {
        SiteInfo siteInfo = this.siteService.getSite(shortName);
        return siteInfo != null ? siteInfo.getNodeRef() : null;
    }

    private NodeRef getSurfConfigNodeRef(NodeRef rootRef) {
        NodeRef surfConfigRef = this.nodeService.getChildByName(rootRef, ContentModel.ASSOC_CONTAINS, SURF_CONFIG);
        if (surfConfigRef == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"'surf-config' folder not found under current path, creating...");
            }
            QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)SURF_CONFIG);
            HashMap<QName, String> properties = new HashMap<QName, String>(1, 1.0f);
            properties.put(ContentModel.PROP_NAME, SURF_CONFIG);
            try {
                ChildAssociationRef ref = this.nodeService.createNode(rootRef, ContentModel.ASSOC_CONTAINS, assocQName, ContentModel.TYPE_FOLDER, properties);
                surfConfigRef = ref.getChildRef();
                this.hiddenAspect.hideNode(ref.getChildRef());
            }
            catch (DuplicateChildNodeNameException dupErr) {
                throw new ConcurrencyFailureException("Forcing batch retry due to DuplicateChildNodeNameException", (Throwable)dupErr);
            }
        }
        return surfConfigRef;
    }

    private SortedMap<String, AVMNodeDescriptor> retrieveAVMPaths() throws Exception {
        logger.info((Object)("Retrieving paths from AVM store: " + this.avmStore + ":" + this.avmRootPath));
        TreeMap<String, AVMNodeDescriptor> paths = new TreeMap<String, AVMNodeDescriptor>();
        String avmPath = this.avmStore + ":" + this.avmRootPath;
        AVMNodeDescriptor node = this.avmService.lookup(-1, avmPath);
        if (node != null) {
            this.traverseNode(paths, node);
        }
        logger.info((Object)("Found: " + paths.size() + " AVM files nodes to migrate"));
        return paths;
    }

    private void traverseNode(SortedMap<String, AVMNodeDescriptor> paths, AVMNodeDescriptor node) throws IOException {
        boolean debug = logger.isDebugEnabled();
        SortedMap<String, AVMNodeDescriptor> listing = this.avmService.getDirectoryListing(node);
        for (AVMNodeDescriptor n : listing.values()) {
            if (n.isFile()) {
                if (debug) {
                    logger.debug((Object)("...adding path: " + n.getPath()));
                }
                paths.put(n.getPath(), n);
                if (paths.size() % 10000 != 0) continue;
                logger.info((Object)("Collected " + paths.size() + " AVM paths..."));
                continue;
            }
            if (!n.isDirectory()) continue;
            this.traverseNode(paths, n);
        }
    }
}

