/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.Savepoint;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.alfresco.error.StackTraceUtil;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.admin.patch.PatchExecuter;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.domain.control.ControlDAO;
import org.alfresco.repo.domain.node.ChildAssocEntity;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class FixNameCrcValuesPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.fixNameCrcValues.result";
    private static final String MSG_REWRITTEN = "patch.fixNameCrcValues.fixed";
    private static final String MSG_UNABLE_TO_CHANGE = "patch.fixNameCrcValues.unableToChange";
    private static final String MSG_FIXING_LOCALNAME = "patch.fixNameCrcValues.fixingLocalname";
    private static final String ERR_ASSOCIATION_TYPE_NOT_DEFINED = "patch.fixNameCrcValues.associationTypeNotDefined";
    private static final String ERR_ASSOCIATION_TYPE_NOT_CHILD = "patch.fixNameCrcValues.associationTypeNotChild";
    private PatchDAO patchDAO;
    private QNameDAO qnameDAO;
    private ControlDAO controlDAO;
    private DictionaryService dictionaryService;
    private int batchThreads = 2;
    private int batchSize = 1000;
    private long batchMaxQueryRange = Long.MAX_VALUE;
    private int batchQuerySize = 2000;
    private static Log logger = LogFactory.getLog(FixNameCrcValuesPatch.class);
    private static Log progress_logger = LogFactory.getLog(PatchExecuter.class);

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setControlDAO(ControlDAO controlDAO) {
        this.controlDAO = controlDAO;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setBatchThreads(int batchThreads) {
        this.batchThreads = batchThreads;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchMaxQueryRange(long batchMaxQueryRange) {
        this.batchMaxQueryRange = batchMaxQueryRange;
    }

    public void setBatchQuerySize(int batchQuerySize) {
        this.batchQuerySize = batchQuerySize;
    }

    @Override
    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull(this.patchDAO, "patchDAO");
        this.checkPropertyNotNull(this.qnameDAO, "qnameDAO");
        this.checkPropertyNotNull(this.controlDAO, "controlDAO");
        this.checkPropertyNotNull(this.dictionaryService, "dictionaryService");
        this.checkPropertyNotNull(this.applicationEventPublisher, "applicationEventPublisher");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String applyInternal() throws Exception {
        FixNameCrcValuesHelper helper = new FixNameCrcValuesHelper();
        try {
            String msg;
            String string = msg = helper.fixCrcValues();
            return string;
        }
        finally {
            helper.closeWriter();
        }
    }

    private class FixNameCrcValuesHelper {
        private File logFile;
        private FileChannel channel;
        private Integer assocCount;
        private Long minAssocId = 0L;
        private Long maxAssocId;

        private FixNameCrcValuesHelper() throws IOException {
            File tempDir = TempFileProvider.getLongLifeTempDir((String)"patches");
            this.logFile = new File(tempDir, "FixNameCrcValuesPatch.log");
            RandomAccessFile outputFile = new RandomAccessFile(this.logFile, "rw");
            this.channel = outputFile.getChannel();
            this.channel.position(this.channel.size());
            this.writeLine("").writeLine("");
            this.writeLine("FixNameCrcValuesPatch executing on " + new Date());
        }

        private FixNameCrcValuesHelper write(Object obj) throws IOException {
            this.channel.write(ByteBuffer.wrap(obj.toString().getBytes("UTF-8")));
            return this;
        }

        private FixNameCrcValuesHelper writeLine(Object obj) throws IOException {
            this.write(obj);
            this.write("\n");
            return this;
        }

        private void closeWriter() {
            try {
                this.channel.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public String fixCrcValues() throws Exception {
            BatchProcessWorkProvider<Map<String, Object>> workProvider = new BatchProcessWorkProvider<Map<String, Object>>(){

                @Override
                public synchronized int getTotalEstimatedWorkSize() {
                    if (FixNameCrcValuesHelper.this.assocCount == null) {
                        FixNameCrcValuesHelper.this.assocCount = FixNameCrcValuesPatch.this.patchDAO.getChildAssocCount();
                    }
                    return FixNameCrcValuesHelper.this.assocCount;
                }

                @Override
                public synchronized Collection<Map<String, Object>> getNextWork() {
                    if (FixNameCrcValuesHelper.this.maxAssocId == null) {
                        FixNameCrcValuesHelper.this.maxAssocId = FixNameCrcValuesPatch.this.patchDAO.getMaxChildAssocId();
                    }
                    double total = this.getTotalEstimatedWorkSize();
                    long rangeMultipler = Math.round(FixNameCrcValuesHelper.this.maxAssocId.doubleValue() / total);
                    List<Map<String, Object>> results = FixNameCrcValuesPatch.this.patchDAO.getChildAssocsForCrcFix(FixNameCrcValuesHelper.this.minAssocId, FixNameCrcValuesHelper.this.maxAssocId, rangeMultipler, FixNameCrcValuesPatch.this.batchMaxQueryRange, FixNameCrcValuesPatch.this.batchQuerySize);
                    int resultsSize = results.size();
                    if (resultsSize > 0) {
                        Map<String, Object> lastResult = results.get(resultsSize - 1);
                        Long id = (Long)lastResult.get("id");
                        FixNameCrcValuesHelper.this.minAssocId = id + 1L;
                    }
                    return results;
                }
            };
            BatchProcessor<Map<String, Object>> batchProcessor = new BatchProcessor<Map<String, Object>>("FixNameCrcValuesPatch", FixNameCrcValuesPatch.this.transactionHelper, workProvider, FixNameCrcValuesPatch.this.batchThreads, FixNameCrcValuesPatch.this.batchSize, FixNameCrcValuesPatch.this.applicationEventPublisher, progress_logger, 1000);
            BatchProcessor.BatchProcessWorker<Map<String, Object>> worker = new BatchProcessor.BatchProcessWorker<Map<String, Object>>(){

                @Override
                public String getIdentifier(Map<String, Object> entry) {
                    return entry.toString();
                }

                @Override
                public void beforeProcess() throws Throwable {
                }

                @Override
                public void process(Map<String, Object> row) throws Throwable {
                    boolean requiresNameConstraint;
                    Long assocId = (Long)row.get("id");
                    Long typeQNameId = (Long)row.get("typeQNameId");
                    Long qnameNamespaceId = (Long)row.get("qnameNamespaceId");
                    String qnameLocalName = (String)row.get("qnameLocalName");
                    Long childNodeNameCrc = (Long)row.get("childNodeNameCrc");
                    Long qnameCrc = (Long)row.get("qnameCrc");
                    String childNodeUuid = (String)row.get("childNodeUuid");
                    String childNodeName = (String)row.get("childNodeName");
                    String string = childNodeName = childNodeName == null ? childNodeUuid : childNodeName;
                    if (qnameLocalName == null || qnameLocalName.length() == 0) {
                        String qnameLocalNameNew = "fix-" + assocId;
                        logger.warn((Object)I18NUtil.getMessage((String)FixNameCrcValuesPatch.MSG_FIXING_LOCALNAME, (Object[])new Object[]{assocId, qnameLocalName, qnameLocalNameNew}));
                        qnameLocalName = qnameLocalNameNew;
                    }
                    QName typeQName = (QName)FixNameCrcValuesPatch.this.qnameDAO.getQName(typeQNameId).getSecond();
                    String namespace = (String)FixNameCrcValuesPatch.this.qnameDAO.getNamespace(qnameNamespaceId).getSecond();
                    QName qname = QName.createQName((String)namespace, (String)qnameLocalName);
                    ChildAssocEntity entity = new ChildAssocEntity();
                    entity.setChildNodeNameAll(FixNameCrcValuesPatch.this.dictionaryService, typeQName, childNodeName);
                    entity.setQNameAll(FixNameCrcValuesPatch.this.qnameDAO, qname, false);
                    Long childNodeNameCrcNew = entity.getChildNodeNameCrc();
                    Long qnameCrcNew = entity.getQnameCrc();
                    entity = null;
                    AssociationDefinition assocDef = FixNameCrcValuesPatch.this.dictionaryService.getAssociation(typeQName);
                    if (assocDef == null) {
                        throw new DictionaryException(FixNameCrcValuesPatch.ERR_ASSOCIATION_TYPE_NOT_DEFINED, new Object[]{typeQName, assocId});
                    }
                    if (!assocDef.isChild()) {
                        throw new DictionaryException(FixNameCrcValuesPatch.ERR_ASSOCIATION_TYPE_NOT_CHILD, new Object[]{typeQName, assocId});
                    }
                    ChildAssociationDefinition childAssocDef = (ChildAssociationDefinition)assocDef;
                    boolean bl = requiresNameConstraint = !childAssocDef.getDuplicateChildNamesAllowed();
                    if (qnameCrcNew.equals(qnameCrc) && (childNodeNameCrcNew.equals(childNodeNameCrc) || childNodeNameCrc < 0L && !requiresNameConstraint)) {
                        return;
                    }
                    Savepoint savepoint = null;
                    try {
                        savepoint = FixNameCrcValuesPatch.this.controlDAO.createSavepoint("FixNameCrcValuesPatch");
                        FixNameCrcValuesPatch.this.patchDAO.updateChildAssocCrc(assocId, childNodeNameCrcNew, qnameCrcNew);
                        FixNameCrcValuesPatch.this.controlDAO.releaseSavepoint(savepoint);
                        String msg = I18NUtil.getMessage((String)FixNameCrcValuesPatch.MSG_REWRITTEN, (Object[])new Object[]{assocId, childNodeName, childNodeNameCrc, childNodeNameCrcNew, qname, qnameCrc, qnameCrcNew});
                        FixNameCrcValuesHelper.this.writeLine(msg);
                    }
                    catch (Throwable e) {
                        if (savepoint != null) {
                            FixNameCrcValuesPatch.this.controlDAO.rollbackToSavepoint(savepoint);
                        }
                        String msg = I18NUtil.getMessage((String)FixNameCrcValuesPatch.MSG_UNABLE_TO_CHANGE, (Object[])new Object[]{assocId, childNodeName, childNodeNameCrc, childNodeNameCrcNew, qname, qnameCrc, qnameCrcNew, e.getMessage()});
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)msg, e);
                        } else {
                            logger.warn((Object)msg);
                        }
                        StringBuilder sb = new StringBuilder(1024);
                        StackTraceUtil.buildStackTrace((String)msg, (StackTraceElement[])e.getStackTrace(), (StringBuilder)sb, (int)0);
                        FixNameCrcValuesHelper.this.writeLine(sb.toString());
                    }
                }

                @Override
                public void afterProcess() throws Throwable {
                }
            };
            int updated = batchProcessor.process(worker, true);
            String msg = I18NUtil.getMessage((String)FixNameCrcValuesPatch.MSG_SUCCESS, (Object[])new Object[]{updated, this.logFile});
            return msg;
        }
    }
}

