/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.springframework.extensions.surf.util.I18NUtil;

public class GenericBootstrapPatch
extends AbstractPatch {
    private static final String MSG_EXISTS = "patch.genericBootstrap.result.exists";
    private static final String MSG_CREATED = "patch.genericBootstrap.result.created";
    private static final String ERR_MULTIPLE_FOUND = "patch.genericBootstrap.err.multiple_found";
    private ImporterBootstrap importerBootstrap;
    private String checkPath;
    private Properties bootstrapView;

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setCheckPath(String checkPath) {
        this.checkPath = checkPath;
    }

    public void setBootstrapView(Properties bootstrapView) {
        this.bootstrapView = bootstrapView;
    }

    @Override
    protected void checkProperties() {
        this.checkPropertyNotNull((Object)this.importerBootstrap, "importerBootstrap");
        this.checkPropertyNotNull(this.bootstrapView, "bootstrapView");
        super.checkProperties();
    }

    @Override
    protected String applyInternal() throws Exception {
        StoreRef storeRef = this.importerBootstrap.getStoreRef();
        NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
        if (this.checkPath != null) {
            List results = this.searchService.selectNodes(rootNodeRef, this.checkPath, null, (NamespacePrefixResolver)this.namespaceService, false);
            if (results.size() > 1) {
                throw new PatchException(ERR_MULTIPLE_FOUND, this.checkPath);
            }
            if (results.size() == 1) {
                return I18NUtil.getMessage((String)MSG_EXISTS, (Object[])new Object[]{this.checkPath});
            }
        }
        String path = this.bootstrapView.getProperty("path");
        ArrayList<Properties> bootstrapViews = new ArrayList<Properties>(1);
        bootstrapViews.add(this.bootstrapView);
        this.importerBootstrap.setBootstrapViews(bootstrapViews);
        this.importerBootstrap.setUseExistingStore(true);
        this.importerBootstrap.bootstrap();
        return I18NUtil.getMessage((String)MSG_CREATED, (Object[])new Object[]{path, rootNodeRef});
    }
}

