/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class SpacesStoreGuestPermissionPatch
extends AbstractPatch {
    private static Log logger = LogFactory.getLog(SpacesStoreGuestPermissionPatch.class);
    private static final String MSG_RESULT = "patch.spacesStoreGuestPermission.result";
    private PermissionService permissionService;
    private ImporterBootstrap importerBootstrap;

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    @Override
    protected String applyInternal() throws Exception {
        StoreRef store = this.importerBootstrap.getStoreRef();
        if (store == null) {
            throw new PatchException("Bootstrap store has not been set");
        }
        NodeRef rootRef = this.nodeService.getRootNode(store);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Store Ref:" + store + " NodeRef: " + rootRef));
        }
        this.permissionService.setPermission(rootRef, AuthenticationUtil.getGuestUserName(), "Read", true);
        String sysQName = this.importerBootstrap.getConfiguration().getProperty("system.system_container.childname");
        String catQName = "cm:categoryRoot";
        List refs = this.nodeService.getChildAssocs(rootRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef ref : refs) {
            if (ref.getQName().equals((Object)QName.createQName((String)sysQName, (NamespacePrefixResolver)this.namespaceService))) {
                this.permissionService.setInheritParentPermissions(ref.getChildRef(), false);
                this.permissionService.setPermission(ref.getChildRef(), "GROUP_EVERYONE", "Read", true);
                continue;
            }
            if (!ref.getQName().equals((Object)QName.createQName((String)catQName, (NamespacePrefixResolver)this.namespaceService))) continue;
            this.permissionService.clearPermission(ref.getChildRef(), AuthenticationUtil.getGuestUserName());
        }
        return I18NUtil.getMessage((String)MSG_RESULT);
    }
}

