/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.avm.CreateVersionCallback;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.util.Pair;

public class CreateVersionTxnListener
extends TransactionListenerAdapter {
    private ThreadLocal<List<Pair<String, Integer>>> fCreatedVersions = new ThreadLocal();
    private List<CreateVersionCallback> fCallbacks = new ArrayList<CreateVersionCallback>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCommit() {
        List<Pair<String, Integer>> created = this.fCreatedVersions.get();
        if (created != null) {
            for (Pair<String, Integer> version : created) {
                CreateVersionTxnListener createVersionTxnListener = this;
                synchronized (createVersionTxnListener) {
                    for (CreateVersionCallback cb : this.fCallbacks) {
                        cb.versionCreated((String)version.getFirst(), (Integer)version.getSecond());
                    }
                }
            }
            this.fCreatedVersions.set(null);
        }
    }

    @Override
    public void afterRollback() {
        this.fCreatedVersions.set(null);
    }

    public void versionCreated(String storeName, int versionID) {
        List<Pair<String, Integer>> created = this.fCreatedVersions.get();
        if (created == null) {
            created = new ArrayList<Pair<String, Integer>>();
            this.fCreatedVersions.set(created);
        }
        created.add((Pair<String, Integer>)new Pair((Object)storeName, (Object)versionID));
    }

    public synchronized void addCallback(CreateVersionCallback cb) {
        this.fCallbacks.add(cb);
    }
}

