/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.repo.avm.AVMRemoteLocal;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.remote.AVMRemote;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class BulkLoader {
    private AVMRemote fService;
    private int fPropertyCount = 0;

    public void setAvmService(AVMService service) {
        this.fService = new AVMRemoteLocal();
        ((AVMRemoteLocal)this.fService).setAvmService(service);
    }

    protected void setAvmRemoteService(AVMRemote service) {
        this.fService = service;
    }

    public void setPropertyCount(int propCount) {
        this.fPropertyCount = propCount;
    }

    public void recursiveLoad(String fsPath, String repPath) {
        Pair<Integer, Integer> cnts = this.recursiveLoadImpl(fsPath, repPath, 0, 0);
        System.out.println("Loaded: " + cnts.getFirst() + " directories, " + cnts.getSecond() + " files");
    }

    private Pair<Integer, Integer> recursiveLoadImpl(String fsPath, String repPath, int dirCount, int fileCount) {
        HashMap<QName, PropertyValue> props = new HashMap<QName, PropertyValue>();
        for (int i = 0; i < this.fPropertyCount; ++i) {
            props.put(QName.createQName((String)"silly", (String)("prop" + i)), new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)("I am property " + i))));
        }
        File file = new File(fsPath);
        String name = file.getName();
        if (file.isDirectory()) {
            this.fService.createDirectory(repPath, name);
            ++dirCount;
            String[] children = file.list();
            String baseName = repPath.endsWith("/") ? repPath + name : repPath + "/" + name;
            this.fService.setNodeProperties(baseName, props);
            for (String child : children) {
                Pair<Integer, Integer> cnts = this.recursiveLoadImpl(fsPath + "/" + child, baseName, dirCount, fileCount);
                dirCount = (Integer)cnts.getFirst();
                fileCount = (Integer)cnts.getSecond();
            }
            return new Pair((Object)dirCount, (Object)fileCount);
        }
        try {
            FileInputStream in = new FileInputStream(file);
            OutputStream out = this.fService.createFile(repPath, name);
            ++fileCount;
            this.fService.setNodeProperties(repPath + "/" + name, props);
            byte[] buff = new byte[8192];
            int read = 0;
            while ((read = ((InputStream)in).read(buff)) != -1) {
                out.write(buff, 0, read);
            }
            out.close();
            ((InputStream)in).close();
            return new Pair((Object)dirCount, (Object)fileCount);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            throw new AVMException("I/O Error", e);
        }
    }
}

