/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;

public class BulkReader {
    private AVMService fService;

    public void setAvmService(AVMService service) {
        this.fService = service;
    }

    public void recursiveFutz(String store, String path, int futz) {
        ArrayList<String> paths = new ArrayList<String>();
        this.recursiveRead(path, paths);
        Random random = new Random(System.currentTimeMillis());
        int futzed = 0;
        while (futzed < futz) {
            String futzPath = (String)paths.get(random.nextInt(paths.size()));
            AVMNodeDescriptor desc = this.fService.lookup(-1, futzPath);
            if (!desc.isFile()) continue;
            try {
                this.fService.getFileOutputStream(futzPath).close();
            }
            catch (IOException e) {
                // empty catch block
            }
            ++futzed;
        }
        this.fService.createSnapshot(store, null, null);
    }

    public void recursiveRead(String path, List<String> paths) {
        AVMNodeDescriptor desc = this.fService.lookup(-1, path);
        paths.add(desc.getPath());
        if (desc.isFile()) {
            InputStream in = this.fService.getFileInputStream(desc);
            try {
                byte[] buff = new byte[8192];
                while (in.read(buff) != -1) {
                }
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        SortedMap<String, AVMNodeDescriptor> listing = this.fService.getDirectoryListing(desc);
        for (Map.Entry entry : listing.entrySet()) {
            this.recursiveRead(((AVMNodeDescriptor)entry.getValue()).getPath(), paths);
        }
    }
}

