/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.alfresco.repo.bulkimport.DirectoryAnalyser;
import org.alfresco.repo.bulkimport.ImportableItem;
import org.alfresco.repo.bulkimport.impl.StripingFilesystemTracker;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ResourceUtils;

public class StripingFilesystemTrackerTest {
    private DirectoryAnalyser directoryAnalyser;
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();

    @Before
    public void setup() throws Exception {
        this.directoryAnalyser = (DirectoryAnalyser)ctx.getBean("bfsiDirectoryAnalyser");
    }

    @After
    public void teardown() throws Exception {
    }

    @Test
    public void test1() throws FileNotFoundException {
        File sourceFolder = ResourceUtils.getFile((String)"classpath:bulkimport");
        StripingFilesystemTracker tracker = new StripingFilesystemTracker(this.directoryAnalyser, new NodeRef("workspace", "SpacesStore", "123"), sourceFolder, Integer.MAX_VALUE);
        List<ImportableItem> items = tracker.getImportableItems(Integer.MAX_VALUE);
        Assert.assertEquals((String)"", (long)11L, (long)items.size());
        tracker.incrementLevel();
        items = tracker.getImportableItems(Integer.MAX_VALUE);
        Assert.assertEquals((String)"", (long)2L, (long)items.size());
        tracker.incrementLevel();
        items = tracker.getImportableItems(Integer.MAX_VALUE);
        Assert.assertEquals((String)"", (long)31L, (long)items.size());
    }
}

