/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.alfresco.repo.content.metadata.TikaPoweredMetadataExtracter;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.OfficeParser;

public class OfficeMetadataExtracter
extends TikaPoweredMetadataExtracter {
    public static final String KEY_CREATE_DATETIME = "createDateTime";
    public static final String KEY_LAST_SAVE_DATETIME = "lastSaveDateTime";
    public static final String KEY_EDIT_TIME = "editTime";
    public static final String KEY_FORMAT = "format";
    public static final String KEY_KEYWORDS = "keywords";
    public static final String KEY_LAST_AUTHOR = "lastAuthor";
    public static final String KEY_LAST_PRINTED = "lastPrinted";
    public static final String KEY_OS_VERSION = "osVersion";
    public static final String KEY_THUMBNAIL = "thumbnail";
    public static final String KEY_PAGE_COUNT = "pageCount";
    public static final String KEY_PARAGRAPH_COUNT = "paragraphCount";
    public static final String KEY_WORD_COUNT = "wordCount";
    public static ArrayList<String> SUPPORTED_MIMETYPES = OfficeMetadataExtracter.buildSupportedMimetypes(new String[]{"application/msword", "application/vnd.ms-excel", "application/vnd.ms-powerpoint", "application/vnd.visio"}, new Parser[]{new OfficeParser()});

    public OfficeMetadataExtracter() {
        super(SUPPORTED_MIMETYPES);
    }

    @Override
    protected Parser getParser() {
        return new OfficeParser();
    }

    @Override
    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        this.putRawValue(KEY_CREATE_DATETIME, (Serializable)((Object)metadata.get(Metadata.CREATION_DATE)), properties);
        this.putRawValue(KEY_LAST_SAVE_DATETIME, (Serializable)((Object)metadata.get(Metadata.LAST_SAVED)), properties);
        this.putRawValue(KEY_EDIT_TIME, (Serializable)((Object)metadata.get("Edit-Time")), properties);
        this.putRawValue(KEY_FORMAT, (Serializable)((Object)metadata.get(KEY_FORMAT)), properties);
        this.putRawValue(KEY_KEYWORDS, (Serializable)((Object)metadata.get("Keywords")), properties);
        this.putRawValue(KEY_LAST_AUTHOR, (Serializable)((Object)metadata.get("Last-Author")), properties);
        this.putRawValue(KEY_LAST_PRINTED, (Serializable)((Object)metadata.get(Metadata.LAST_PRINTED)), properties);
        this.putRawValue(KEY_PAGE_COUNT, (Serializable)((Object)metadata.get(Metadata.PAGE_COUNT)), properties);
        this.putRawValue(KEY_PARAGRAPH_COUNT, (Serializable)((Object)metadata.get(Metadata.PARAGRAPH_COUNT)), properties);
        this.putRawValue(KEY_WORD_COUNT, (Serializable)((Object)metadata.get(Metadata.WORD_COUNT)), properties);
        return properties;
    }

    static {
        SUPPORTED_MIMETYPES.remove("application/vnd.ms-outlook");
    }
}

