/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracterTest;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.OpenOfficeMetadataExtracter;
import org.alfresco.repo.content.metadata.OpenOfficeMetadataWorker;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.namespace.QName;

public class OpenOfficeMetadataExtracterTest
extends AbstractMetadataExtracterTest {
    private OpenOfficeMetadataExtracter extracter;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        OpenOfficeMetadataWorker worker = (OpenOfficeMetadataWorker)this.ctx.getBean("extracter.worker.OpenOffice");
        this.extracter = new OpenOfficeMetadataExtracter();
        this.extracter.setMimetypeService((MimetypeService)this.mimetypeMap);
        this.extracter.setDictionaryService(this.dictionaryService);
        this.extracter.setWorker(worker);
        this.extracter.init();
    }

    @Override
    protected MetadataExtracter getExtracter() {
        return this.extracter;
    }

    public void testReliability() throws Exception {
        if (!this.extracter.isConnected()) {
            return;
        }
        for (String mimetype : OpenOfficeMetadataExtracter.SUPPORTED_MIMETYPES) {
            double reliability = this.extracter.getReliability(mimetype);
            OpenOfficeMetadataExtracterTest.assertTrue((String)"Expected above zero reliability", (reliability > 0.0 ? 1 : 0) != 0);
        }
    }

    public void testSupportedMimetypes() throws Exception {
        if (!this.extracter.isConnected()) {
            return;
        }
        for (String mimetype : OpenOfficeMetadataExtracter.SUPPORTED_MIMETYPES) {
            this.testExtractFromMimetype(mimetype);
        }
    }

    @Override
    protected void testCommonMetadata(String mimetype, Map<QName, Serializable> properties) {
        if (this.extracter.isConnected()) {
            super.testCommonMetadata(mimetype, properties);
        }
    }

    @Override
    protected boolean skipAuthorCheck(String mimetype) {
        ArrayList<String> mimeTypesWithNoAuthor = new ArrayList<String>();
        mimeTypesWithNoAuthor.add("application/vnd.stardivision.impress");
        mimeTypesWithNoAuthor.add("application/vnd.sun.xml.impress");
        return mimeTypesWithNoAuthor.contains(mimetype);
    }

    @Override
    public void testFileSpecificMetadata(String mimetype, Map<QName, Serializable> properties) {
    }
}

