/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracterTest;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.PoiMetadataExtracter;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

public class PoiMetadataExtracterTest
extends AbstractMetadataExtracterTest {
    private PoiMetadataExtracter extracter;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.extracter = new PoiMetadataExtracter();
        this.extracter.setDictionaryService(this.dictionaryService);
        this.extracter.register();
    }

    @Override
    protected MetadataExtracter getExtracter() {
        return this.extracter;
    }

    public void testSupports() throws Exception {
        for (String mimetype : PoiMetadataExtracter.SUPPORTED_MIMETYPES) {
            boolean supports = this.extracter.isSupported(mimetype);
            PoiMetadataExtracterTest.assertTrue((String)("Mimetype should be supported: " + mimetype), (boolean)supports);
        }
    }

    public void testOffice2007Extraction() throws Exception {
        for (String mimetype : PoiMetadataExtracter.SUPPORTED_MIMETYPES) {
            this.testExtractFromMimetype(mimetype);
        }
    }

    @Override
    protected boolean skipDescriptionCheck(String mimetype) {
        return true;
    }

    @Override
    protected void testFileSpecificMetadata(String mimetype, Map<QName, Serializable> properties) {
        if ("application/vnd.openxmlformats-officedocument.wordprocessingml.document".equals(mimetype)) {
            this.checkFileCreationDate(mimetype, properties, "2010-01-06T17:32:00.000Z");
        } else if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(mimetype)) {
            this.checkFileCreationDate(mimetype, properties, "1996-10-15T00:33:28.000+01:00");
        } else if ("application/vnd.openxmlformats-officedocument.presentationml.presentation".equals(mimetype)) {
            this.checkFileCreationDate(mimetype, properties, "1601-01-01T00:00:00.000Z");
        }
    }

    private void checkFileCreationDate(String mimetype, Map<QName, Serializable> properties, String date) {
        PoiMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_CREATED + " not found for mimetype " + mimetype), (String)date, (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_CREATED))));
    }
}

