/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.replication;

import org.alfresco.repo.content.ContentStore;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ContentStoreReplicator {
    private static Log logger = LogFactory.getLog(ContentStoreReplicator.class);
    private ContentStore sourceStore;
    private ContentStore targetStore;
    private boolean busy = false;

    public void setSourceStore(ContentStore sourceStore) {
        this.sourceStore = sourceStore;
    }

    public void setTargetStore(ContentStore targetStore) {
        this.targetStore = targetStore;
    }

    public void setRunContinuously(boolean runContinuously) {
        logger.warn((Object)("Property 'runContinuously' has been deprecated.\n   Use the " + ContentStoreReplicatorJob.class.getName() + " to trigger"));
    }

    public void setWaitTime(long waitTime) {
        logger.warn((Object)("Property 'runContinuously' has been deprecated.\n   Use the " + ContentStoreReplicatorJob.class.getName() + " to trigger"));
    }

    public synchronized void start() {
        if (this.busy) {
            return;
        }
        ReplicationRunner runnable = new ReplicationRunner();
        Thread thread = new Thread(runnable);
        thread.setName("ContentStoreReplicator");
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.start();
        this.busy = true;
    }

    private void replicate() {
        ReplicatingHandler handler = new ReplicatingHandler();
        this.sourceStore.getUrls(handler);
    }

    private void replicate(String contentUrl) {
        try {
            if (this.targetStore.exists(contentUrl)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("No replication required - URL exists in target store: \n   source store: " + this.sourceStore + "\n" + "   target store: " + this.targetStore + "\n" + "   content URL: " + contentUrl));
                }
                return;
            }
            ContentWriter writer = this.targetStore.getWriter(null, contentUrl);
            ContentReader reader = this.sourceStore.getReader(contentUrl);
            if (!reader.exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Source store no longer has URL - no replication possible: \n   source store: " + this.sourceStore + "\n" + "   target store: " + this.targetStore + "\n" + "   content URL: " + contentUrl));
                }
                return;
            }
            writer.putContent(reader);
        }
        catch (Throwable e) {
            logger.error((Object)("Failed to replicate URL - removing target content: \n   source store: " + this.sourceStore + "\n" + "   target store: " + this.targetStore + "\n" + "   content URL: " + contentUrl), e);
            this.targetStore.delete(contentUrl);
        }
    }

    public static class ContentStoreReplicatorJob
    implements Job {
        public static final String KEY_CONTENT_STORE_REPLICATOR = "contentStoreReplicator";

        public void execute(JobExecutionContext context) throws JobExecutionException {
            ContentStoreReplicator contentStoreReplicator = (ContentStoreReplicator)context.getJobDetail().getJobDataMap().get((Object)KEY_CONTENT_STORE_REPLICATOR);
            if (contentStoreReplicator == null) {
                throw new JobExecutionException("Missing job data: contentStoreReplicator");
            }
            contentStoreReplicator.start();
        }
    }

    private class ReplicatingHandler
    implements ContentStore.ContentUrlHandler {
        private ReplicatingHandler() {
        }

        @Override
        public void handle(String contentUrl) {
            ContentStoreReplicator.this.replicate(contentUrl);
        }
    }

    private class ReplicationRunner
    implements Runnable {
        private ReplicationRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ContentStoreReplicator.this.replicate();
            }
            catch (Throwable e) {
                logger.error((Object)"Replication failure", e);
            }
            finally {
                ContentStoreReplicator.this.busy = false;
            }
        }
    }
}

