/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.el.MethodNotFoundException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.repo.content.transform.AbstractContentTransformerLimits;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TransformationOptionLimits;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class ComplexContentTransformer
extends AbstractContentTransformer2
implements InitializingBean {
    private static Log logger = LogFactory.getLog(ComplexContentTransformer.class);
    static final ThreadLocal<Deque<ContentTransformer>> parentTransformers = new ThreadLocal<Deque<ContentTransformer>>(){

        @Override
        protected Deque<ContentTransformer> initialValue() {
            return new ArrayDeque<ContentTransformer>();
        }
    };
    private List<ContentTransformer> transformers;
    private List<String> intermediateMimetypes;
    private Map<String, Serializable> transformationOptionOverrides;
    private ContentService contentService;

    public void setTransformers(List<ContentTransformer> transformers) {
        this.transformers = transformers;
    }

    public void setIntermediateMimetypes(List<String> intermediateMimetypes) {
        this.intermediateMimetypes = intermediateMimetypes;
    }

    public void setTransformationOptionOverrides(Map<String, Serializable> transformationOptionOverrides) {
        this.transformationOptionOverrides = transformationOptionOverrides;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.transformers == null || this.transformers.size() == 0) {
            throw new AlfrescoRuntimeException("At least one inner transformer must be supplied: " + this);
        }
        if (this.intermediateMimetypes == null || this.intermediateMimetypes.size() != this.transformers.size() - 1) {
            throw new AlfrescoRuntimeException("There must be n-1 intermediate mimetypes, where n is the number of transformers");
        }
        if (this.getMimetypeService() == null) {
            throw new AlfrescoRuntimeException("'mimetypeService' is a required property");
        }
        for (ContentTransformer transformer : this.transformers) {
            if (transformer != null) continue;
            if (this.contentService != null) break;
            throw new AlfrescoRuntimeException("'contentService' is a required property if there are any null (dynamic) transformers");
        }
    }

    @Override
    public boolean isTransformable(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        if (!this.isSupportedTransformation(sourceMimetype, targetMimetype, options)) {
            return false;
        }
        if (parentTransformers.get().contains(this)) {
            return false;
        }
        this.overrideTransformationOptions(options);
        return this.isTransformableMimetype(sourceMimetype, targetMimetype, options) && this.isTransformableSize(sourceMimetype, sourceSize, targetMimetype, options);
    }

    private void overrideTransformationOptions(TransformationOptions options) {
        if (options != null && this.transformationOptionOverrides != null) {
            for (String key : this.transformationOptionOverrides.keySet()) {
                if (PropertyUtils.isWriteable((Object)options, (String)key)) {
                    try {
                        PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)options, (String)key);
                        Class<?> propertyClass = pd.getPropertyType();
                        Object value = this.transformationOptionOverrides.get(key);
                        if (value != null && !propertyClass.isInstance(value)) {
                            value = value instanceof String && propertyClass.isInstance(Boolean.TRUE) ? TransformationOptions.relaxedBooleanTypeConverter.convert((Object)((String)value)) : DefaultTypeConverter.INSTANCE.convert(propertyClass, value);
                        }
                        PropertyUtils.setProperty((Object)options, (String)key, (Object)value);
                    }
                    catch (MethodNotFoundException mnfe) {
                    }
                    catch (NoSuchMethodException nsme) {
                    }
                    catch (InvocationTargetException ite) {
                    }
                    catch (IllegalAccessException iae) {}
                    continue;
                }
                logger.warn((Object)("Unable to set override Transformation Option " + key + " on " + options));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTransformableMimetype(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        boolean result = true;
        String currentSourceMimetype = sourceMimetype;
        Iterator<ContentTransformer> transformerIterator = this.transformers.iterator();
        while (transformerIterator.hasNext()) {
            ContentTransformer transformer2 = transformerIterator.next();
            if (transformer2 != null) continue;
            for (ContentTransformer transformer2 : this.transformers) {
                if (transformer2 == null || !transformer2.isTransformableMimetype(sourceMimetype, targetMimetype, options)) continue;
                return false;
            }
        }
        transformerIterator = this.transformers.iterator();
        Iterator<String> intermediateMimetypeIterator = this.intermediateMimetypes.iterator();
        while (transformerIterator.hasNext()) {
            String currentTargetMimetype;
            block9: {
                ContentTransformer transformer = transformerIterator.next();
                String string = currentTargetMimetype = transformerIterator.hasNext() ? intermediateMimetypeIterator.next() : targetMimetype;
                if (transformer == null) {
                    try {
                        parentTransformers.get().push(this);
                        List<ContentTransformer> firstTansformers = this.contentService.getActiveTransformers(currentSourceMimetype, -1L, currentTargetMimetype, options);
                        if (firstTansformers.isEmpty()) {
                            result = false;
                            break;
                        }
                        break block9;
                    }
                    finally {
                        parentTransformers.get().pop();
                    }
                }
                if (!transformer.isTransformableMimetype(currentSourceMimetype, currentTargetMimetype, options)) {
                    result = false;
                    break;
                }
            }
            currentSourceMimetype = currentTargetMimetype;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isPageLimitSupported(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        ContentTransformer firstTransformer = this.transformers.get(0);
        String firstTargetMimetype = this.intermediateMimetypes.get(0);
        if (firstTransformer != null) return this.isPageLimitSupported(firstTransformer, sourceMimetype, targetMimetype, options);
        try {
            ContentTransformer transformer;
            parentTransformers.get().push(this);
            List<ContentTransformer> firstTansformers = this.contentService.getActiveTransformers(sourceMimetype, -1L, firstTargetMimetype, options);
            boolean pageLimitSupported = !firstTansformers.isEmpty();
            if (!pageLimitSupported) return pageLimitSupported;
            Iterator<ContentTransformer> i$ = firstTansformers.iterator();
            do {
                if (!i$.hasNext()) return pageLimitSupported;
            } while (this.isPageLimitSupported(transformer = i$.next(), sourceMimetype, targetMimetype, options));
            pageLimitSupported = false;
            return pageLimitSupported;
        }
        finally {
            parentTransformers.get().pop();
        }
    }

    private boolean isPageLimitSupported(ContentTransformer transformer, String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return transformer instanceof AbstractContentTransformerLimits ? ((AbstractContentTransformerLimits)transformer).isPageLimitSupported(sourceMimetype, targetMimetype, options) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected TransformationOptionLimits getLimits(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        firstTransformerLimits = null;
        limits = super.getLimits(sourceMimetype, targetMimetype, options);
        firstTransformer = this.transformers.get(0);
        firstTargetMimetype = this.intermediateMimetypes.get(0);
        if (firstTransformer == null) {
            try {
                ComplexContentTransformer.parentTransformers.get().push(this);
                firstTansformers = this.contentService.getActiveTransformers(sourceMimetype, -1L, firstTargetMimetype, options);
                if (firstTansformers.isEmpty()) ** GOTO lbl22
                for (ContentTransformer transformer : firstTansformers) {
                    if (!(transformer instanceof AbstractContentTransformerLimits)) continue;
                    transformerLimits = ((AbstractContentTransformerLimits)transformer).getLimits(sourceMimetype, firstTargetMimetype, options);
                    firstTransformerLimits = firstTransformerLimits == null ? transformerLimits : firstTransformerLimits.combineUpper(transformerLimits);
                }
            }
            finally {
                ComplexContentTransformer.parentTransformers.get().pop();
            }
        } else if (firstTransformer instanceof AbstractContentTransformerLimits) {
            firstTransformerLimits = ((AbstractContentTransformerLimits)firstTransformer).getLimits(sourceMimetype, firstTargetMimetype, options);
        }
lbl22:
        // 5 sources

        if (firstTransformerLimits != null) {
            limits = limits.combine(firstTransformerLimits);
        }
        return limits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        NodeRef origSourceNodeRef = options.getSourceNodeRef();
        try {
            ContentReader currentReader = reader;
            Iterator<ContentTransformer> transformerIterator = this.transformers.iterator();
            Iterator<String> intermediateMimetypeIterator = this.intermediateMimetypes.iterator();
            while (transformerIterator.hasNext()) {
                ContentTransformer transformer = transformerIterator.next();
                ContentWriter currentWriter = null;
                if (!transformerIterator.hasNext()) {
                    currentWriter = writer;
                } else {
                    String nextMimetype = intermediateMimetypeIterator.next();
                    String sourceExt = this.getMimetypeService().getExtension(currentReader.getMimetype());
                    String targetExt = this.getMimetypeService().getExtension(nextMimetype);
                    File tempFile = TempFileProvider.createTempFile((String)("ComplextTransformer_intermediate_" + sourceExt + "_"), (String)("." + targetExt));
                    currentWriter = new FileContentWriter(tempFile);
                    currentWriter.setMimetype(nextMimetype);
                }
                if (transformer == null) {
                    try {
                        parentTransformers.get().push(this);
                        this.contentService.transform(currentReader, currentWriter, options);
                    }
                    finally {
                        parentTransformers.get().pop();
                    }
                } else {
                    transformer.transform(currentReader, currentWriter, options);
                }
                options.setSourceNodeRef(null);
                currentReader = currentWriter.getReader();
            }
        }
        finally {
            options.setSourceNodeRef(origSourceNodeRef);
        }
    }

    public List<String> getIntermediateMimetypes() {
        return Collections.unmodifiableList(this.intermediateMimetypes);
    }
}

