/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.io.InputStream;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.PoiHssfContentTransformer;
import org.alfresco.repo.content.transform.TikaPoweredContentTransformerTest;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;

public class PoiHssfContentTransformerTest
extends TikaPoweredContentTransformerTest {
    private PoiHssfContentTransformer transformer;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new PoiHssfContentTransformer();
        this.transformer.setMimetypeService(this.mimetypeService);
        this.transformer.setTransformerDebug(this.transformerDebug);
    }

    @Override
    protected String[] getQuickFilenames(String sourceMimetype) {
        return new String[]{"quick.xls", "quick.xlsx"};
    }

    @Override
    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testIsTransformable() throws Exception {
        PoiHssfContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", -1L, "application/vnd.ms-excel", new TransformationOptions()));
        PoiHssfContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-excel", -1L, "text/plain", new TransformationOptions()));
        PoiHssfContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-excel", -1L, "text/csv", new TransformationOptions()));
        PoiHssfContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-excel", -1L, "text/html", new TransformationOptions()));
        PoiHssfContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-excel", -1L, "text/xml", new TransformationOptions()));
    }

    public void testCsvOutput() throws Exception {
        File sourceFile = AbstractContentTransformerTest.loadQuickTestFile("xls");
        FileContentReader sourceReader = new FileContentReader(sourceFile);
        File targetFile = TempFileProvider.createTempFile((String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + this.getName() + "_xls_"), (String)".csv");
        FileContentWriter targetWriter = new FileContentWriter(targetFile);
        sourceReader.setMimetype("application/vnd.ms-excel");
        targetWriter.setMimetype("text/csv");
        this.transformer.transform(sourceReader, targetWriter);
        ContentReader targetReader = targetWriter.getReader();
        String checkContent = targetReader.getContentString();
        this.additionalContentCheck("application/vnd.ms-excel", "text/csv", checkContent);
    }

    @Override
    protected void additionalContentCheck(String sourceMimetype, String targetMimetype, String contents) {
        if (targetMimetype.equals("text/csv")) {
            PoiHssfContentTransformerTest.assertTrue((String)"Content not properly CSV'd", (boolean)contents.contains("1,2,2"));
            PoiHssfContentTransformerTest.assertTrue((String)"Content not properly CSV'd", (boolean)contents.contains("\"The\",\"quick\",\"brown\",\"fox\""));
        } else if (targetMimetype.equals("text/xml")) {
            super.additionalContentCheck(sourceMimetype, targetMimetype, contents);
            PoiHssfContentTransformerTest.assertTrue((String)("Content lacks XHTML table tags:\n" + contents), (boolean)contents.contains("<table>"));
            PoiHssfContentTransformerTest.assertTrue((String)("Content lacks XHTML table tags:\n" + contents), (boolean)contents.contains("<tr>"));
            PoiHssfContentTransformerTest.assertTrue((String)("Content lacks XHTML table tags:\n" + contents), (boolean)contents.contains("<td>1</td>"));
            PoiHssfContentTransformerTest.assertTrue((String)("Content lacks XHTML table tags:\n" + contents), (boolean)contents.contains("<td>The</td>"));
        } else {
            super.additionalContentCheck(sourceMimetype, targetMimetype, contents);
        }
    }

    @Override
    protected boolean isQuickPhraseExpected(String targetMimetype) {
        if (targetMimetype.equals("text/csv")) {
            return true;
        }
        return super.isQuickPhraseExpected(targetMimetype);
    }

    public void xxtestBugFixAR114() throws Exception {
        File tempFile = TempFileProvider.createTempFile((String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + this.getName() + "_"), (String)".xls");
        FileContentWriter writer = new FileContentWriter(tempFile);
        writer.setMimetype("application/vnd.ms-excel");
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("Plan270904b.xls");
        PoiHssfContentTransformerTest.assertNotNull((Object)"Test resource not found: Plan270904b.xls");
        writer.putContent(is);
        ContentReader reader = writer.getReader();
        tempFile = TempFileProvider.createTempFile((String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + this.getName() + "_"), (String)".txt");
        writer = new FileContentWriter(tempFile);
        writer.setMimetype("text/plain");
        this.transformer.transform(reader, writer);
    }
}

