/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.io.InputStream;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.TextMiningContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;

public class TextMiningContentTransformerTest
extends AbstractContentTransformerTest {
    private TextMiningContentTransformer transformer;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new TextMiningContentTransformer();
        this.transformer.setMimetypeService(this.mimetypeService);
        this.transformer.setTransformerDebug(this.transformerDebug);
    }

    @Override
    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    @Override
    protected String[] getQuickFilenames(String sourceMimetype) {
        return new String[]{"quick.doc", "quick95.doc", "quick6.doc"};
    }

    public void testIsTransformable() throws Exception {
        TextMiningContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", -1L, "application/msword", new TransformationOptions()));
        TextMiningContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/msword", -1L, "text/plain", new TransformationOptions()));
    }

    public void testBugFixAR1() throws Exception {
        File tempFile = TempFileProvider.createTempFile((String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + this.getName() + "_"), (String)".doc");
        FileContentWriter writer = new FileContentWriter(tempFile);
        writer.setMimetype("application/msword");
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("farmers_markets_list_2003.doc");
        TextMiningContentTransformerTest.assertNotNull((Object)"Test resource not found: farmers_markets_list_2003.doc");
        writer.putContent(is);
        ContentReader reader = writer.getReader();
        tempFile = TempFileProvider.createTempFile((String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + this.getName() + "_"), (String)".txt");
        writer = new FileContentWriter(tempFile);
        writer.setMimetype("text/plain");
        this.transformer.transform(reader, writer);
    }
}

