/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.activities;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.JSONtoFmModel;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public class ActivityFeedEntity {
    public static final String KEY_ACTIVITY_FEED_ID = "id";
    public static final String KEY_ACTIVITY_FEED_POST_DATE = "postDate";
    public static final String KEY_ACTIVITY_FEED_POST_USERID = "postUserId";
    public static final String KEY_ACTIVITY_FEED_POST_USER_AVATAR_NODE = "postUserAvatar";
    public static final String KEY_ACTIVITY_FEED_USERID = "feedUserId";
    public static final String KEY_ACTIVITY_FEED_SITE = "siteNetwork";
    public static final String KEY_ACTIVITY_FEED_TYPE = "activityType";
    public static final String KEY_ACTIVITY_FEED_SUMMARY = "activitySummary";
    public static final String KEY_ACTIVITY_FEED_SUMMARY_FORMAT = "activitySummaryFormat";
    private Long id;
    private String activityType;
    private String activitySummary;
    private String activitySummaryFormat;
    private String feedUserId;
    private String postUserId;
    private NodeRef postUserAvatarNodeRef;
    private String siteNetwork;
    private String appTool;
    private Date postDate;
    private Date feedDate;
    private long postId;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getActivitySummary() {
        return this.activitySummary;
    }

    public void setActivitySummary(String summary) {
        this.activitySummary = summary;
    }

    public String getFeedUserId() {
        return this.feedUserId;
    }

    public void setFeedUserId(String userid) {
        this.feedUserId = userid;
    }

    public String getPostUserId() {
        return this.postUserId;
    }

    public void setPostUserId(String userid) {
        this.postUserId = userid;
    }

    public String getActivitySummaryFormat() {
        return this.activitySummaryFormat;
    }

    public void setActivitySummaryFormat(String format) {
        this.activitySummaryFormat = format;
    }

    public String getSiteNetwork() {
        return this.siteNetwork;
    }

    public void setSiteNetwork(String siteNetwork) {
        this.siteNetwork = siteNetwork;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public Date getPostDate() {
        return this.postDate;
    }

    public void setPostDate(Date postDate) {
        this.postDate = postDate;
    }

    public long getPostId() {
        return this.postId;
    }

    public void setPostId(long postId) {
        this.postId = postId;
    }

    public Date getFeedDate() {
        return this.feedDate;
    }

    public void setFeedDate(Date feedDate) {
        this.feedDate = feedDate;
    }

    public NodeRef getPostUserAvatarNodeRef() {
        return this.postUserAvatarNodeRef;
    }

    public void setPostUserAvatarNodeRef(NodeRef postUserAvatarNodeRef) {
        this.postUserAvatarNodeRef = postUserAvatarNodeRef;
    }

    public String getAppTool() {
        return this.appTool;
    }

    public void setAppTool(String appTool) {
        this.appTool = appTool;
    }

    public String getJSONString() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put(KEY_ACTIVITY_FEED_ID, (Object)this.id);
        jo.put(KEY_ACTIVITY_FEED_POST_USERID, (Object)this.postUserId);
        if (this.postUserAvatarNodeRef != null) {
            jo.put(KEY_ACTIVITY_FEED_POST_USER_AVATAR_NODE, (Object)this.postUserAvatarNodeRef.toString());
        }
        jo.put(KEY_ACTIVITY_FEED_POST_DATE, (Object)ISO8601DateFormat.format((Date)this.postDate));
        if (this.getFeedUserId() != null) {
            jo.put(KEY_ACTIVITY_FEED_USERID, (Object)this.getFeedUserId());
        }
        jo.put(KEY_ACTIVITY_FEED_SITE, (Object)this.siteNetwork);
        jo.put(KEY_ACTIVITY_FEED_TYPE, (Object)this.getActivityType());
        jo.put(KEY_ACTIVITY_FEED_SUMMARY, (Object)this.getActivitySummary());
        jo.put(KEY_ACTIVITY_FEED_SUMMARY_FORMAT, (Object)this.getActivitySummaryFormat());
        return jo.toString();
    }

    public Map<String, Object> getModel() throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(KEY_ACTIVITY_FEED_ID, this.id);
        map.put(KEY_ACTIVITY_FEED_POST_USERID, this.getPostUserId());
        map.put(KEY_ACTIVITY_FEED_POST_DATE, this.getPostDate());
        if (this.getFeedUserId() != null) {
            map.put(KEY_ACTIVITY_FEED_USERID, this.getFeedUserId());
        }
        map.put(KEY_ACTIVITY_FEED_SITE, this.getSiteNetwork());
        map.put(KEY_ACTIVITY_FEED_TYPE, this.getActivityType());
        map.put(KEY_ACTIVITY_FEED_SUMMARY_FORMAT, this.getActivitySummaryFormat());
        if (this.getActivitySummary() != null && this.getActivitySummaryFormat().equals("json")) {
            map.put(KEY_ACTIVITY_FEED_SUMMARY, JSONtoFmModel.convertJSONObjectToMap(this.getActivitySummary()));
        } else {
            map.put(KEY_ACTIVITY_FEED_SUMMARY, this.getActivitySummary());
        }
        return map;
    }
}

