/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.activities.ibatis;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.domain.activities.ActivityPostEntity;
import org.alfresco.repo.domain.activities.ibatis.ActivitiesDAOImpl;

public class ActivityPostDAOImpl
extends ActivitiesDAOImpl
implements ActivityPostDAO {
    @Override
    public List<ActivityPostEntity> selectPosts(ActivityPostEntity activityPost) throws SQLException {
        if (activityPost.getJobTaskNode() != -1 && activityPost.getMinId() != -1L && activityPost.getMaxId() != -1L && activityPost.getStatus() != null) {
            return this.template.selectList("alfresco.activities.select_activity_posts_by_params", (Object)activityPost);
        }
        if (activityPost.getStatus() != null) {
            return this.template.selectList("alfresco.activities.select_activity_posts_by_status", (Object)activityPost);
        }
        return new ArrayList<ActivityPostEntity>(0);
    }

    @Override
    public Long getMaxActivitySeq() throws SQLException {
        return (Long)this.template.selectOne("alfresco.activities.select_activity_post_max_seq");
    }

    @Override
    public Long getMinActivitySeq() throws SQLException {
        return (Long)this.template.selectOne("alfresco.activities.select_activity_post_min_seq");
    }

    @Override
    public Integer getMaxNodeHash() throws SQLException {
        return (Integer)this.template.selectOne("alfresco.activities.select_activity_post_max_jobtasknode");
    }

    @Override
    public int updatePost(long id, String siteNetwork, String activityData, ActivityPostEntity.STATUS status) throws SQLException {
        ActivityPostEntity post = new ActivityPostEntity();
        post.setId(id);
        post.setSiteNetwork(siteNetwork);
        post.setActivityData(activityData);
        post.setStatus(status.toString());
        post.setLastModified(new Date());
        return this.template.update("alfresco.activities.update_activity_post_data", (Object)post);
    }

    @Override
    public int updatePostStatus(long id, ActivityPostEntity.STATUS status) throws SQLException {
        ActivityPostEntity post = new ActivityPostEntity();
        post.setId(id);
        post.setStatus(status.toString());
        post.setLastModified(new Date());
        return this.template.update("alfresco.activities.update_activity_post_status", (Object)post);
    }

    @Override
    public int deletePosts(Date keepDate, ActivityPostEntity.STATUS status) throws SQLException {
        ActivityPostEntity params = new ActivityPostEntity();
        params.setPostDate(keepDate);
        params.setStatus(status.toString());
        return this.template.delete("alfresco.activities.delete_activity_posts_older_than_date", (Object)params);
    }

    @Override
    public long insertPost(ActivityPostEntity activityPost) throws SQLException {
        this.template.insert("alfresco.activities.insert.insert_activity_post", (Object)activityPost);
        Long id = activityPost.getId();
        return id != null ? id : -1L;
    }
}

