/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.permissions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.CrcHelper;
import org.alfresco.repo.domain.permissions.Ace;
import org.alfresco.repo.domain.permissions.AceContextEntity;
import org.alfresco.repo.domain.permissions.AceEntity;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.domain.permissions.AclChangeSetEntity;
import org.alfresco.repo.domain.permissions.AclCrudDAO;
import org.alfresco.repo.domain.permissions.AclEntity;
import org.alfresco.repo.domain.permissions.AclMember;
import org.alfresco.repo.domain.permissions.AclMemberEntity;
import org.alfresco.repo.domain.permissions.AclUpdateEntity;
import org.alfresco.repo.domain.permissions.Authority;
import org.alfresco.repo.domain.permissions.AuthorityAliasEntity;
import org.alfresco.repo.domain.permissions.AuthorityEntity;
import org.alfresco.repo.domain.permissions.Permission;
import org.alfresco.repo.domain.permissions.PermissionEntity;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.security.permissions.ACEType;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.surf.util.ParameterCheck;

public abstract class AbstractAclCrudDAOImpl
implements AclCrudDAO {
    private static final String CACHE_REGION_ACL = "Acl";
    private static final String CACHE_REGION_AUTHORITY = "Authority";
    private static final String CACHE_REGION_PERMISSION = "Permission";
    private final AclEntityCallbackDAO aclEntityDaoCallback = new AclEntityCallbackDAO();
    private final AuthorityEntityCallbackDAO authorityEntityDaoCallback;
    private final PermissionEntityCallbackDAO permissionEntityDaoCallback;
    private QNameDAO qnameDAO;
    private static int batchSize = 500;
    private EntityLookupCache<Long, AclEntity, Serializable> aclEntityCache = new EntityLookupCache<Long, AclEntity, Serializable>(this.aclEntityDaoCallback);
    private EntityLookupCache<Long, AuthorityEntity, String> authorityEntityCache;
    private EntityLookupCache<Long, PermissionEntity, PermissionEntity> permissionEntityCache;

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setBatchSize(int batchSizeOverride) {
        batchSize = batchSizeOverride;
    }

    public void setAclEntityCache(SimpleCache<Serializable, Object> aclEntityCache) {
        this.aclEntityCache = new EntityLookupCache<Long, AclEntity, Serializable>(aclEntityCache, CACHE_REGION_ACL, this.aclEntityDaoCallback);
    }

    public void setAuthorityEntityCache(SimpleCache<Serializable, Object> authorityEntityCache) {
        this.authorityEntityCache = new EntityLookupCache<Long, AuthorityEntity, String>(authorityEntityCache, CACHE_REGION_AUTHORITY, this.authorityEntityDaoCallback);
    }

    public void setPermissionEntityCache(SimpleCache<Serializable, Object> permissionEntityCache) {
        this.permissionEntityCache = new EntityLookupCache<Long, PermissionEntity, PermissionEntity>(permissionEntityCache, CACHE_REGION_PERMISSION, this.permissionEntityDaoCallback);
    }

    public AbstractAclCrudDAOImpl() {
        this.authorityEntityDaoCallback = new AuthorityEntityCallbackDAO();
        this.authorityEntityCache = new EntityLookupCache<Long, AuthorityEntity, String>(this.authorityEntityDaoCallback);
        this.permissionEntityDaoCallback = new PermissionEntityCallbackDAO();
        this.permissionEntityCache = new EntityLookupCache<Long, PermissionEntity, PermissionEntity>(this.permissionEntityDaoCallback);
    }

    @Override
    public AclEntity createAcl(AclEntity entity) {
        ParameterCheck.mandatory((String)"entity", (Object)entity);
        ParameterCheck.mandatory((String)"entity.aclId", (Object)entity.getAclId());
        ParameterCheck.mandatory((String)"entity.aclVersion", (Object)entity.getAclVersion());
        entity.setVersion(0L);
        Pair<Long, AclEntity> entityPair = this.aclEntityCache.getOrCreateByValue(entity);
        return (AclEntity)entityPair.getSecond();
    }

    @Override
    public Acl getAcl(long id) {
        return this.getAclImpl(id);
    }

    private AclEntity getAclImpl(long id) {
        Pair<Long, AclEntity> entityPair = this.aclEntityCache.getByKey(id);
        if (entityPair == null) {
            return null;
        }
        return (AclEntity)entityPair.getSecond();
    }

    @Override
    public AclUpdateEntity getAclForUpdate(long id) {
        AclEntity acl = this.getAclImpl(id);
        if (acl == null) {
            return null;
        }
        AclUpdateEntity aclEntity = new AclUpdateEntity();
        aclEntity.setId(acl.getId());
        aclEntity.setVersion(acl.getVersion());
        aclEntity.setAclChangeSetId(acl.getAclChangeSetId());
        aclEntity.setAclId(acl.getAclId());
        aclEntity.setAclType(acl.getAclType());
        aclEntity.setAclVersion(acl.getAclVersion());
        aclEntity.setInheritedAcl(acl.getInheritedAcl());
        aclEntity.setInherits(acl.getInherits());
        aclEntity.setInheritsFrom(acl.getInheritsFrom());
        aclEntity.setLatest(acl.isLatest());
        aclEntity.setVersioned(acl.isVersioned());
        aclEntity.setRequiresVersion(acl.getRequiresVersion());
        return aclEntity;
    }

    @Override
    public List<Long> getAclsThatInheritFromAcl(long aclEntityId) {
        return this.getAclEntitiesThatInheritFromAcl(aclEntityId);
    }

    @Override
    public Long getLatestAclByGuid(String aclGuid) {
        return this.getLatestAclEntityByGuid(aclGuid);
    }

    @Override
    public List<Long> getADMNodesByAcl(long aclEntityId, int maxResults) {
        return this.getADMNodeEntityIdsByAcl(aclEntityId, maxResults);
    }

    @Override
    public List<Long> getAVMNodesByAcl(long aclEntityId, int maxResults) {
        return this.getAVMNodeEntityIdsByAcl(aclEntityId, maxResults);
    }

    @Override
    public void updateAcl(AclUpdateEntity entity) {
        ParameterCheck.mandatory((String)"entity", (Object)entity);
        ParameterCheck.mandatory((String)"entity.id", (Object)entity.getId());
        ParameterCheck.mandatory((String)"entity.aclVersion", (Object)entity.getAclVersion());
        ParameterCheck.mandatory((String)"entity.version", (Object)entity.getVersion());
        int updated = this.aclEntityCache.updateValue(entity.getId(), entity);
        if (updated < 1) {
            this.aclEntityCache.removeByKey(entity.getId());
            throw new ConcurrencyFailureException("AclEntity with ID (" + entity.getId() + ") no longer exists or has been updated concurrently");
        }
    }

    @Override
    public void deleteAcl(long id) {
        Pair<Long, AclEntity> entityPair = this.aclEntityCache.getByKey(id);
        if (entityPair == null) {
            return;
        }
        int deleted = this.aclEntityCache.deleteByKey(id);
        if (deleted < 1) {
            this.aclEntityCache.removeByKey(id);
            throw new ConcurrencyFailureException("AclEntity with ID " + id + " no longer exists");
        }
    }

    protected abstract AclEntity createAclEntity(AclEntity var1);

    protected abstract AclEntity getAclEntity(long var1);

    protected abstract List<Long> getAclEntitiesThatInheritFromAcl(long var1);

    protected abstract Long getLatestAclEntityByGuid(String var1);

    protected abstract int updateAclEntity(AclEntity var1);

    protected abstract int deleteAclEntity(long var1);

    protected abstract List<Long> getADMNodeEntityIdsByAcl(long var1, int var3);

    protected abstract List<Long> getAVMNodeEntityIdsByAcl(long var1, int var3);

    @Override
    public void addAclMembersToAcl(long aclId, List<Long> aceIds, int depth) {
        ParameterCheck.mandatory((String)"aceIds", aceIds);
        ArrayList<AclMemberEntity> newMembers = new ArrayList<AclMemberEntity>(aceIds.size());
        for (Long aceId : aceIds) {
            AclMemberEntity newMember = new AclMemberEntity();
            newMember.setAclId(aclId);
            newMember.setAceId(aceId);
            newMember.setPos(depth);
            AclMemberEntity result = this.createAclMemberEntity(newMember);
            newMembers.add(result);
        }
    }

    @Override
    public void addAclMembersToAcl(long aclId, List<Pair<Long, Integer>> aceIdsWithDepths) {
        ParameterCheck.mandatory((String)"aceIdsWithDepths", aceIdsWithDepths);
        ArrayList<AclMemberEntity> newMembers = new ArrayList<AclMemberEntity>(aceIdsWithDepths.size());
        for (Pair<Long, Integer> aceIdWithDepth : aceIdsWithDepths) {
            AclMemberEntity newMember = new AclMemberEntity();
            newMember.setAclId(aclId);
            newMember.setAceId((Long)aceIdWithDepth.getFirst());
            newMember.setPos((Integer)aceIdWithDepth.getSecond());
            AclMemberEntity result = this.createAclMemberEntity(newMember);
            newMembers.add(result);
        }
    }

    @Override
    public List<AclMember> getAclMembersByAcl(long idOfAcl) {
        List<AclMemberEntity> entities = this.getAclMemberEntitiesByAcl(idOfAcl);
        ArrayList<AclMember> result = new ArrayList<AclMember>(entities.size());
        result.addAll(entities);
        return result;
    }

    @Override
    public List<AclMemberEntity> getAclMembersByAclForUpdate(long idOfAcl) {
        List<AclMemberEntity> members = this.getAclMemberEntitiesByAcl(idOfAcl);
        ArrayList<AclMemberEntity> membersForUpdate = new ArrayList<AclMemberEntity>(members.size());
        for (AclMemberEntity member : members) {
            AclMemberEntity newMember = new AclMemberEntity();
            newMember.setId(member.getId());
            newMember.setVersion(member.getVersion());
            newMember.setAceId(member.getAceId());
            newMember.setAclId(member.getAclId());
            newMember.setPos(member.getPos());
            membersForUpdate.add(newMember);
        }
        return membersForUpdate;
    }

    @Override
    public List<AclMember> getAclMembersByAuthority(String authorityName) {
        List<AclMemberEntity> entities = this.getAclMemberEntitiesByAuthority(authorityName);
        ArrayList<AclMember> result = new ArrayList<AclMember>(entities.size());
        result.addAll(entities);
        return result;
    }

    @Override
    public void updateAclMember(AclMemberEntity entity) {
        ParameterCheck.mandatory((String)"entity", (Object)entity);
        ParameterCheck.mandatory((String)"entity.id", (Object)entity.getId());
        ParameterCheck.mandatory((String)"entity.version", (Object)entity.getVersion());
        ParameterCheck.mandatory((String)"entity.aceId", (Object)entity.getAceId());
        ParameterCheck.mandatory((String)"entity.aclId", (Object)entity.getAclId());
        ParameterCheck.mandatory((String)"entity.pos", (Object)entity.getPos());
        int updated = this.updateAclMemberEntity(entity);
        if (updated < 1) {
            this.aclEntityCache.removeByKey(entity.getId());
            throw new ConcurrencyFailureException("AclMemberEntity with ID (" + entity.getId() + ") no longer exists or has been updated concurrently");
        }
    }

    @Override
    public int deleteAclMembers(List<Long> aclMemberIds) {
        int totalDeletedCount = 0;
        if (aclMemberIds.size() == 0) {
            return 0;
        }
        if (aclMemberIds.size() <= batchSize) {
            totalDeletedCount = this.deleteAclMemberEntities(aclMemberIds);
        } else {
            Iterator<Long> idIterator = aclMemberIds.iterator();
            ArrayList<Long> batchIds = new ArrayList<Long>(batchSize);
            while (idIterator.hasNext()) {
                Long id = idIterator.next();
                batchIds.add(id);
                if (batchIds.size() != batchSize && idIterator.hasNext()) continue;
                int batchDeletedCount = this.deleteAclMemberEntities(batchIds);
                totalDeletedCount += batchDeletedCount;
                batchIds.clear();
            }
        }
        return totalDeletedCount;
    }

    @Override
    public int deleteAclMembersByAcl(long idOfAcl) {
        return this.deleteAclMemberEntitiesByAcl(idOfAcl);
    }

    protected abstract AclMemberEntity createAclMemberEntity(AclMemberEntity var1);

    protected abstract List<AclMemberEntity> getAclMemberEntitiesByAcl(long var1);

    protected abstract List<AclMemberEntity> getAclMemberEntitiesByAuthority(String var1);

    protected abstract int updateAclMemberEntity(AclMemberEntity var1);

    protected abstract int deleteAclMemberEntities(List<Long> var1);

    protected abstract int deleteAclMemberEntitiesByAcl(long var1);

    @Override
    public Long createAclChangeSet() {
        return this.createAclChangeSetEntity();
    }

    @Override
    public void updateAclChangeSet(Long aclChangeSetEntityId, long commitTimeMs) {
        int updated = this.updateChangeSetEntity(aclChangeSetEntityId, commitTimeMs);
        if (updated != 1) {
            throw new ConcurrencyFailureException("Update by ID should delete exactly 1: " + aclChangeSetEntityId);
        }
    }

    @Override
    public AclChangeSetEntity getAclChangeSet(Long changeSetId) {
        return this.getAclChangeSetEntity(changeSetId);
    }

    @Override
    public void deleteAclChangeSet(Long changeSetId) {
        int deleted = this.deleteAclChangeSetEntity(changeSetId);
        if (deleted != 1) {
            this.aclEntityCache.removeByKey(changeSetId);
            throw new ConcurrencyFailureException("Deleted by ID should delete exactly 1: " + changeSetId);
        }
    }

    protected abstract Long createAclChangeSetEntity();

    protected abstract AclChangeSetEntity getAclChangeSetEntity(Long var1);

    protected abstract int deleteAclChangeSetEntity(Long var1);

    protected abstract int updateChangeSetEntity(Long var1, long var2);

    @Override
    public Ace createAce(Permission permission, Authority authority, ACEType type, AccessStatus accessStatus) {
        ParameterCheck.mandatory((String)"permission", (Object)permission);
        ParameterCheck.mandatory((String)"authority", (Object)authority);
        ParameterCheck.mandatory((String)"type", (Object)((Object)type));
        ParameterCheck.mandatory((String)"accessStatus", (Object)accessStatus);
        AceEntity entity = new AceEntity();
        entity.setApplies(type.getId());
        entity.setAllowed(accessStatus == AccessStatus.ALLOWED);
        entity.setAuthorityId(authority.getId());
        entity.setPermissionId(permission.getId());
        long aceId = this.createAceEntity(entity);
        entity.setVersion(0L);
        entity.setId(aceId);
        return entity;
    }

    @Override
    public Ace getAce(Permission permission, Authority authority, ACEType type, AccessStatus accessStatus) {
        ParameterCheck.mandatory((String)"permission", (Object)permission);
        ParameterCheck.mandatory((String)"authority", (Object)authority);
        ParameterCheck.mandatory((String)"type", (Object)((Object)type));
        ParameterCheck.mandatory((String)"accessStatus", (Object)accessStatus);
        return this.getAceEntity(permission.getId(), authority.getId(), accessStatus == AccessStatus.ALLOWED, type);
    }

    @Override
    public Ace getAce(long aceEntityId) {
        return this.getAceEntity(aceEntityId);
    }

    @Override
    public Ace getOrCreateAce(Permission permission, Authority authority, ACEType type, AccessStatus accessStatus) {
        Ace entity = this.getAce(permission, authority, type, accessStatus);
        if (entity == null) {
            entity = this.createAce(permission, authority, type, accessStatus);
        }
        return entity;
    }

    @Override
    public List<Ace> getAcesByAuthority(long authorityId) {
        return this.getAceEntitiesByAuthority(authorityId);
    }

    @Override
    public List<Map<String, Object>> getAcesAndAuthoritiesByAcl(long idOfAcl) {
        return this.getAceAndAuthorityEntitiesByAcl(idOfAcl);
    }

    @Override
    public int deleteAces(List<Long> aceIds) {
        int totalDeletedCount = 0;
        if (aceIds.size() == 0) {
            return 0;
        }
        if (aceIds.size() <= batchSize) {
            totalDeletedCount = this.deleteAceEntities(aceIds);
        } else {
            Iterator<Long> idIterator = aceIds.iterator();
            ArrayList<Long> batchIds = new ArrayList<Long>(batchSize);
            while (idIterator.hasNext()) {
                Long id = idIterator.next();
                batchIds.add(id);
                if (batchIds.size() != batchSize && idIterator.hasNext()) continue;
                int batchDeletedCount = this.deleteAceEntities(batchIds);
                totalDeletedCount += batchDeletedCount;
                batchIds.clear();
            }
        }
        return totalDeletedCount;
    }

    protected abstract long createAceEntity(AceEntity var1);

    protected abstract AceEntity getAceEntity(long var1);

    protected abstract AceEntity getAceEntity(long var1, long var3, boolean var5, ACEType var6);

    protected abstract List<Ace> getAceEntitiesByAuthority(long var1);

    protected abstract List<Map<String, Object>> getAceAndAuthorityEntitiesByAcl(long var1);

    protected abstract int deleteAceEntities(List<Long> var1);

    @Override
    public Permission createPermission(PermissionReference permissionReference) {
        ParameterCheck.mandatory((String)"permissionReference", (Object)permissionReference);
        PermissionEntity entity = null;
        Pair<Long, QName> qnamePair = this.qnameDAO.getOrCreateQName(permissionReference.getQName());
        if (qnamePair != null) {
            Long qnameId = (Long)qnamePair.getFirst();
            entity = new PermissionEntity(qnameId, permissionReference.getName());
            entity.setVersion(0L);
            Pair<Long, PermissionEntity> entityPair = this.permissionEntityCache.getOrCreateByValue(entity);
            entity = (PermissionEntity)entityPair.getSecond();
        }
        return entity;
    }

    @Override
    public Permission getPermission(long id) {
        Pair<Long, PermissionEntity> entityPair = this.permissionEntityCache.getByKey(id);
        if (entityPair == null) {
            return null;
        }
        return (Permission)entityPair.getSecond();
    }

    @Override
    public Permission getPermission(PermissionReference permissionReference) {
        return this.getPermissionImpl(permissionReference);
    }

    private PermissionEntity getPermissionImpl(PermissionReference permissionReference) {
        Long qnameId;
        PermissionEntity permission;
        Pair<Long, PermissionEntity> entityPair;
        ParameterCheck.mandatory((String)"permissionReference", (Object)permissionReference);
        PermissionEntity entity = null;
        Pair<Long, QName> qnamePair = this.qnameDAO.getOrCreateQName(permissionReference.getQName());
        if (qnamePair != null && (entityPair = this.permissionEntityCache.getByValue(permission = new PermissionEntity(qnameId = (Long)qnamePair.getFirst(), permissionReference.getName()))) != null) {
            entity = (PermissionEntity)entityPair.getSecond();
        }
        return entity;
    }

    private PermissionEntity getPermissionForUpdate(PermissionReference permissionReference) {
        PermissionEntity perm = this.getPermissionImpl(permissionReference);
        PermissionEntity newPerm = new PermissionEntity();
        newPerm.setId(perm.getId());
        newPerm.setVersion(perm.getVersion());
        newPerm.setTypeQNameId(perm.getTypeQNameId());
        newPerm.setName(perm.getName());
        return newPerm;
    }

    @Override
    public Permission getOrCreatePermission(PermissionReference permissionReference) {
        Permission entity = this.getPermission(permissionReference);
        if (entity == null) {
            entity = this.createPermission(permissionReference);
        }
        return entity;
    }

    @Override
    public void renamePermission(QName oldTypeQName, String oldName, QName newTypeQName, String newName) {
        ParameterCheck.mandatory((String)"oldTypeQName", (Object)oldTypeQName);
        ParameterCheck.mandatory((String)"oldName", (Object)oldName);
        ParameterCheck.mandatory((String)"newTypeQName", (Object)newTypeQName);
        ParameterCheck.mandatory((String)"newName", (Object)newName);
        if (oldTypeQName.equals((Object)newTypeQName) && oldName.equals(newName)) {
            throw new IllegalArgumentException("Cannot move permission to itself: " + oldTypeQName + "-" + oldName);
        }
        SimplePermissionReference oldPermRef = SimplePermissionReference.getPermissionReference(oldTypeQName, oldName);
        PermissionEntity permission = this.getPermissionForUpdate(oldPermRef);
        if (permission != null) {
            Long newTypeQNameId = (Long)this.qnameDAO.getOrCreateQName(newTypeQName).getFirst();
            permission.setTypeQNameId(newTypeQNameId);
            permission.setName(newName);
            int updated = this.permissionEntityCache.updateValue(permission.getId(), permission);
            if (updated < 1) {
                this.aclEntityCache.removeByKey(permission.getId());
                throw new ConcurrencyFailureException("PermissionEntity with ID (" + permission.getId() + ") no longer exists or has been updated concurrently");
            }
        }
    }

    @Override
    public void deletePermission(long id) {
        Pair<Long, PermissionEntity> entityPair = this.permissionEntityCache.getByKey(id);
        if (entityPair == null) {
            return;
        }
        int deleted = this.permissionEntityCache.deleteByKey(id);
        if (deleted < 1) {
            this.aclEntityCache.removeByKey(id);
            throw new ConcurrencyFailureException("PermissionEntity with ID " + id + " no longer exists");
        }
    }

    protected abstract PermissionEntity createPermissionEntity(PermissionEntity var1);

    protected abstract PermissionEntity getPermissionEntity(long var1);

    protected abstract PermissionEntity getPermissionEntity(long var1, String var3);

    protected abstract int updatePermissionEntity(PermissionEntity var1);

    protected abstract int deletePermissionEntity(long var1);

    public Authority createAuthority(String authorityName) {
        ParameterCheck.mandatory((String)"authorityName", (Object)authorityName);
        AuthorityEntity entity = new AuthorityEntity();
        entity.setAuthority(authorityName);
        entity.setCrc((Long)CrcHelper.getStringCrcPair(authorityName, 32, true, true).getSecond());
        entity.setVersion(0L);
        Pair<Long, AuthorityEntity> entityPair = this.authorityEntityCache.getOrCreateByValue(entity);
        return (Authority)entityPair.getSecond();
    }

    @Override
    public Authority getAuthority(long id) {
        Pair<Long, AuthorityEntity> entityPair = this.authorityEntityCache.getByKey(id);
        if (entityPair == null) {
            return null;
        }
        return (Authority)entityPair.getSecond();
    }

    @Override
    public Authority getAuthority(String authorityName) {
        return this.getAuthorityImpl(authorityName);
    }

    private AuthorityEntity getAuthorityImpl(String authorityName) {
        ParameterCheck.mandatory((String)"authorityName", (Object)authorityName);
        AuthorityEntity authority = new AuthorityEntity();
        authority.setAuthority(authorityName);
        Pair<Long, AuthorityEntity> entityPair = this.authorityEntityCache.getByValue(authority);
        if (entityPair == null) {
            return null;
        }
        return (AuthorityEntity)entityPair.getSecond();
    }

    private AuthorityEntity getAuthorityForUpdate(String authorityName) {
        AuthorityEntity auth = this.getAuthorityImpl(authorityName);
        if (auth == null) {
            return null;
        }
        AuthorityEntity newAuth = new AuthorityEntity();
        newAuth.setId(auth.getId());
        newAuth.setVersion(auth.getVersion());
        newAuth.setAuthority(auth.getAuthority());
        newAuth.setCrc(auth.getCrc());
        return newAuth;
    }

    @Override
    public Authority getOrCreateAuthority(String name) {
        Authority entity = this.getAuthority(name);
        if (entity == null) {
            entity = this.createAuthority(name);
        }
        return entity;
    }

    @Override
    public void renameAuthority(String before, String after) {
        ParameterCheck.mandatory((String)"before", (Object)before);
        ParameterCheck.mandatory((String)"after", (Object)after);
        AuthorityEntity entity = this.getAuthorityForUpdate(before);
        if (entity != null) {
            entity.setAuthority(after);
            entity.setCrc((Long)CrcHelper.getStringCrcPair(after, 32, true, true).getSecond());
            int updated = this.authorityEntityCache.updateValue(entity.getId(), entity);
            if (updated < 1) {
                this.aclEntityCache.removeByKey(entity.getId());
                throw new ConcurrencyFailureException("AuthorityEntity with ID (" + entity.getId() + ") no longer exists or has been updated concurrently");
            }
        }
    }

    @Override
    public void deleteAuthority(long id) {
        Pair<Long, AuthorityEntity> entityPair = this.authorityEntityCache.getByKey(id);
        if (entityPair == null) {
            return;
        }
        int deleted = this.authorityEntityCache.deleteByKey(id);
        if (deleted < 1) {
            this.aclEntityCache.removeByKey(id);
            throw new ConcurrencyFailureException("AuthorityEntity with ID " + id + " no longer exists");
        }
    }

    protected abstract AuthorityEntity createAuthorityEntity(AuthorityEntity var1);

    protected abstract AuthorityEntity getAuthorityEntity(long var1);

    protected abstract AuthorityEntity getAuthorityEntity(String var1);

    protected abstract int updateAuthorityEntity(AuthorityEntity var1);

    protected abstract int deleteAuthorityEntity(long var1);

    protected abstract long createAceContextEntity(AceContextEntity var1);

    protected abstract AceContextEntity getAceContextEntity(long var1);

    protected abstract int deleteAceContextEntity(long var1);

    protected abstract long createAuthorityAliasEntity(AuthorityAliasEntity var1);

    protected abstract int deleteAuthorityAliasEntity(long var1);

    @Override
    public Long getMaxChangeSetCommitTime() {
        Long time = this.selectMaxChangeSetCommitTime();
        return time == null ? 0L : time;
    }

    protected abstract Long selectMaxChangeSetCommitTime();

    @Override
    public Long getMaxChangeSetIdByCommitTime(long maxCommitTime) {
        Long id = this.selectMaxChangeSetIdBeforeCommitTime(maxCommitTime);
        return id == null ? 0L : id;
    }

    protected abstract Long selectMaxChangeSetIdBeforeCommitTime(long var1);

    private class AuthorityEntityCallbackDAO
    implements EntityLookupCache.EntityLookupCallbackDAO<Long, AuthorityEntity, String> {
        private AuthorityEntityCallbackDAO() {
        }

        private final Pair<Long, AuthorityEntity> convertEntityToPair(AuthorityEntity entity) {
            if (entity == null) {
                return null;
            }
            return new Pair((Object)entity.getId(), (Object)entity);
        }

        @Override
        public String getValueKey(AuthorityEntity value) {
            return value.getAuthority();
        }

        @Override
        public Pair<Long, AuthorityEntity> createValue(AuthorityEntity value) {
            AuthorityEntity entity = AbstractAclCrudDAOImpl.this.createAuthorityEntity(value);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, AuthorityEntity> findByKey(Long key) {
            AuthorityEntity entity = AbstractAclCrudDAOImpl.this.getAuthorityEntity(key);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, AuthorityEntity> findByValue(AuthorityEntity value) {
            if (value == null || value.getAuthority() == null) {
                throw new AlfrescoRuntimeException("Unexpected: AuthorityEntity / name must not be null");
            }
            return this.convertEntityToPair(AbstractAclCrudDAOImpl.this.getAuthorityEntity(value.getAuthority()));
        }

        @Override
        public int updateValue(Long key, AuthorityEntity value) {
            return AbstractAclCrudDAOImpl.this.updateAuthorityEntity(value);
        }

        @Override
        public int deleteByKey(Long key) {
            return AbstractAclCrudDAOImpl.this.deleteAuthorityEntity(key);
        }

        @Override
        public int deleteByValue(AuthorityEntity value) {
            throw new UnsupportedOperationException("deleteByValue");
        }
    }

    private class PermissionEntityCallbackDAO
    implements EntityLookupCache.EntityLookupCallbackDAO<Long, PermissionEntity, PermissionEntity> {
        private PermissionEntityCallbackDAO() {
        }

        private final Pair<Long, PermissionEntity> convertEntityToPair(PermissionEntity entity) {
            if (entity == null) {
                return null;
            }
            return new Pair((Object)entity.getId(), (Object)entity);
        }

        @Override
        public PermissionEntity getValueKey(PermissionEntity value) {
            return value;
        }

        @Override
        public Pair<Long, PermissionEntity> createValue(PermissionEntity value) {
            PermissionEntity entity = AbstractAclCrudDAOImpl.this.createPermissionEntity(value);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, PermissionEntity> findByKey(Long key) {
            PermissionEntity entity = AbstractAclCrudDAOImpl.this.getPermissionEntity(key);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, PermissionEntity> findByValue(PermissionEntity value) {
            if (value == null || value.getName() == null || value.getTypeQNameId() == null) {
                throw new AlfrescoRuntimeException("Unexpected: PermissionEntity / name / qnameId must not be null");
            }
            return this.convertEntityToPair(AbstractAclCrudDAOImpl.this.getPermissionEntity(value.getTypeQNameId(), value.getName()));
        }

        @Override
        public int updateValue(Long key, PermissionEntity value) {
            return AbstractAclCrudDAOImpl.this.updatePermissionEntity(value);
        }

        @Override
        public int deleteByKey(Long key) {
            return AbstractAclCrudDAOImpl.this.deletePermissionEntity(key);
        }

        @Override
        public int deleteByValue(PermissionEntity value) {
            throw new UnsupportedOperationException("deleteByValue");
        }
    }

    private class AclEntityCallbackDAO
    implements EntityLookupCache.EntityLookupCallbackDAO<Long, AclEntity, Serializable> {
        private AclEntityCallbackDAO() {
        }

        private final Pair<Long, AclEntity> convertEntityToPair(AclEntity entity) {
            if (entity == null) {
                return null;
            }
            return new Pair((Object)entity.getId(), (Object)entity);
        }

        @Override
        public Serializable getValueKey(AclEntity value) {
            return null;
        }

        @Override
        public Pair<Long, AclEntity> createValue(AclEntity value) {
            AclEntity entity = AbstractAclCrudDAOImpl.this.createAclEntity(value);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, AclEntity> findByKey(Long key) {
            AclEntity entity = AbstractAclCrudDAOImpl.this.getAclEntity(key);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, AclEntity> findByValue(AclEntity value) {
            if (value != null && value.getId() != null) {
                return this.findByKey(value.getId());
            }
            return null;
        }

        @Override
        public int updateValue(Long key, AclEntity value) {
            return AbstractAclCrudDAOImpl.this.updateAclEntity(value);
        }

        @Override
        public int deleteByKey(Long key) {
            return AbstractAclCrudDAOImpl.this.deleteAclEntity(key);
        }

        @Override
        public int deleteByValue(AclEntity value) {
            throw new UnsupportedOperationException("deleteByValue");
        }
    }
}

