/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.tenant;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.domain.tenant.TenantAdminDAO;
import org.alfresco.repo.domain.tenant.TenantEntity;
import org.alfresco.repo.domain.tenant.TenantUpdateEntity;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class TenantAdminDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private TenantAdminDAO tenantAdminDAO;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.tenantAdminDAO = (TenantAdminDAO)this.ctx.getBean("tenantAdminDAO");
    }

    private TenantEntity createTenant(final String tenantDomain, final boolean enabled) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<TenantEntity> callback = new RetryingTransactionHelper.RetryingTransactionCallback<TenantEntity>(){

            @Override
            public TenantEntity execute() throws Throwable {
                TenantEntity tenantEntity = new TenantEntity();
                tenantEntity.setTenantDomain(tenantDomain);
                tenantEntity.setEnabled(enabled);
                return TenantAdminDAOTest.this.tenantAdminDAO.createTenant(tenantEntity);
            }
        };
        return this.txnHelper.doInTransaction(callback, false);
    }

    private void deleteTenant(final String tenantDomain) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TenantAdminDAOTest.this.tenantAdminDAO.deleteTenant(tenantDomain);
                return null;
            }
        };
        this.txnHelper.doInTransaction(callback, false);
    }

    private void updateTenant(final TenantUpdateEntity tenantUpdateEntity) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TenantAdminDAOTest.this.tenantAdminDAO.updateTenant(tenantUpdateEntity);
                return null;
            }
        };
        this.txnHelper.doInTransaction(callback, false);
    }

    private TenantEntity getTenant(final String tenantDomain) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<TenantEntity> callback = new RetryingTransactionHelper.RetryingTransactionCallback<TenantEntity>(){

            @Override
            public TenantEntity execute() throws Throwable {
                return TenantAdminDAOTest.this.tenantAdminDAO.getTenant(tenantDomain);
            }
        };
        return this.txnHelper.doInTransaction(callback, true);
    }

    private TenantUpdateEntity getTenantForUpdate(final String tenantDomain) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<TenantUpdateEntity> callback = new RetryingTransactionHelper.RetryingTransactionCallback<TenantUpdateEntity>(){

            @Override
            public TenantUpdateEntity execute() throws Throwable {
                return TenantAdminDAOTest.this.tenantAdminDAO.getTenantForUpdate(tenantDomain);
            }
        };
        return this.txnHelper.doInTransaction(callback, true);
    }

    private List<TenantEntity> listTenants() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<List<TenantEntity>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<TenantEntity>>(){

            @Override
            public List<TenantEntity> execute() throws Throwable {
                return TenantAdminDAOTest.this.tenantAdminDAO.listTenants();
            }
        };
        return this.txnHelper.doInTransaction(callback, true);
    }

    public void testCreateAndDeleteTenant() throws Exception {
        String tenantDomain = this.getName() + "-" + System.currentTimeMillis();
        TenantEntity tenantEntity = this.getTenant(tenantDomain);
        TenantAdminDAOTest.assertNull((Object)tenantEntity);
        TenantEntity createTenantEntity = this.createTenant(tenantDomain, false);
        TenantAdminDAOTest.assertNotNull((Object)createTenantEntity);
        tenantEntity = this.getTenant(tenantDomain);
        TenantAdminDAOTest.assertEquals((Object)createTenantEntity, (Object)tenantEntity);
        this.deleteTenant(tenantDomain);
        TenantAdminDAOTest.assertNull((Object)this.getTenant(tenantDomain));
    }

    public void testCreateTenantWithRollback() throws Exception {
        final String tenantDomain = this.getName() + "-" + System.currentTimeMillis();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TenantAdminDAOTest.this.createTenant(tenantDomain, false);
                throw new RuntimeException("Forced");
            }
        };
        try {
            this.txnHelper.doInTransaction(callback);
            TenantAdminDAOTest.fail((String)"Transaction didn't roll back");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TenantAdminDAOTest.assertNull((Object)this.getTenant(tenantDomain));
    }

    public void testUpdateTenant() throws Exception {
        String tenantDomain = this.getName() + "-" + System.currentTimeMillis();
        TenantEntity tenantEntity = this.getTenant(tenantDomain);
        TenantAdminDAOTest.assertNull((Object)tenantEntity);
        TenantEntity createTenantEntity = this.createTenant(tenantDomain, false);
        TenantAdminDAOTest.assertNotNull((Object)createTenantEntity);
        TenantAdminDAOTest.assertFalse((boolean)createTenantEntity.getEnabled());
        TenantUpdateEntity tenantUpdateEntity = this.getTenantForUpdate(tenantDomain);
        TenantAdminDAOTest.assertEquals((Object)createTenantEntity, (Object)tenantUpdateEntity);
        TenantAdminDAOTest.assertFalse((boolean)tenantUpdateEntity.getEnabled());
        tenantUpdateEntity.setEnabled(true);
        this.updateTenant(tenantUpdateEntity);
        tenantEntity = this.getTenant(tenantDomain);
        TenantAdminDAOTest.assertNotNull((Object)tenantEntity);
        TenantAdminDAOTest.assertTrue((boolean)tenantEntity.getEnabled());
        this.deleteTenant(tenantDomain);
        TenantAdminDAOTest.assertNull((Object)this.getTenant(tenantDomain));
    }

    public void testListTenants() throws Exception {
        TenantEntity tenantEntity;
        String tenantDomain;
        int i;
        String tenantDomainPrefix = this.getName() + "-" + System.currentTimeMillis();
        int cnt = 5;
        int beforeCnt = this.listTenants().size();
        for (i = 1; i <= 5; ++i) {
            tenantDomain = tenantDomainPrefix + "-" + i;
            tenantEntity = this.getTenant(tenantDomain);
            TenantAdminDAOTest.assertNull((Object)tenantEntity);
            tenantEntity = this.createTenant(tenantDomain, false);
            TenantAdminDAOTest.assertNotNull((Object)tenantEntity);
            TenantAdminDAOTest.assertEquals((int)(i + beforeCnt), (int)this.listTenants().size());
            tenantEntity = this.getTenant(tenantDomain);
            TenantAdminDAOTest.assertNotNull((Object)tenantEntity);
        }
        for (i = 5; i >= 1; --i) {
            tenantDomain = tenantDomainPrefix + "-" + i;
            tenantEntity = this.getTenant(tenantDomain);
            TenantAdminDAOTest.assertNotNull((Object)tenantEntity);
            this.deleteTenant(tenantDomain);
            TenantAdminDAOTest.assertEquals((int)(i - 1 + beforeCnt), (int)this.listTenants().size());
            tenantEntity = this.getTenant(tenantDomain);
            TenantAdminDAOTest.assertNull((Object)tenantEntity);
        }
    }
}

