/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.download;

import java.util.Date;
import java.util.List;
import org.alfresco.repo.download.ActionServiceHelper;
import org.alfresco.repo.download.DownloadStorage;
import org.alfresco.repo.download.cannedquery.DownloadEntity;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.download.DownloadService;
import org.alfresco.service.cmr.download.DownloadStatus;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ParameterCheck;

public class DownloadServiceImpl
implements DownloadService {
    private ActionServiceHelper actionServiceHelper;
    private DownloadStorage downloadStorage;
    private RetryingTransactionHelper transactionHelper;

    public void setActionServiceHelper(ActionServiceHelper actionServiceHelper) {
        this.actionServiceHelper = actionServiceHelper;
    }

    public void setTransactionHelper(RetryingTransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    public void setDownloadStorage(DownloadStorage downloadStorage) {
        this.downloadStorage = downloadStorage;
    }

    @Override
    public NodeRef createDownload(final NodeRef[] requestedNodes, final boolean recursive) {
        ParameterCheck.mandatory((String)"nodeRefs", (Object)requestedNodes);
        if (requestedNodes.length < 1) {
            throw new IllegalArgumentException("Need at least 1 node ref");
        }
        NodeRef downloadNode = this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                NodeRef downloadNode = DownloadServiceImpl.this.downloadStorage.createDownloadNode(recursive);
                for (NodeRef node : requestedNodes) {
                    DownloadServiceImpl.this.downloadStorage.addNodeToDownload(downloadNode, node);
                }
                return downloadNode;
            }
        }, false, true);
        this.actionServiceHelper.executeAction(downloadNode);
        return downloadNode;
    }

    @Override
    public DownloadStatus getDownloadStatus(NodeRef downloadNode) {
        ParameterCheck.mandatory((String)"downloadNode", (Object)downloadNode);
        return this.downloadStorage.getDownloadStatus(downloadNode);
    }

    @Override
    public void deleteDownloads(Date before) {
        List<List<DownloadEntity>> downloadPages = this.downloadStorage.getDownloadsCreatedBefore(before);
        for (List<DownloadEntity> page : downloadPages) {
            for (DownloadEntity download : page) {
                this.downloadStorage.delete(download.getNodeRef());
            }
        }
    }

    @Override
    public void cancelDownload(NodeRef downloadNodeRef) {
        ParameterCheck.mandatory((String)"downloadNodeRef", (Object)downloadNodeRef);
        this.downloadStorage.cancelDownload(downloadNodeRef);
    }
}

