/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ImapModel;
import org.alfresco.repo.imap.AbstractMimeMessage;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IncomingImapMessage
extends AbstractMimeMessage {
    private Log logger = LogFactory.getLog(IncomingImapMessage.class);
    private ContentReader contentReader;

    public IncomingImapMessage(FileInfo fileInfo, ServiceRegistry serviceRegistry, MimeMessage message) throws MessagingException {
        super(Session.getDefaultInstance((Properties)new Properties()));
        this.wrappedMessage = message;
        this.buildMessage(fileInfo, serviceRegistry);
    }

    @Override
    public void buildMessageInternal() throws MessagingException {
        this.setMessageHeaders();
        NodeService nodeService = this.serviceRegistry.getNodeService();
        nodeService.addAspect(this.messageFileInfo.getNodeRef(), ImapModel.ASPECT_IMAP_CONTENT, null);
        this.imapService.setFlags(this.messageFileInfo, this.flags, true);
        this.writeContent();
    }

    private void writeContent() throws MessagingException {
        ContentWriter writer = this.serviceRegistry.getContentService().getWriter(this.messageFileInfo.getNodeRef(), ContentModel.PROP_CONTENT, true);
        writer.setMimetype("message/rfc822");
        try {
            OutputStream outputStream = writer.getContentOutputStream();
            this.wrappedMessage.writeTo(outputStream);
            outputStream.close();
            this.wrappedMessage = null;
            this.contentReader = this.serviceRegistry.getContentService().getReader(this.messageFileInfo.getNodeRef(), ContentModel.PROP_CONTENT);
        }
        catch (ContentIOException e) {
            throw new MessagingException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    protected InputStream getContentStream() throws MessagingException {
        try {
            if (this.contentStream == null) {
                this.contentStream = this.contentReader.getContentInputStream();
            }
            return this.contentStream;
        }
        catch (Exception e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }
}

