/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.importer.ImportTimerProgress;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.view.ImporterBinding;
import org.alfresco.service.cmr.view.ImporterProgress;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.debug.NodeStoreInspector;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public class ImporterComponentTest
extends BaseSpringTest {
    private ImporterService importerService;
    private ImporterBootstrap importerBootstrap;
    private VersionService versionService;
    private NodeService nodeService;
    private StoreRef storeRef;
    private AuthenticationComponent authenticationComponent;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
        this.importerService = (ImporterService)this.applicationContext.getBean(ServiceRegistry.IMPORTER_SERVICE.getLocalName());
        this.importerBootstrap = (ImporterBootstrap)((Object)this.applicationContext.getBean("spacesBootstrap"));
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.versionService = (VersionService)this.applicationContext.getBean("VersionService");
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
    }

    protected void onTearDownInTransaction() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.onTearDownInTransaction();
    }

    public void testImport() throws Exception {
        InputStream test = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
        InputStreamReader testReader = new InputStreamReader(test, "UTF-8");
        Location location = new Location(this.storeRef);
        this.importerService.importView(testReader, location, null, (ImporterProgress)new ImportTimerProgress());
        System.out.println(NodeStoreInspector.dumpNodeStore(this.nodeService, this.storeRef));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportWithAuditableProperties() throws Exception {
        InputStream test = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
        InputStreamReader testReader = new InputStreamReader(test, "UTF-8");
        Location location = new Location(this.storeRef);
        try {
            this.importerService.importView(testReader, location, null, (ImporterProgress)new ImportTimerProgress());
        }
        finally {
            testReader.close();
        }
        NodeRef rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        List childAssocs = this.nodeService.getChildAssocs(rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)new RegexQNamePattern("http://www.alfresco.org/model/content/1.0", "SpaceWith.*"));
        ImporterComponentTest.assertEquals((String)"'SpaceWith*' path not found", (int)2, (int)childAssocs.size());
        NodeRef nodeRef = ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
        Map nodeProps = this.nodeService.getProperties(nodeRef);
        String createdDate = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_CREATED));
        String creator = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_CREATOR));
        String modifiedDate = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_MODIFIED));
        String modifier = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_MODIFIER));
        ImporterComponentTest.assertEquals((String)"cm:created not preserved during import", (String)ISO8601DateFormat.format((Date)ISO8601DateFormat.parse((String)"2009-05-01T00:00:00.000+01:00")), (String)createdDate);
        ImporterComponentTest.assertEquals((String)"cm:creator not preserved during import", (String)"Import Creator", (String)creator);
        ImporterComponentTest.assertEquals((String)"cm:modified not preserved during import", (String)ISO8601DateFormat.format((Date)ISO8601DateFormat.parse((String)"2009-05-02T00:00:00.000+01:00")), (String)modifiedDate);
        ImporterComponentTest.assertEquals((String)"cm:modifier not preserved during import", (String)"Import Modifier", (String)modifier);
        nodeRef = ((ChildAssociationRef)childAssocs.get(1)).getChildRef();
        nodeProps = this.nodeService.getProperties(nodeRef);
        createdDate = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_CREATED));
        creator = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_CREATOR));
        modifiedDate = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_MODIFIED));
        modifier = (String)DefaultTypeConverter.INSTANCE.convert(String.class, nodeProps.get(ContentModel.PROP_MODIFIER));
        ImporterComponentTest.assertEquals((String)"cm:created not preserved during import", (String)ISO8601DateFormat.format((Date)ISO8601DateFormat.parse((String)"2009-05-01T00:00:00.000+01:00")), (String)createdDate);
        ImporterComponentTest.assertEquals((String)"cm:creator not preserved during import", (String)"Import Creator", (String)creator);
        ImporterComponentTest.assertEquals((String)"cm:modifier not preserved during import", (String)AuthenticationUtil.getSystemUserName(), (String)modifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportWithVersioning() throws Exception {
        InputStream test = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
        InputStreamReader testReader = new InputStreamReader(test, "UTF-8");
        Location location = new Location(this.storeRef);
        try {
            this.importerService.importView(testReader, location, null, (ImporterProgress)new ImportTimerProgress());
        }
        finally {
            testReader.close();
        }
        NodeRef rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        List childAssocs = this.nodeService.getChildAssocs(rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)new RegexQNamePattern("http://www.alfresco.org/model/content/1.0", "Version Containing Folder"));
        ImporterComponentTest.assertEquals((String)"'Version Folder' path not found", (int)1, (int)childAssocs.size());
        NodeRef versionFolder = ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
        childAssocs = this.nodeService.getChildAssocs(versionFolder, RegexQNamePattern.MATCH_ALL, (QNamePattern)new RegexQNamePattern("http://www.alfresco.org/model/content/1.0", "Versioned Node"));
        ImporterComponentTest.assertEquals((String)"'Versioned Node' path not found", (int)1, (int)childAssocs.size());
        NodeRef versionedNode = ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
        ImporterComponentTest.assertEquals((Object)"1.15", (Object)this.nodeService.getProperty(versionedNode, ContentModel.PROP_VERSION_LABEL));
        ImporterComponentTest.assertEquals(null, (Object)this.versionService.getVersionHistory(versionFolder));
        VersionHistory vh = this.versionService.getVersionHistory(versionedNode);
        ImporterComponentTest.assertNotNull((Object)vh);
        ImporterComponentTest.assertEquals((int)1, (int)vh.getAllVersions().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportWithUuidBinding() throws Exception {
        Location location = new Location(this.storeRef);
        InputStream test1 = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
        InputStreamReader testReader1 = new InputStreamReader(test1, "UTF-8");
        try {
            this.importerService.importView(testReader1, location, null, (ImporterProgress)new ImportTimerProgress());
        }
        finally {
            testReader1.close();
        }
        InputStream test2 = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
        InputStreamReader testReader2 = new InputStreamReader(test2, "UTF-8");
        try {
            this.importerBootstrap.setUuidBinding(ImporterBinding.UUID_BINDING.CREATE_NEW_WITH_UUID);
            this.importerService.importView(testReader2, location, null, (ImporterProgress)new ImportTimerProgress());
        }
        finally {
            testReader2.close();
        }
        InputStream test3 = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
        InputStreamReader testReader3 = new InputStreamReader(test3, "UTF-8");
        try {
            this.importerBootstrap.setUuidBinding(ImporterBinding.UUID_BINDING.THROW_ON_COLLISION);
            this.importerService.importView(testReader3, location, null, (ImporterProgress)new ImportTimerProgress());
            ImporterComponentTest.fail((String)"Failed to detected collision of UUID on import with THROW_ON_COLLISION");
        }
        catch (Throwable e) {
        }
        finally {
            this.importerBootstrap.setUuidBinding(ImporterBinding.UUID_BINDING.CREATE_NEW_WITH_UUID);
            testReader3.close();
        }
        System.out.println(NodeStoreInspector.dumpNodeStore(this.nodeService, this.storeRef));
    }

    public void testBootstrap() {
        StoreRef bootstrapStoreRef = new StoreRef("workspace", "Test_" + System.currentTimeMillis());
        this.importerBootstrap.setStoreUrl(bootstrapStoreRef.toString());
        this.importerBootstrap.bootstrap();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        System.out.println(NodeStoreInspector.dumpNodeStore(this.nodeService, bootstrapStoreRef));
    }
}

