/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.invitation.InvitationSearchCriteriaImpl;
import org.alfresco.repo.invitation.ModeratedInvitationImpl;
import org.alfresco.repo.invitation.NominatedInvitationImpl;
import org.alfresco.repo.invitation.WorkflowModelModeratedInvitation;
import org.alfresco.repo.invitation.WorkflowModelNominatedInvitation;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.PasswordGenerator;
import org.alfresco.repo.security.authentication.UserNameGenerator;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.repo.workflow.CancelWorkflowActionExecuter;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationException;
import org.alfresco.service.cmr.invitation.InvitationExceptionForbidden;
import org.alfresco.service.cmr.invitation.InvitationExceptionNotFound;
import org.alfresco.service.cmr.invitation.InvitationExceptionUserError;
import org.alfresco.service.cmr.invitation.InvitationSearchCriteria;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.invitation.ModeratedInvitation;
import org.alfresco.service.cmr.invitation.NominatedInvitation;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.workflow.WorkflowAdminService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.UrlUtil;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class InvitationServiceImpl
implements InvitationService,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private static final Log logger = LogFactory.getLog(InvitationServiceImpl.class);
    private WorkflowService workflowService;
    private WorkflowAdminService workflowAdminService;
    private ActionService actionService;
    private PersonService personService;
    private SiteService siteService;
    private MutableAuthenticationService authenticationService;
    private PermissionService permissionService;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private UserNameGenerator usernameGenerator;
    private PasswordGenerator passwordGenerator;
    private PolicyComponent policyComponent;
    private SysAdminParams sysAdminParams;
    public static final int MAX_NUM_INVITEE_USER_NAME_GEN_TRIES = 10;
    private int maxUserNameGenRetries = 10;
    private boolean sendEmails = true;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"WorkflowService", (Object)this.workflowService);
        PropertyCheck.mandatory((Object)this, (String)"ActionService", (Object)this.actionService);
        PropertyCheck.mandatory((Object)this, (String)"PersonService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"SiteService", (Object)this.siteService);
        PropertyCheck.mandatory((Object)this, (String)"AuthenticationService", (Object)this.authenticationService);
        PropertyCheck.mandatory((Object)this, (String)"PermissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"NamespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"NodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"UserNameGenerator", (Object)this.usernameGenerator);
        PropertyCheck.mandatory((Object)this, (String)"PasswordGenerator", (Object)this.passwordGenerator);
        PropertyCheck.mandatory((Object)this, (String)"PolicyComponent", (Object)this.policyComponent);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), SiteModel.TYPE_SITE, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
    }

    @Override
    public List<String> getInvitationServiceWorkflowNames() {
        ArrayList<String> ret = new ArrayList<String>(3);
        ret.add("jbpm$inwf:invitation-nominated");
        ret.add("activiti$activitiInvitationNominated");
        ret.add("jbpm$imwf:invitation-moderated");
        ret.add("activiti$activitiInvitationModerated");
        ret.add("jbpm$wf:invite");
        return ret;
    }

    @Override
    public NominatedInvitation inviteNominated(String inviteeUserName, Invitation.ResourceType resourceType, String resourceName, String inviteeRole, String serverPath, String acceptUrl, String rejectUrl) {
        NodeRef person = this.personService.getPerson(inviteeUserName);
        Serializable firstNameVal = this.getNodeService().getProperty(person, ContentModel.PROP_FIRSTNAME);
        Serializable lastNameVal = this.getNodeService().getProperty(person, ContentModel.PROP_LASTNAME);
        Serializable emailVal = this.getNodeService().getProperty(person, ContentModel.PROP_EMAIL);
        String firstName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)firstNameVal);
        String lastName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)lastNameVal);
        String email = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)emailVal);
        return this.inviteNominated(firstName, lastName, email, inviteeUserName, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
    }

    @Override
    public NominatedInvitation inviteNominated(String inviteeUserName, Invitation.ResourceType resourceType, String resourceName, String inviteeRole, String acceptUrl, String rejectUrl) {
        NodeRef person = this.personService.getPerson(inviteeUserName);
        Serializable firstNameVal = this.getNodeService().getProperty(person, ContentModel.PROP_FIRSTNAME);
        Serializable lastNameVal = this.getNodeService().getProperty(person, ContentModel.PROP_LASTNAME);
        Serializable emailVal = this.getNodeService().getProperty(person, ContentModel.PROP_EMAIL);
        String firstName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)firstNameVal);
        String lastName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)lastNameVal);
        String email = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)emailVal);
        String serverPath = UrlUtil.getShareUrl(this.sysAdminParams);
        return this.inviteNominated(firstName, lastName, email, inviteeUserName, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
    }

    @Override
    public NominatedInvitation inviteNominated(String inviteeFirstName, String inviteeLastName, String inviteeEmail, Invitation.ResourceType resourceType, String resourceName, String inviteeRole, String acceptUrl, String rejectUrl) {
        String serverPath = UrlUtil.getShareUrl(this.sysAdminParams);
        return this.inviteNominated(inviteeFirstName, inviteeLastName, inviteeEmail, null, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
    }

    @Override
    public NominatedInvitation inviteNominated(String inviteeFirstName, String inviteeLastName, String inviteeEmail, Invitation.ResourceType resourceType, String resourceName, String inviteeRole, String serverPath, String acceptUrl, String rejectUrl) {
        return this.inviteNominated(inviteeFirstName, inviteeLastName, inviteeEmail, null, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
    }

    private NominatedInvitation inviteNominated(String inviteeFirstName, String inviteeLastName, String inviteeEmail, String inviteeUserName, Invitation.ResourceType resourceType, String resourceName, String inviteeRole, String serverPath, String acceptUrl, String rejectUrl) {
        if (resourceType == Invitation.ResourceType.WEB_SITE) {
            return this.startNominatedInvite(inviteeFirstName, inviteeLastName, inviteeEmail, inviteeUserName, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        }
        throw new InvitationException("unknown resource type", new Object[0]);
    }

    @Override
    public ModeratedInvitation inviteModerated(String inviteeComments, String inviteeUserName, Invitation.ResourceType resourceType, String resourceName, String inviteeRole) {
        if (resourceType == Invitation.ResourceType.WEB_SITE) {
            return this.startModeratedInvite(inviteeComments, inviteeUserName, resourceType, resourceName, inviteeRole);
        }
        throw new InvitationException("unknown resource type", new Object[0]);
    }

    @Override
    public Invitation accept(String invitationId, String ticket) {
        WorkflowTask startTask = this.getStartTask(invitationId);
        NominatedInvitation invitation = this.getNominatedInvitation(startTask);
        if (invitation == null) {
            throw new InvitationException("State error, accept may only be called on a nominated invitation.", new Object[0]);
        }
        if (!invitation.getTicket().equals(ticket)) {
            String msg = "Response to invite has supplied an invalid ticket. The response to the invitation could thus not be processed";
            throw new InvitationException(msg, new Object[0]);
        }
        this.endInvitation(startTask, "accept", null, WorkflowModelNominatedInvitation.WF_TASK_INVITE_PENDING, WorkflowModelNominatedInvitation.WF_TASK_ACTIVIT_INVITE_PENDING);
        return invitation;
    }

    private void endInvitation(WorkflowTask startTask, String transition, Map<QName, Serializable> properties, QName ... taskTypes) {
        if (TransactionalResourceHelper.getSet(this.getClass().getName()).add(startTask.getPath().getInstance().getId())) {
            WorkflowTask task;
            List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(startTask.getPath().getId());
            if (tasks.size() == 1 && this.taskTypeMatches(task = tasks.get(0), taskTypes)) {
                if (properties != null) {
                    this.workflowService.updateTask(task.getId(), properties, null, null);
                }
                this.workflowService.endTask(task.getId(), transition);
                return;
            }
            Object[] objs = new Object[]{startTask.getPath().getInstance().getId()};
            throw new InvitationExceptionUserError("invitation.invite.already_finished", objs);
        }
    }

    @Override
    public Invitation approve(String invitationId, String reason) {
        WorkflowTask startTask = this.getStartTask(invitationId);
        ModeratedInvitation invitation = this.getModeratedInvitation(startTask);
        if (invitation == null) {
            String msg = "State error, can only call approve on a Moderated invitation.";
            throw new InvitationException(msg, new Object[0]);
        }
        String currentUser = this.authenticationService.getCurrentUserName();
        this.checkManagerRole(currentUser, invitation.getResourceType(), invitation.getResourceName());
        HashMap<QName, Serializable> wfReviewProps = new HashMap<QName, Serializable>();
        wfReviewProps.put(ContentModel.PROP_OWNER, (Serializable)((Object)currentUser));
        wfReviewProps.put(WorkflowModelModeratedInvitation.WF_PROP_REVIEW_COMMENTS, (Serializable)((Object)reason));
        this.endInvitation(startTask, "approve", wfReviewProps, WorkflowModelModeratedInvitation.WF_ACTIVITI_REVIEW_TASK, WorkflowModelModeratedInvitation.WF_REVIEW_TASK);
        return invitation;
    }

    @Override
    public Invitation reject(String invitationId, String reason) {
        WorkflowTask startTask = this.getStartTask(invitationId);
        if (this.taskTypeMatches(startTask, WorkflowModelModeratedInvitation.WF_START_TASK)) {
            return this.rejectModeratedInvitation(startTask, reason);
        }
        return this.rejectNominatedInvitation(startTask);
    }

    private Invitation rejectModeratedInvitation(WorkflowTask startTask, String reason) {
        ModeratedInvitation invitation = this.getModeratedInvitation(startTask);
        String rejecterUserName = this.authenticationService.getCurrentUserName();
        this.checkManagerRole(rejecterUserName, invitation.getResourceType(), invitation.getResourceName());
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_OWNER, (Serializable)((Object)rejecterUserName));
        properties.put(WorkflowModelModeratedInvitation.WF_PROP_REVIEW_COMMENTS, (Serializable)((Object)reason));
        this.endInvitation(startTask, "reject", properties, WorkflowModelModeratedInvitation.WF_ACTIVITI_REVIEW_TASK, WorkflowModelModeratedInvitation.WF_REVIEW_TASK);
        return invitation;
    }

    private Invitation rejectNominatedInvitation(WorkflowTask startTask) {
        NominatedInvitation invitation = this.getNominatedInvitation(startTask);
        this.endInvitation(startTask, "reject", null, WorkflowModelNominatedInvitation.WF_TASK_INVITE_PENDING, WorkflowModelNominatedInvitation.WF_TASK_ACTIVIT_INVITE_PENDING);
        return invitation;
    }

    @Override
    public Invitation cancel(String invitationId) {
        try {
            WorkflowTask startTask = this.getStartTask(invitationId);
            if (this.taskTypeMatches(startTask, WorkflowModelModeratedInvitation.WF_START_TASK)) {
                return this.cancelModeratedInvitation(startTask);
            }
            return this.cancelNominatedInvitation(startTask);
        }
        catch (InvitationExceptionNotFound e) {
            return null;
        }
    }

    private Invitation cancelModeratedInvitation(WorkflowTask startTask) {
        ModeratedInvitation invitation = this.getModeratedInvitation(startTask);
        String currentUserName = this.authenticationService.getCurrentUserName();
        if (!AuthenticationUtil.isRunAsUserTheSystemUser() && !currentUserName.equals(invitation.getInviteeUserName())) {
            this.checkManagerRole(currentUserName, invitation.getResourceType(), invitation.getResourceName());
        }
        if (this.siteService.getSite(invitation.getResourceName()) != null) {
            this.workflowService.cancelWorkflow(invitation.getInviteId());
        }
        return invitation;
    }

    private Invitation cancelNominatedInvitation(WorkflowTask startTask) {
        NominatedInvitation invitation = this.getNominatedInvitation(startTask);
        String currentUserName = this.authenticationService.getCurrentUserName();
        if (!AuthenticationUtil.isRunAsUserTheSystemUser() && !currentUserName.equals(invitation.getInviterUserName())) {
            this.checkManagerRole(currentUserName, invitation.getResourceType(), invitation.getResourceName());
        }
        if (this.siteService.getSite(invitation.getResourceName()) != null) {
            this.endInvitation(startTask, "cancel", null, WorkflowModelNominatedInvitation.WF_TASK_INVITE_PENDING, WorkflowModelNominatedInvitation.WF_TASK_ACTIVIT_INVITE_PENDING);
        }
        return invitation;
    }

    @Override
    public Invitation getInvitation(String invitationId) {
        WorkflowTask startTask = this.getStartTask(invitationId);
        return this.getInvitation(startTask);
    }

    private Invitation getInvitation(WorkflowTask startTask) {
        Invitation invitation = this.getNominatedInvitation(startTask);
        if (invitation == null) {
            invitation = this.getModeratedInvitation(startTask);
        }
        return invitation;
    }

    private Map<String, WorkflowTask> getInvitationTasks(List<String> invitationIds) {
        for (String invitationId : invitationIds) {
            this.validateInvitationId(invitationId);
        }
        long start = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        List<WorkflowTask> inviteStartTasks = this.workflowService.getStartTasks(invitationIds, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("  getInvitationTask(" + invitationIds.size() + ") in " + (System.currentTimeMillis() - start) + " ms"));
        }
        HashMap<String, WorkflowTask> result = new HashMap<String, WorkflowTask>(inviteStartTasks.size() * 2);
        for (WorkflowTask inviteStartTask : inviteStartTasks) {
            String invitationId = inviteStartTask.getPath().getInstance().getId();
            result.put(invitationId, inviteStartTask);
        }
        return result;
    }

    private ModeratedInvitation getModeratedInvitation(WorkflowTask startTask) {
        ModeratedInvitationImpl invitation = null;
        if (this.taskTypeMatches(startTask, WorkflowModelModeratedInvitation.WF_START_TASK)) {
            String invitationId = startTask.getPath().getInstance().getId();
            invitation = new ModeratedInvitationImpl(invitationId, startTask.getProperties());
        }
        return invitation;
    }

    private NominatedInvitation getNominatedInvitation(WorkflowTask startTask) {
        NominatedInvitationImpl invitation = null;
        if (this.taskTypeMatches(startTask, WorkflowModelNominatedInvitation.WF_TASK_INVITE_TO_SITE)) {
            Date inviteDate = startTask.getPath().getInstance().getStartDate();
            String invitationId = startTask.getPath().getInstance().getId();
            invitation = new NominatedInvitationImpl(invitationId, inviteDate, startTask.getProperties());
        }
        return invitation;
    }

    private boolean taskTypeMatches(WorkflowTask task, QName ... types) {
        QName taskDefName = task.getDefinition().getMetadata().getName();
        return Arrays.asList(types).contains(taskDefName);
    }

    private WorkflowTask getStartTask(String invitationId) {
        this.validateInvitationId(invitationId);
        WorkflowTask startTask = null;
        try {
            startTask = this.workflowService.getStartTask(invitationId);
        }
        catch (WorkflowException we) {
            // empty catch block
        }
        if (startTask == null) {
            Object[] objs = new Object[]{invitationId};
            throw new InvitationExceptionNotFound("invitation.error.not_found", objs);
        }
        return startTask;
    }

    @Override
    public List<Invitation> listPendingInvitationsForInvitee(String invitee) {
        InvitationSearchCriteriaImpl crit = new InvitationSearchCriteriaImpl();
        crit.setInvitationType(InvitationSearchCriteria.InvitationType.ALL);
        crit.setInvitee(invitee);
        return this.searchInvitation(crit);
    }

    @Override
    public List<Invitation> listPendingInvitationsForResource(Invitation.ResourceType resourceType, String resourceName) {
        InvitationSearchCriteriaImpl criteria = this.getPendingInvitationCriteriaForResource(resourceType, resourceName);
        return this.searchInvitation(criteria);
    }

    private InvitationSearchCriteriaImpl getPendingInvitationCriteriaForResource(Invitation.ResourceType resourceType, String resourceName) {
        InvitationSearchCriteriaImpl criteria = new InvitationSearchCriteriaImpl();
        criteria.setInvitationType(InvitationSearchCriteria.InvitationType.ALL);
        criteria.setResourceType(resourceType);
        criteria.setResourceName(resourceName);
        return criteria;
    }

    @Override
    public List<Invitation> searchInvitation(InvitationSearchCriteria criteria) {
        int limit = 200;
        List<String> invitationIds = this.searchInvitationsForIds(criteria, limit);
        return invitationIds.isEmpty() ? Collections.emptyList() : this.searchInvitation(criteria, invitationIds);
    }

    private List<Invitation> searchInvitation(final InvitationSearchCriteria criteria, List<String> invitationIds) {
        final Map<String, WorkflowTask> taskCache = this.getInvitationTasks(invitationIds);
        return CollectionUtils.transform(invitationIds, (Function)new Function<String, Invitation>(){

            public Invitation apply(String invitationId) {
                WorkflowTask startTask = (WorkflowTask)taskCache.get(invitationId);
                if (startTask == null) {
                    return null;
                }
                Invitation invitation = InvitationServiceImpl.this.getInvitation(startTask);
                return InvitationServiceImpl.this.invitationMatches(invitation, criteria) ? invitation : null;
            }
        });
    }

    private List<String> searchInvitationsForIds(InvitationSearchCriteria criteria, int limit) {
        String invitationId;
        ArrayList<String> invitationIds = new ArrayList<String>();
        InvitationSearchCriteria.InvitationType toSearch = criteria.getInvitationType();
        if (toSearch == InvitationSearchCriteria.InvitationType.ALL || toSearch == InvitationSearchCriteria.InvitationType.NOMINATED) {
            for (WorkflowTask task : this.searchNominatedInvitations(criteria)) {
                invitationId = task.getPath().getInstance().getId();
                invitationIds.add(invitationId);
                if (limit <= 0 || invitationIds.size() < limit) continue;
                break;
            }
        }
        if (!(limit > 0 && invitationIds.size() >= limit || toSearch != InvitationSearchCriteria.InvitationType.ALL && toSearch != InvitationSearchCriteria.InvitationType.MODERATED)) {
            for (WorkflowTask task : this.searchModeratedInvitations(criteria)) {
                invitationId = task.getPath().getInstance().getId();
                invitationIds.add(invitationId);
                if (limit <= 0 || invitationIds.size() < limit) continue;
                break;
            }
        }
        return invitationIds;
    }

    private boolean invitationMatches(Invitation invitation, InvitationSearchCriteria criteria) {
        String resourceName;
        String invitee = criteria.getInvitee();
        if (invitee != null && !invitee.equals(invitation.getInviteeUserName())) {
            return false;
        }
        String inviter = criteria.getInviter();
        if (inviter != null) {
            if (invitation instanceof NominatedInvitation) {
                NominatedInvitation modInvite = (NominatedInvitation)invitation;
                if (!inviter.equals(modInvite.getInviterUserName())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return (resourceName = criteria.getResourceName()) == null || false != resourceName.equals(invitation.getResourceName());
    }

    private List<WorkflowTask> searchModeratedInvitations(InvitationSearchCriteria criteria) {
        List<WorkflowTask> jbpmTasks;
        String resourceName;
        long start = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        WorkflowTaskQuery query = new WorkflowTaskQuery();
        query.setTaskState(WorkflowTaskState.IN_PROGRESS);
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        String invitee = criteria.getInvitee();
        if (invitee != null) {
            properties.put(WorkflowModelModeratedInvitation.WF_PROP_INVITEE_USER_NAME, invitee);
        }
        if ((resourceName = criteria.getResourceName()) != null) {
            properties.put(WorkflowModelModeratedInvitation.WF_PROP_RESOURCE_NAME, resourceName);
        }
        query.setProcessCustomProps(properties);
        query.setTaskName(WorkflowModelModeratedInvitation.WF_REVIEW_TASK);
        ArrayList<WorkflowTask> results = new ArrayList<WorkflowTask>();
        if (this.workflowAdminService.isEngineEnabled("jbpm")) {
            query.setTaskName(WorkflowModelModeratedInvitation.WF_REVIEW_TASK);
            jbpmTasks = this.workflowService.queryTasks(query, true);
            if (jbpmTasks != null) {
                results.addAll(jbpmTasks);
            }
        }
        if (this.workflowAdminService.isEngineEnabled("activiti")) {
            query.setTaskName(WorkflowModelModeratedInvitation.WF_ACTIVITI_REVIEW_TASK);
            jbpmTasks = this.workflowService.queryTasks(query, true);
            if (jbpmTasks != null) {
                results.addAll(jbpmTasks);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("  searchModeratedInvitations in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return results;
    }

    private List<WorkflowTask> searchNominatedInvitations(InvitationSearchCriteria criteria) {
        List<WorkflowTask> jbpmTasks;
        String resourceName;
        long start = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        WorkflowTaskQuery query = new WorkflowTaskQuery();
        query.setTaskState(WorkflowTaskState.IN_PROGRESS);
        String invitee = criteria.getInvitee();
        if (invitee != null) {
            query.setActorId(invitee);
        }
        HashMap<QName, Object> queryProps = new HashMap<QName, Object>();
        String inviter = criteria.getInviter();
        if (inviter != null) {
            queryProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITER_USER_NAME, inviter);
        }
        if ((resourceName = criteria.getResourceName()) != null) {
            queryProps.put(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_NAME, resourceName);
        }
        query.setProcessCustomProps(queryProps);
        ArrayList<WorkflowTask> results = new ArrayList<WorkflowTask>();
        if (this.workflowAdminService.isEngineEnabled("jbpm")) {
            query.setTaskName(WorkflowModelNominatedInvitation.WF_TASK_INVITE_PENDING);
            jbpmTasks = this.workflowService.queryTasks(query, true);
            if (jbpmTasks != null) {
                results.addAll(jbpmTasks);
            }
        }
        if (this.workflowAdminService.isEngineEnabled("activiti")) {
            query.setTaskName(WorkflowModelNominatedInvitation.WF_TASK_ACTIVIT_INVITE_PENDING);
            jbpmTasks = this.workflowService.queryTasks(query, true);
            if (jbpmTasks != null) {
                results.addAll(jbpmTasks);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("  searchNominatedInvitations in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return results;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setWorkflowAdminService(WorkflowAdminService workflowAdminService) {
        this.workflowAdminService = workflowAdminService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public MutableAuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setUserNameGenerator(UserNameGenerator usernameGenerator) {
        this.usernameGenerator = usernameGenerator;
    }

    public UserNameGenerator getUserNameGenerator() {
        return this.usernameGenerator;
    }

    public void setPasswordGenerator(PasswordGenerator passwordGenerator) {
        this.passwordGenerator = passwordGenerator;
    }

    public PasswordGenerator getPasswordGenerator() {
        return this.passwordGenerator;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    private String createInviteePerson(String inviteeFirstName, String inviteeLastName, String inviteeEmail) {
        String inviteeUserName = null;
        int i = 0;
        while (this.personService.personExists(inviteeUserName = this.usernameGenerator.generateUserName(inviteeFirstName, inviteeLastName, inviteeEmail, i)) && ++i < this.getMaxUserNameGenRetries()) {
        }
        if (this.personService.personExists(inviteeUserName)) {
            logger.debug((Object)"Failed - unable to generate username for invitee.");
            Object[] objs = new Object[]{inviteeFirstName, inviteeLastName, inviteeEmail};
            throw new InvitationException("invitation.invite.unable_generate_id", objs);
        }
        final HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_USERNAME, inviteeUserName);
        properties.put(ContentModel.PROP_FIRSTNAME, inviteeFirstName);
        properties.put(ContentModel.PROP_LASTNAME, inviteeLastName);
        properties.put(ContentModel.PROP_EMAIL, inviteeEmail);
        final String finalUserName = inviteeUserName;
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                NodeRef person = InvitationServiceImpl.this.personService.createPerson(properties);
                InvitationServiceImpl.this.permissionService.setPermission(person, finalUserName, "All", true);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        return inviteeUserName;
    }

    private String createInviteeDisabledAccount(String inviteeUserName) {
        char[] generatedPassword = this.passwordGenerator.generatePassword().toCharArray();
        this.authenticationService.createAuthentication(inviteeUserName, generatedPassword);
        this.authenticationService.setAuthenticationEnabled(inviteeUserName, false);
        return String.valueOf(generatedPassword);
    }

    private ModeratedInvitation startModeratedInvite(String inviteeComments, String inviteeUserName, Invitation.ResourceType resourceType, String resourceName, String inviteeRole) {
        SiteInfo siteInfo = this.siteService.getSite(resourceName);
        if (this.siteService.isMember(resourceName, inviteeUserName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed - invitee user is already a member of the site.");
            }
            Object[] objs = new Object[]{inviteeUserName, "", resourceName};
            throw new InvitationExceptionUserError("invitation.invite.already_member", objs);
        }
        String roleGroup = this.siteService.getSiteRoleGroup(resourceName, "SiteManager");
        String workflowDescription = this.generateWorkflowDescription(siteInfo, "invitation.moderated.workflow.description");
        HashMap<QName, Serializable> workflowProps = new HashMap<QName, Serializable>(16);
        workflowProps.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, (Serializable)((Object)workflowDescription));
        workflowProps.put(WorkflowModelModeratedInvitation.ASSOC_GROUP_ASSIGNEE, (Serializable)((Object)roleGroup));
        workflowProps.put(WorkflowModelModeratedInvitation.WF_PROP_INVITEE_COMMENTS, (Serializable)((Object)inviteeComments));
        workflowProps.put(WorkflowModelModeratedInvitation.WF_PROP_INVITEE_ROLE, (Serializable)((Object)inviteeRole));
        workflowProps.put(WorkflowModelModeratedInvitation.WF_PROP_INVITEE_USER_NAME, (Serializable)((Object)inviteeUserName));
        workflowProps.put(WorkflowModelModeratedInvitation.WF_PROP_RESOURCE_NAME, (Serializable)((Object)resourceName));
        workflowProps.put(WorkflowModelModeratedInvitation.WF_PROP_RESOURCE_TYPE, (Serializable)((Object)resourceType.toString()));
        WorkflowDefinition wfDefinition = this.getWorkflowDefinition(false);
        return (ModeratedInvitation)this.startWorkflow(wfDefinition, workflowProps);
    }

    private NominatedInvitation startNominatedInvite(String inviteeFirstName, String inviteeLastName, String inviteeEmail, String inviteeUserName, Invitation.ResourceType resourceType, String siteShortName, String inviteeSiteRole, String serverPath, String acceptUrl, String rejectUrl) {
        String inviterUserName = this.authenticationService.getCurrentUserName();
        boolean created = false;
        this.checkManagerRole(inviterUserName, resourceType, siteShortName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("startInvite() inviterUserName=" + inviterUserName + " inviteeUserName=" + inviteeUserName + " inviteeFirstName=" + inviteeFirstName + " inviteeLastName=" + inviteeLastName + " inviteeEmail=" + inviteeEmail + " siteShortName=" + siteShortName + " inviteeSiteRole=" + inviteeSiteRole));
        }
        if (inviteeUserName == null || inviteeUserName.trim().length() == 0) {
            inviteeUserName = null;
            Set<NodeRef> peopleWithInviteeEmail = this.personService.getPeopleFilteredByProperty(ContentModel.PROP_EMAIL, (Serializable)((Object)inviteeEmail), 100);
            if (peopleWithInviteeEmail.size() > 0) {
                for (NodeRef personRef : peopleWithInviteeEmail) {
                    Serializable firstNameVal = this.getNodeService().getProperty(personRef, ContentModel.PROP_FIRSTNAME);
                    Serializable lastNameVal = this.getNodeService().getProperty(personRef, ContentModel.PROP_LASTNAME);
                    String personFirstName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)firstNameVal);
                    String personLastName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)lastNameVal);
                    if (personFirstName == null || !personFirstName.equalsIgnoreCase(inviteeFirstName) || personLastName == null || !personLastName.equalsIgnoreCase(inviteeLastName)) continue;
                    Serializable userNamePropertyVal = this.getNodeService().getProperty(personRef, ContentModel.PROP_USERNAME);
                    inviteeUserName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)userNamePropertyVal);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("not explictly passed username - found matching email, resolved inviteeUserName=" + inviteeUserName));
                }
            }
            if (inviteeUserName == null) {
                if (!this.authenticationService.isAuthenticationCreationAllowed()) {
                    throw new InvitationException("invitation.invite.authentication_chain", new Object[0]);
                }
                inviteeUserName = this.createInviteePerson(inviteeFirstName, inviteeLastName, inviteeEmail);
                created = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("not explictly passed username - created new person, inviteeUserName=" + inviteeUserName));
                }
            }
        }
        if (this.siteService.isMember(siteShortName, inviteeUserName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed - invitee user is already a member of the site.");
            }
            Object[] objs = new Object[]{inviteeUserName, inviteeEmail, siteShortName};
            throw new InvitationExceptionUserError("invitation.invite.already_member", objs);
        }
        final String initeeUserNameFinal = inviteeUserName;
        String inviteePassword = created ? (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() {
                return InvitationServiceImpl.this.createInviteeDisabledAccount(initeeUserNameFinal);
            }
        }, (String)AuthenticationUtil.getSystemUserName()) : null;
        String inviteTicket = GUID.generate();
        WorkflowDefinition wfDefinition = this.getWorkflowDefinition(true);
        NodeRef inviteeNodeRef = this.personService.getPerson(inviteeUserName);
        SiteInfo siteInfo = this.siteService.getSite(siteShortName);
        String siteDescription = siteInfo.getDescription();
        if (siteDescription == null) {
            siteDescription = "";
        } else if (siteDescription.length() > 255) {
            siteDescription = siteDescription.substring(0, 255);
        }
        String workflowDescription = this.generateWorkflowDescription(siteInfo, "invitation.nominated.workflow.description");
        HashMap<QName, Serializable> workflowProps = new HashMap<QName, Serializable>(32);
        workflowProps.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, (Serializable)((Object)workflowDescription));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITER_USER_NAME, (Serializable)((Object)inviterUserName));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_USER_NAME, (Serializable)((Object)inviteeUserName));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_EMAIL, (Serializable)((Object)inviteeEmail));
        workflowProps.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)inviteeNodeRef);
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_FIRSTNAME, (Serializable)((Object)inviteeFirstName));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_LASTNAME, (Serializable)((Object)inviteeLastName));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_GEN_PASSWORD, (Serializable)((Object)inviteePassword));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_NAME, (Serializable)((Object)siteShortName));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_TITLE, (Serializable)((Object)siteInfo.getTitle()));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_DESCRIPTION, (Serializable)((Object)siteDescription));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_TYPE, (Serializable)((Object)resourceType.toString()));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_ROLE, (Serializable)((Object)inviteeSiteRole));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_SERVER_PATH, (Serializable)((Object)serverPath));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_ACCEPT_URL, (Serializable)((Object)acceptUrl));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_REJECT_URL, (Serializable)((Object)rejectUrl));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITE_TICKET, (Serializable)((Object)inviteTicket));
        return (NominatedInvitation)this.startWorkflow(wfDefinition, workflowProps);
    }

    private Invitation startWorkflow(WorkflowDefinition wfDefinition, Map<QName, Serializable> workflowProps) {
        NodeRef wfPackage = this.workflowService.createPackage(null);
        workflowProps.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)wfPackage);
        WorkflowPath wfPath = this.workflowService.startWorkflow(wfDefinition.getId(), workflowProps);
        String workflowId = wfPath.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(workflowId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting Invite workflow task by attaching empty package...");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Transitioning Invite workflow task...");
        }
        try {
            this.workflowService.endTask(startTask.getId(), null);
        }
        catch (RuntimeException err) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed - caught error during Invite workflow transition: " + err.getMessage()));
            }
            throw err;
        }
        Invitation invitation = this.getInvitation(startTask);
        return invitation;
    }

    private WorkflowDefinition getWorkflowDefinition(boolean isNominated) {
        String workflowName = isNominated ? this.getNominatedDefinitionName() : this.getModeratedDefinitionName();
        WorkflowDefinition definition = this.workflowService.getDefinitionByName(workflowName);
        if (definition == null) {
            Object[] objs = new Object[]{workflowName};
            throw new InvitationException("invitation.error.noworkflow", objs);
        }
        return definition;
    }

    private String getNominatedDefinitionName() {
        if (this.workflowAdminService.isEngineEnabled("activiti")) {
            return "activiti$activitiInvitationNominated";
        }
        if (this.workflowAdminService.isEngineEnabled("jbpm")) {
            return "jbpm$inwf:invitation-nominated";
        }
        throw new IllegalStateException("None of the Workflow engines supported by teh InvitationService are currently enabled!");
    }

    private String getModeratedDefinitionName() {
        if (this.workflowAdminService.isEngineEnabled("activiti")) {
            return "activiti$activitiInvitationModerated";
        }
        if (this.workflowAdminService.isEngineEnabled("jbpm")) {
            return "jbpm$imwf:invitation-moderated";
        }
        throw new IllegalStateException("None of the Workflow engines supported by teh InvitationService are currently enabled!");
    }

    private void checkManagerRole(String userId, Invitation.ResourceType resourceType, String siteShortName) {
        String inviterRole = this.siteService.getMembersRole(siteShortName, userId);
        if (inviterRole == null || !inviterRole.equals("SiteManager")) {
            Object[] objs = new Object[]{userId, siteShortName};
            throw new InvitationExceptionForbidden("invitation.invite.not_site_manager", objs);
        }
    }

    private void validateInvitationId(String invitationId) {
        String ID_SEPERATOR_REGEX = "\\$";
        String[] parts = invitationId.split("\\$");
        if (parts.length != 2) {
            Object[] objs = new Object[]{invitationId};
            throw new InvitationExceptionUserError("invitation.error.invalid_inviteId_format", objs);
        }
    }

    private int getMaxUserNameGenRetries() {
        return this.maxUserNameGenRetries;
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        logger.debug((Object)"beforeDeleteNode");
        final NodeRef siteRef = nodeRef;
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                QName type = InvitationServiceImpl.this.nodeService.getType(siteRef);
                if (InvitationServiceImpl.this.dictionaryService.isSubClass(type, SiteModel.TYPE_SITE)) {
                    String siteName = (String)((Object)InvitationServiceImpl.this.nodeService.getProperty(siteRef, ContentModel.PROP_NAME));
                    if (siteName != null) {
                        long start = 0L;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Invitation service delete node fired " + type + ", " + siteName));
                            start = System.currentTimeMillis();
                        }
                        InvitationSearchCriteriaImpl criteria = InvitationServiceImpl.this.getPendingInvitationCriteriaForResource(Invitation.ResourceType.WEB_SITE, siteName);
                        List invitationIds = InvitationServiceImpl.this.searchInvitationsForIds(criteria, -1);
                        if (logger.isDebugEnabled()) {
                            long end = System.currentTimeMillis();
                            logger.debug((Object)("Invitations found: " + invitationIds.size() + " in " + (end - start) / 1000L + " seconds"));
                            start = System.currentTimeMillis();
                        }
                        Action action = InvitationServiceImpl.this.actionService.createAction(CancelWorkflowActionExecuter.NAME);
                        action.setParameterValue("workflow-id-list", (Serializable)((Object)invitationIds));
                        InvitationServiceImpl.this.actionService.executeAction(action, siteRef, false, true);
                        if (logger.isDebugEnabled()) {
                            long end = System.currentTimeMillis();
                            logger.debug((Object)("Invitations cancelled: " + invitationIds.size() + " in " + (end - start) + " ms"));
                        }
                    }
                } else if (InvitationServiceImpl.this.dictionaryService.isSubClass(type, ContentModel.TYPE_PERSON)) {
                    String userName = (String)((Object)InvitationServiceImpl.this.nodeService.getProperty(siteRef, ContentModel.PROP_USERNAME));
                    InvitationServiceImpl.this.invalidateTasksByUser(userName);
                }
                return null;
            }
        }, (String)"System");
    }

    private void invalidateTasksByUser(String userName) throws AuthenticationException {
        List<Invitation> listForInvitee = this.listPendingInvitationsForInvitee(userName);
        for (Invitation inv : listForInvitee) {
            this.cancel(inv.getInviteId());
        }
    }

    protected String generateWorkflowDescription(SiteInfo siteInfo, String messageId) {
        String siteTitle = siteInfo.getTitle();
        if (siteTitle == null || siteTitle.length() == 0) {
            siteTitle = siteInfo.getShortName();
        }
        return I18NUtil.getMessage((String)messageId, (Object[])new Object[]{siteTitle});
    }

    public void setSendEmails(boolean sendEmails) {
        this.sendEmails = sendEmails;
    }

    @Override
    public boolean isSendEmails() {
        return this.sendEmails;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }
}

