/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ScriptableQNameMap;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolverProvider;
import org.alfresco.service.namespace.QName;

public class ContentAwareScriptableQNameMap<K, V>
extends ScriptableQNameMap<K, V> {
    private ServiceRegistry services;
    private ScriptNode factory;

    public ContentAwareScriptableQNameMap(ScriptNode factory, final ServiceRegistry services) {
        super(new NamespacePrefixResolverProvider(){

            public NamespacePrefixResolver getNamespacePrefixResolver() {
                return services.getNamespaceService();
            }
        });
        this.services = services;
        this.factory = factory;
    }

    public Object get(Object name) {
        Object value = super.get(name);
        if (value == null) {
            QName qname = QName.resolveToQName((NamespacePrefixResolver)this.getResolver(), (String)name.toString());
            PropertyDefinition propDef = this.services.getDictionaryService().getProperty(qname);
            if (propDef != null && DataTypeDefinition.CONTENT.equals((Object)propDef.getDataType().getName())) {
                String fileName;
                String mimetype = null;
                if (qname.equals((Object)ContentModel.PROP_CONTENT) && (fileName = (String)this.get("cm:name")) != null) {
                    mimetype = this.services.getMimetypeService().guessMimetype(fileName);
                }
                ContentData cdata = new ContentData(null, mimetype, 0L, "UTF-8");
                ScriptNode scriptNode = this.factory;
                scriptNode.getClass();
                value = new ScriptNode.ScriptContentData(scriptNode, cdata, qname);
                this.put(name, value);
            }
        }
        return value;
    }
}

