/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.util.List;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodePropertyHelper;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.FileFilterMode;

public class GetChildrenCannedQuery
extends org.alfresco.repo.node.getchildren.GetChildrenCannedQuery {
    private HiddenAspect hiddenAspect;

    public GetChildrenCannedQuery(NodeDAO nodeDAO, QNameDAO qnameDAO, CannedQueryDAO cannedQueryDAO, NodePropertyHelper nodePropertyHelper, TenantService tenantService, MethodSecurityBean<NodeRef> methodSecurity, CannedQueryParameters params, HiddenAspect hiddenAspect) {
        super(nodeDAO, qnameDAO, cannedQueryDAO, nodePropertyHelper, tenantService, methodSecurity, params);
        this.hiddenAspect = hiddenAspect;
    }

    @Override
    protected GetChildrenCannedQuery.UnsortedChildQueryCallback getUnsortedChildQueryCallback(List<NodeRef> rawResult, int requestedCount) {
        FileFolderUnsortedChildQueryCallback callback = new FileFolderUnsortedChildQueryCallback(rawResult, requestedCount);
        return callback;
    }

    @Override
    protected GetChildrenCannedQuery.FilterSortChildQueryCallback getFilterSortChildQuery(List<GetChildrenCannedQuery.FilterSortNode> children, List<FilterProp> filterProps) {
        FileFolderFilterSortChildQueryCallback callback = new FileFolderFilterSortChildQueryCallback(children, filterProps);
        return callback;
    }

    private class FileFolderUnsortedChildQueryCallback
    extends GetChildrenCannedQuery.DefaultUnsortedChildQueryCallback {
        public FileFolderUnsortedChildQueryCallback(List<NodeRef> rawResult, int requestedCount) {
            super(GetChildrenCannedQuery.this, rawResult, requestedCount);
        }

        @Override
        protected boolean include(NodeRef nodeRef) {
            boolean ret = super.include(nodeRef);
            try {
                FileFilterMode.Client client = FileFilterMode.getClient();
                return ret && GetChildrenCannedQuery.this.hiddenAspect.getVisibility(client, nodeRef) != HiddenAspect.Visibility.NotVisible;
            }
            catch (AccessDeniedException e) {
                return ret;
            }
        }
    }

    private class FileFolderFilterSortChildQueryCallback
    extends GetChildrenCannedQuery.DefaultFilterSortChildQueryCallback {
        public FileFolderFilterSortChildQueryCallback(List<GetChildrenCannedQuery.FilterSortNode> children, List<FilterProp> filterProps) {
            super(GetChildrenCannedQuery.this, children, filterProps);
        }

        @Override
        protected boolean include(GetChildrenCannedQuery.FilterSortNode node) {
            boolean ret = super.include(node);
            try {
                FileFilterMode.Client client = FileFilterMode.getClient();
                return ret && GetChildrenCannedQuery.this.hiddenAspect.getVisibility(client, node.getNodeRef()) != HiddenAspect.Visibility.NotVisible;
            }
            catch (AccessDeniedException e) {
                return ret;
            }
        }
    }
}

