/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;

public class NodeRefPropertyMethodInterceptorTest
extends BaseSpringTest {
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/NodeRefTestModel";
    private QName testType = QName.createQName((String)"http://www.alfresco.org/test/NodeRefTestModel", (String)"testType");
    private QName categoryAspect = QName.createQName((String)"http://www.alfresco.org/test/NodeRefTestModel", (String)"singleCategory");
    private QName categoriesAspect = QName.createQName((String)"http://www.alfresco.org/test/NodeRefTestModel", (String)"multipleCategories");
    private QName noderefAspect = QName.createQName((String)"http://www.alfresco.org/test/NodeRefTestModel", (String)"singleNodeRef");
    private QName noderefsAspect = QName.createQName((String)"http://www.alfresco.org/test/NodeRefTestModel", (String)"multipleNodeRefs");
    private QName aspectCategoryProp = QName.createQName((String)"http://www.alfresco.org/test/NodeRefTestModel", (String)"category");
    private QName aspectCategoriesProp = QName.createQName((String)"http://www.alfresco.org/test/NodeRefTestModel", (String)"categories");
    private QName aspectNoderefProp = QName.createQName((String)"http://www.alfresco.org/test/NodeRefTestModel", (String)"noderef");
    private QName aspectNoderefsProp = QName.createQName((String)"http://www.alfresco.org/test/NodeRefTestModel", (String)"noderefs");
    private QName typeCategoryProp = QName.createQName((String)"http://www.alfresco.org/test/NodeRefTestModel", (String)"category1");
    private QName typeCategoriesProp = QName.createQName((String)"http://www.alfresco.org/test/NodeRefTestModel", (String)"categories1");
    private QName typeNoderefProp = QName.createQName((String)"http://www.alfresco.org/test/NodeRefTestModel", (String)"noderef1");
    private QName typeNoderefsProp = QName.createQName((String)"http://www.alfresco.org/test/NodeRefTestModel", (String)"noderefs1");
    private NodeService mlAwareNodeService;
    private NodeService nodeService;
    private NodeRef rootNodeRef;
    private AuthenticationComponent authenticationComponent;
    private DictionaryDAO dictionaryDAO;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.mlAwareNodeService = (NodeService)this.applicationContext.getBean("mlAwareNodeService");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.dictionaryDAO = (DictionaryDAO)this.applicationContext.getBean("dictionaryDAO");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("org/alfresco/repo/node/NodeRefTestModel.xml");
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        this.dictionaryDAO.putModel(model);
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
    }

    protected void onTearDownInTransaction() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.onTearDownInTransaction();
    }

    public void testOnRead() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef n1 = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.mlAwareNodeService.addAspect(n1, this.categoryAspect, null);
        this.mlAwareNodeService.addAspect(n1, this.categoriesAspect, null);
        this.mlAwareNodeService.addAspect(n1, this.noderefAspect, null);
        this.mlAwareNodeService.addAspect(n1, this.noderefsAspect, null);
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        this.mlAwareNodeService.setProperty(n1, this.aspectCategoryProp, null);
        this.mlAwareNodeService.setProperty(n1, this.aspectCategoriesProp, null);
        this.mlAwareNodeService.setProperty(n1, this.aspectNoderefProp, null);
        this.mlAwareNodeService.setProperty(n1, this.aspectNoderefsProp, null);
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        this.mlAwareNodeService.setProperty(n1, this.aspectCategoryProp, (Serializable)invalidNodeRef);
        this.mlAwareNodeService.setProperty(n1, this.aspectCategoriesProp, (Serializable)invalidNodeRef);
        this.mlAwareNodeService.setProperty(n1, this.aspectNoderefProp, (Serializable)invalidNodeRef);
        this.mlAwareNodeService.setProperty(n1, this.aspectNoderefsProp, (Serializable)invalidNodeRef);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        this.mlAwareNodeService.setProperty(n1, this.aspectCategoryProp, (Serializable)this.rootNodeRef);
        this.mlAwareNodeService.setProperty(n1, this.aspectCategoriesProp, (Serializable)this.rootNodeRef);
        this.mlAwareNodeService.setProperty(n1, this.aspectNoderefProp, (Serializable)this.rootNodeRef);
        this.mlAwareNodeService.setProperty(n1, this.aspectNoderefsProp, (Serializable)this.rootNodeRef);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertTrue((boolean)(((Collection)((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp))).iterator().next() instanceof NodeRef));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertTrue((boolean)(((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).iterator().next() instanceof NodeRef));
        this.mlAwareNodeService.setProperty(n1, this.aspectCategoryProp, (Serializable)((Object)cat.toString()));
        this.mlAwareNodeService.setProperty(n1, this.aspectCategoriesProp, (Serializable)cat);
        this.mlAwareNodeService.setProperty(n1, this.aspectNoderefProp, (Serializable)cat);
        this.mlAwareNodeService.setProperty(n1, this.aspectNoderefsProp, (Serializable)cat);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertTrue((boolean)(this.nodeService.getProperty(n1, this.aspectCategoryProp) instanceof NodeRef));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertTrue((boolean)(this.nodeService.getProperty(n1, this.aspectCategoryProp) instanceof NodeRef));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertTrue((boolean)(((Collection)((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp))).iterator().next() instanceof NodeRef));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertTrue((boolean)(((Collection)((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp))).iterator().next() instanceof NodeRef));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertTrue((boolean)(((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).iterator().next() instanceof NodeRef));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertTrue((boolean)(((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).iterator().next() instanceof NodeRef));
        this.mlAwareNodeService.setProperty(n1, this.aspectCategoriesProp, new ArrayList());
        this.mlAwareNodeService.setProperty(n1, this.aspectNoderefsProp, new ArrayList());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        ArrayList<NodeRef> cats = new ArrayList<NodeRef>();
        cats.add(invalidNodeRef);
        this.mlAwareNodeService.setProperty(n1, this.aspectCategoriesProp, cats);
        this.mlAwareNodeService.setProperty(n1, this.aspectNoderefsProp, cats);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        cats = new ArrayList();
        cats.add(this.rootNodeRef);
        this.mlAwareNodeService.setProperty(n1, this.aspectCategoriesProp, cats);
        this.mlAwareNodeService.setProperty(n1, this.aspectNoderefsProp, cats);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertTrue((boolean)(((Collection)((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp))).iterator().next() instanceof NodeRef));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertTrue((boolean)(((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).iterator().next() instanceof NodeRef));
        cats = new ArrayList();
        cats.add(cat);
        this.mlAwareNodeService.setProperty(n1, this.aspectCategoriesProp, cats);
        this.mlAwareNodeService.setProperty(n1, this.aspectNoderefsProp, cats);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertTrue((boolean)(((Collection)((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp))).iterator().next() instanceof NodeRef));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertTrue((boolean)(((Collection)((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp))).iterator().next() instanceof NodeRef));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertTrue((boolean)(((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).iterator().next() instanceof NodeRef));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertTrue((boolean)(((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).iterator().next() instanceof NodeRef));
        cats = new ArrayList();
        cats.add(this.rootNodeRef);
        cats.add(invalidNodeRef);
        cats.add(cat);
        this.mlAwareNodeService.setProperty(n1, this.aspectCategoriesProp, cats);
        this.mlAwareNodeService.setProperty(n1, this.aspectNoderefsProp, cats);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)3, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)3, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)3, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)3, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
    }

    public void testAddAspectNull() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef n1 = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.nodeService.addAspect(n1, this.categoryAspect, null);
        this.nodeService.addAspect(n1, this.categoriesAspect, null);
        this.nodeService.addAspect(n1, this.noderefAspect, null);
        this.nodeService.addAspect(n1, this.noderefsAspect, null);
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
    }

    public void testAddAspectNullValues() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef n1 = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap<QName, Object> properties1 = new HashMap<QName, Object>();
        HashMap<QName, Object> properties2 = new HashMap<QName, Object>();
        HashMap<QName, Object> properties3 = new HashMap<QName, Object>();
        HashMap<QName, Object> properties4 = new HashMap<QName, Object>();
        properties1.put(this.aspectCategoryProp, null);
        properties2.put(this.aspectCategoriesProp, null);
        properties3.put(this.aspectNoderefProp, null);
        properties4.put(this.aspectNoderefsProp, null);
        this.nodeService.addAspect(n1, this.categoryAspect, properties1);
        this.nodeService.addAspect(n1, this.categoriesAspect, properties2);
        this.nodeService.addAspect(n1, this.noderefAspect, properties3);
        this.nodeService.addAspect(n1, this.noderefsAspect, properties4);
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
    }

    public void testAddAspectInvalidValues() {
        NodeRef invalidNodeRef;
        NodeRef testInvalid = invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef n1 = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap<QName, NodeRef> properties1 = new HashMap<QName, NodeRef>();
        HashMap<QName, NodeRef> properties2 = new HashMap<QName, NodeRef>();
        HashMap<QName, NodeRef> properties3 = new HashMap<QName, NodeRef>();
        HashMap<QName, NodeRef> properties4 = new HashMap<QName, NodeRef>();
        properties1.put(this.aspectCategoryProp, invalidNodeRef);
        properties2.put(this.aspectCategoriesProp, invalidNodeRef);
        properties3.put(this.aspectNoderefProp, invalidNodeRef);
        properties4.put(this.aspectNoderefsProp, invalidNodeRef);
        NodeRefPropertyMethodInterceptorTest.assertEquals((Object)testInvalid, (Object)invalidNodeRef);
        this.nodeService.addAspect(n1, this.categoryAspect, properties1);
        this.nodeService.addAspect(n1, this.categoriesAspect, properties2);
        this.nodeService.addAspect(n1, this.noderefAspect, properties3);
        this.nodeService.addAspect(n1, this.noderefsAspect, properties4);
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
    }

    public void testAddAspectValidNode() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef n1 = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap<QName, NodeRef> properties1 = new HashMap<QName, NodeRef>();
        HashMap<QName, NodeRef> properties2 = new HashMap<QName, NodeRef>();
        HashMap<QName, NodeRef> properties3 = new HashMap<QName, NodeRef>();
        HashMap<QName, NodeRef> properties4 = new HashMap<QName, NodeRef>();
        properties1.put(this.aspectCategoryProp, this.rootNodeRef);
        properties2.put(this.aspectCategoriesProp, this.rootNodeRef);
        properties3.put(this.aspectNoderefProp, this.rootNodeRef);
        properties4.put(this.aspectNoderefsProp, this.rootNodeRef);
        this.nodeService.addAspect(n1, this.categoryAspect, properties1);
        this.nodeService.addAspect(n1, this.categoriesAspect, properties2);
        this.nodeService.addAspect(n1, this.noderefAspect, properties3);
        this.nodeService.addAspect(n1, this.noderefsAspect, properties4);
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
    }

    public void testAddAspectValidCategory() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef n1 = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap<QName, NodeRef> properties1 = new HashMap<QName, NodeRef>();
        HashMap<QName, NodeRef> properties2 = new HashMap<QName, NodeRef>();
        HashMap<QName, NodeRef> properties3 = new HashMap<QName, NodeRef>();
        HashMap<QName, NodeRef> properties4 = new HashMap<QName, NodeRef>();
        properties1.put(this.aspectCategoryProp, cat);
        properties2.put(this.aspectCategoriesProp, cat);
        properties3.put(this.aspectNoderefProp, cat);
        properties4.put(this.aspectNoderefsProp, cat);
        this.nodeService.addAspect(n1, this.categoryAspect, properties1);
        this.nodeService.addAspect(n1, this.categoriesAspect, properties2);
        this.nodeService.addAspect(n1, this.noderefAspect, properties3);
        this.nodeService.addAspect(n1, this.noderefsAspect, properties4);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
    }

    public void testAddAspectEmptyList() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef n1 = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap properties1 = new HashMap();
        HashMap properties2 = new HashMap();
        HashMap properties3 = new HashMap();
        HashMap properties4 = new HashMap();
        ArrayList vals = new ArrayList();
        properties2.put(this.aspectCategoriesProp, vals);
        properties4.put(this.aspectNoderefsProp, vals);
        this.nodeService.addAspect(n1, this.categoryAspect, properties1);
        this.nodeService.addAspect(n1, this.categoriesAspect, properties2);
        this.nodeService.addAspect(n1, this.noderefAspect, properties3);
        this.nodeService.addAspect(n1, this.noderefsAspect, properties4);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
    }

    public void testAddAspectInvalidList() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef n1 = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap properties1 = new HashMap();
        HashMap properties2 = new HashMap();
        HashMap properties3 = new HashMap();
        HashMap properties4 = new HashMap();
        ArrayList<NodeRef> vals = new ArrayList<NodeRef>();
        vals.add(invalidNodeRef);
        properties2.put(this.aspectCategoriesProp, vals);
        properties4.put(this.aspectNoderefsProp, vals);
        this.nodeService.addAspect(n1, this.categoryAspect, properties1);
        this.nodeService.addAspect(n1, this.categoriesAspect, properties2);
        this.nodeService.addAspect(n1, this.noderefAspect, properties3);
        this.nodeService.addAspect(n1, this.noderefsAspect, properties4);
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)properties4.size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
    }

    public void testAddAspectNodeRefList() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef n1 = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap properties1 = new HashMap();
        HashMap properties2 = new HashMap();
        HashMap properties3 = new HashMap();
        HashMap properties4 = new HashMap();
        ArrayList<NodeRef> vals = new ArrayList<NodeRef>();
        vals.add(this.rootNodeRef);
        properties2.put(this.aspectCategoriesProp, vals);
        properties4.put(this.aspectNoderefsProp, vals);
        this.nodeService.addAspect(n1, this.categoryAspect, properties1);
        this.nodeService.addAspect(n1, this.categoriesAspect, properties2);
        this.nodeService.addAspect(n1, this.noderefAspect, properties3);
        this.nodeService.addAspect(n1, this.noderefsAspect, properties4);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
    }

    public void testAddAspectCatList() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef n1 = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap properties1 = new HashMap();
        HashMap properties2 = new HashMap();
        HashMap properties3 = new HashMap();
        HashMap properties4 = new HashMap();
        ArrayList<NodeRef> vals = new ArrayList<NodeRef>();
        vals.add(cat);
        properties2.put(this.aspectCategoriesProp, vals);
        properties4.put(this.aspectNoderefsProp, vals);
        this.nodeService.addAspect(n1, this.categoryAspect, properties1);
        this.nodeService.addAspect(n1, this.categoriesAspect, properties2);
        this.nodeService.addAspect(n1, this.noderefAspect, properties3);
        this.nodeService.addAspect(n1, this.noderefsAspect, properties4);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
    }

    public void testAddAspectMixedList() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef n1 = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap properties1 = new HashMap();
        HashMap properties2 = new HashMap();
        HashMap properties3 = new HashMap();
        HashMap properties4 = new HashMap();
        ArrayList<NodeRef> vals = new ArrayList<NodeRef>();
        vals.add(cat);
        vals.add(this.rootNodeRef);
        vals.add(invalidNodeRef);
        properties2.put(this.aspectCategoriesProp, vals);
        properties4.put(this.aspectNoderefsProp, vals);
        this.nodeService.addAspect(n1, this.categoryAspect, properties1);
        this.nodeService.addAspect(n1, this.categoriesAspect, properties2);
        this.nodeService.addAspect(n1, this.noderefAspect, properties3);
        this.nodeService.addAspect(n1, this.noderefsAspect, properties4);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
    }

    public void testCreateNodeNull() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER, null).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
    }

    public void testCreateNodeNullValues() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        properties.put(this.aspectCategoryProp, null);
        properties.put(this.aspectCategoriesProp, null);
        properties.put(this.aspectNoderefProp, null);
        properties.put(this.aspectNoderefsProp, null);
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER, properties).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
    }

    public void testCreateNodeInvalidValues() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap<QName, NodeRef> properties = new HashMap<QName, NodeRef>();
        properties.put(this.aspectCategoryProp, invalidNodeRef);
        properties.put(this.aspectCategoriesProp, invalidNodeRef);
        properties.put(this.aspectNoderefProp, invalidNodeRef);
        properties.put(this.aspectNoderefsProp, invalidNodeRef);
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER, properties).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
    }

    public void testCreateNodeNodeRefValues() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap<QName, NodeRef> properties = new HashMap<QName, NodeRef>();
        properties.put(this.aspectCategoryProp, this.rootNodeRef);
        properties.put(this.aspectCategoriesProp, this.rootNodeRef);
        properties.put(this.aspectNoderefProp, this.rootNodeRef);
        properties.put(this.aspectNoderefsProp, this.rootNodeRef);
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER, properties).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
    }

    public void testCreateNodeCatValues() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap<QName, NodeRef> properties = new HashMap<QName, NodeRef>();
        properties.put(this.aspectCategoryProp, cat);
        properties.put(this.aspectCategoriesProp, cat);
        properties.put(this.aspectNoderefProp, cat);
        properties.put(this.aspectNoderefsProp, cat);
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER, properties).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
    }

    public void testCreateEmptyListValues() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap properties = new HashMap();
        ArrayList val = new ArrayList();
        properties.put(this.aspectCategoriesProp, val);
        properties.put(this.aspectNoderefsProp, val);
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER, properties).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
    }

    public void testCreateInvalidListValues() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap properties = new HashMap();
        ArrayList<NodeRef> val = new ArrayList<NodeRef>();
        val.add(invalidNodeRef);
        properties.put(this.aspectCategoriesProp, val);
        properties.put(this.aspectNoderefsProp, val);
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER, properties).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
    }

    public void testCreateNodeRefListValues() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap properties = new HashMap();
        ArrayList<NodeRef> val = new ArrayList<NodeRef>();
        val.add(this.rootNodeRef);
        properties.put(this.aspectCategoriesProp, val);
        properties.put(this.aspectNoderefsProp, val);
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER, properties).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
    }

    public void testCreateCatListValues() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap properties = new HashMap();
        ArrayList<NodeRef> val = new ArrayList<NodeRef>();
        val.add(cat);
        properties.put(this.aspectCategoriesProp, val);
        properties.put(this.aspectNoderefsProp, val);
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER, properties).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
    }

    public void testCreateMixedListValues() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        HashMap properties = new HashMap();
        ArrayList<NodeRef> val = new ArrayList<NodeRef>();
        val.add(invalidNodeRef);
        val.add(this.rootNodeRef);
        val.add(cat);
        properties.put(this.aspectCategoriesProp, val);
        properties.put(this.aspectNoderefsProp, val);
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER, properties).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)3, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)3, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)3, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)3, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.aspectNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.aspectNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)this.nodeService.getProperties(n1).get(this.aspectNoderefsProp)).size());
    }

    public void testSetPropertyNull() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        this.nodeService.setProperty(n1, this.typeCategoryProp, null);
        this.nodeService.setProperty(n1, this.typeCategoriesProp, null);
        this.nodeService.setProperty(n1, this.typeNoderefProp, null);
        this.nodeService.setProperty(n1, this.typeNoderefsProp, null);
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
    }

    public void testSetPropertyInvalid() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        this.nodeService.setProperty(n1, this.typeCategoryProp, (Serializable)invalidNodeRef);
        this.nodeService.setProperty(n1, this.typeCategoriesProp, (Serializable)invalidNodeRef);
        this.nodeService.setProperty(n1, this.typeNoderefProp, (Serializable)invalidNodeRef);
        this.nodeService.setProperty(n1, this.typeNoderefsProp, (Serializable)invalidNodeRef);
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
    }

    public void testSetPropertyNodeRef() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        this.nodeService.setProperty(n1, this.typeCategoryProp, (Serializable)this.rootNodeRef);
        this.nodeService.setProperty(n1, this.typeCategoriesProp, (Serializable)this.rootNodeRef);
        this.nodeService.setProperty(n1, this.typeNoderefProp, (Serializable)this.rootNodeRef);
        this.nodeService.setProperty(n1, this.typeNoderefsProp, (Serializable)this.rootNodeRef);
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
    }

    public void testSetPropertyCat() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        this.nodeService.setProperty(n1, this.typeCategoryProp, (Serializable)cat);
        this.nodeService.setProperty(n1, this.typeCategoriesProp, (Serializable)cat);
        this.nodeService.setProperty(n1, this.typeNoderefProp, (Serializable)cat);
        this.nodeService.setProperty(n1, this.typeNoderefsProp, (Serializable)cat);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
    }

    public void testSetPropertyEmptyList() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        ArrayList values = new ArrayList();
        this.nodeService.setProperty(n1, this.typeCategoriesProp, values);
        this.nodeService.setProperty(n1, this.typeNoderefsProp, values);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
    }

    public void testSetPropertyNodeRefList() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        ArrayList<NodeRef> values = new ArrayList<NodeRef>();
        values.add(this.rootNodeRef);
        this.nodeService.setProperty(n1, this.typeCategoriesProp, values);
        this.nodeService.setProperty(n1, this.typeNoderefsProp, values);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
    }

    public void testSetPropertyCatList() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        ArrayList<NodeRef> values = new ArrayList<NodeRef>();
        values.add(cat);
        values.add(cat);
        this.nodeService.setProperty(n1, this.typeCategoriesProp, values);
        this.nodeService.setProperty(n1, this.typeNoderefsProp, values);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
    }

    public void testSetPropertyMixedList() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        ArrayList<NodeRef> values = new ArrayList<NodeRef>();
        values.add(cat);
        values.add(this.rootNodeRef);
        values.add(invalidNodeRef);
        this.nodeService.setProperty(n1, this.typeCategoriesProp, values);
        this.nodeService.setProperty(n1, this.typeNoderefsProp, values);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
    }

    public void testSetPropertiesNull() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        properties.put(this.typeCategoryProp, null);
        properties.put(this.typeCategoriesProp, null);
        properties.put(this.typeNoderefProp, null);
        properties.put(this.typeNoderefsProp, null);
        this.nodeService.setProperties(n1, properties);
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
    }

    public void testSetPropertiesInvalid() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        HashMap<QName, NodeRef> properties = new HashMap<QName, NodeRef>();
        properties.put(this.typeCategoryProp, invalidNodeRef);
        properties.put(this.typeCategoriesProp, invalidNodeRef);
        properties.put(this.typeNoderefProp, invalidNodeRef);
        properties.put(this.typeNoderefsProp, invalidNodeRef);
        this.nodeService.setProperties(n1, properties);
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
    }

    public void testSetPropertiesNodeRef() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        HashMap<QName, NodeRef> properties = new HashMap<QName, NodeRef>();
        properties.put(this.typeCategoryProp, this.rootNodeRef);
        properties.put(this.typeCategoriesProp, this.rootNodeRef);
        properties.put(this.typeNoderefProp, this.rootNodeRef);
        properties.put(this.typeNoderefsProp, this.rootNodeRef);
        this.nodeService.setProperties(n1, properties);
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
    }

    public void testSetPropertiesCat() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        HashMap<QName, NodeRef> properties = new HashMap<QName, NodeRef>();
        properties.put(this.typeCategoryProp, cat);
        properties.put(this.typeCategoriesProp, cat);
        properties.put(this.typeNoderefProp, cat);
        properties.put(this.typeNoderefsProp, cat);
        this.nodeService.setProperties(n1, properties);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeCategoryProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefProp));
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
    }

    public void testSetPropertiesEmptyList() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        ArrayList values = new ArrayList();
        HashMap properties = new HashMap();
        properties.put(this.typeCategoriesProp, values);
        properties.put(this.typeNoderefsProp, values);
        this.nodeService.setProperties(n1, properties);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
    }

    public void testSetPropertiesNodeRefList() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        ArrayList<NodeRef> values = new ArrayList<NodeRef>();
        values.add(this.rootNodeRef);
        HashMap<QName, ArrayList<NodeRef>> properties = new HashMap<QName, ArrayList<NodeRef>>();
        properties.put(this.typeCategoriesProp, values);
        properties.put(this.typeNoderefsProp, values);
        this.nodeService.setProperties(n1, properties);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)0, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
    }

    public void testSetPropertiesCatList() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        ArrayList<NodeRef> values = new ArrayList<NodeRef>();
        values.add(cat);
        HashMap<QName, ArrayList<NodeRef>> properties = new HashMap<QName, ArrayList<NodeRef>>();
        properties.put(this.typeCategoriesProp, values);
        properties.put(this.typeNoderefsProp, values);
        this.nodeService.setProperties(n1, properties);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
    }

    public void testSetPropertiesMixedList() {
        NodeRef invalidNodeRef = new NodeRef(this.rootNodeRef.getStoreRef(), "InvalidNode");
        NodeRef cat = this.mlAwareNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}cat"), ContentModel.TYPE_CATEGORY).getChildRef();
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testType).getChildRef();
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        ArrayList<NodeRef> values = new ArrayList<NodeRef>();
        values.add(cat);
        values.add(this.rootNodeRef);
        values.add(invalidNodeRef);
        HashMap<QName, ArrayList<NodeRef>> properties = new HashMap<QName, ArrayList<NodeRef>>();
        properties.put(this.typeCategoriesProp, values);
        properties.put(this.typeNoderefsProp, values);
        this.nodeService.setProperties(n1, properties);
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)((Object)this.mlAwareNodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)this.mlAwareNodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeCategoriesProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)((Object)this.nodeService.getProperty(n1, this.typeNoderefsProp))).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeCategoriesProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)1, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeCategoriesProp)).size());
        NodeRefPropertyMethodInterceptorTest.assertNotNull(this.nodeService.getProperties(n1).get(this.typeNoderefsProp));
        NodeRefPropertyMethodInterceptorTest.assertEquals((int)2, (int)((Collection)this.nodeService.getProperties(n1).get(this.typeNoderefsProp)).size());
    }
}

