/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.springframework.dao.ConcurrencyFailureException;

public class NodeHierarchyWalker {
    private final NodeDAO nodeDAO;
    private final Map<Long, VisitedNode> nodesVisitedById = new HashMap<Long, VisitedNode>(59);
    private final Map<NodeRef, VisitedNode> nodesVisitedByNodeRef = new HashMap<NodeRef, VisitedNode>(59);
    private final List<VisitedNode> nodesLeafToParent = new ArrayList<VisitedNode>(67);
    private final List<VisitedNode> nodesParentToLeaf = new ArrayList<VisitedNode>(67);

    public NodeHierarchyWalker(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public VisitedNode getNode(Long id) {
        return this.nodesVisitedById.get(id);
    }

    public VisitedNode getNode(NodeRef nodeRef) {
        return this.nodesVisitedByNodeRef.get(nodeRef);
    }

    public List<VisitedNode> getNodes(boolean leafFirst) {
        if (leafFirst) {
            return this.nodesLeafToParent;
        }
        return this.nodesParentToLeaf;
    }

    public void walkHierarchy(Pair<Long, NodeRef> nodePair, Pair<Long, ChildAssociationRef> parentAssocPair) {
        Long nodeId = (Long)nodePair.getFirst();
        NodeRef nodeRef = (NodeRef)nodePair.getSecond();
        QName nodeType = this.nodeDAO.getNodeType(nodeId);
        VisitedNode visitedNode = new VisitedNode(nodeId, nodeRef, nodeType, parentAssocPair);
        this.nodesVisitedById.put(nodeId, visitedNode);
        this.nodesVisitedByNodeRef.put(nodeRef, visitedNode);
        this.walkNode(nodeId);
    }

    private void walkNode(Long nodeId) {
        VisitedNode nodeVisited = this.nodesVisitedById.get(nodeId);
        if (nodeVisited == null) {
            throw new IllegalStateException("Parent node has not been visited: " + nodeId);
        }
        this.nodesParentToLeaf.add(nodeVisited);
        final ArrayList nodesVisitedWorking = new ArrayList(59);
        NodeDAO.ChildAssocRefQueryCallback walkChildAssocs = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public final boolean preLoadNodes() {
                return false;
            }

            @Override
            public final boolean orderResults() {
                return false;
            }

            @Override
            public final boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                if (((ChildAssociationRef)childAssocPair.getSecond()).isPrimary()) {
                    Long childNodeId = (Long)childNodePair.getFirst();
                    NodeRef childNodeRef = (NodeRef)childNodePair.getSecond();
                    QName childNodeType = NodeHierarchyWalker.this.nodeDAO.getNodeType(childNodeId);
                    nodesVisitedWorking.add(childNodeId);
                    VisitedNode visitedNode = new VisitedNode(childNodeId, childNodeRef, childNodeType, childAssocPair);
                    NodeHierarchyWalker.this.nodesVisitedById.put(childNodeId, visitedNode);
                    NodeHierarchyWalker.this.nodesVisitedByNodeRef.put(childNodeRef, visitedNode);
                } else {
                    Long parentNodeId = (Long)parentNodePair.getFirst();
                    VisitedNode nodeVisitedWorking = (VisitedNode)NodeHierarchyWalker.this.nodesVisitedById.get(parentNodeId);
                    if (nodeVisitedWorking == null) {
                        throw new IllegalStateException("Came to secondary association without having found primary parent before: \n   parent: " + parentNodePair + "\n" + "   child:  " + childNodePair);
                    }
                    nodeVisitedWorking.secondaryChildAssocs.add(childAssocPair);
                }
                return true;
            }

            @Override
            public final void done() {
            }
        };
        this.nodeDAO.getChildAssocs(nodeId, null, null, null, null, null, walkChildAssocs);
        for (Long visitedNodeId : nodesVisitedWorking) {
            this.walkNode(visitedNodeId);
        }
        this.nodesLeafToParent.add(nodeVisited);
        NodeDAO.ChildAssocRefQueryCallback getParentAssocs = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public final boolean preLoadNodes() {
                return false;
            }

            @Override
            public boolean orderResults() {
                return false;
            }

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                VisitedNode visitedNode = (VisitedNode)NodeHierarchyWalker.this.nodesVisitedById.get(childNodePair.getFirst());
                if (visitedNode == null) {
                    throw new IllegalStateException("Querying upwards found nodes not visited: " + childNodePair);
                }
                if (((ChildAssociationRef)childAssocPair.getSecond()).isPrimary()) {
                    if (!visitedNode.primaryParentAssocPair.equals(childAssocPair)) {
                        throw new ConcurrencyFailureException("Node parent changed while hierarchy was being examined: " + childNodePair);
                    }
                } else {
                    visitedNode.secondaryParentAssocs.add(childAssocPair);
                }
                return true;
            }

            @Override
            public void done() {
            }
        };
        this.nodeDAO.getParentAssocs(nodeId, null, null, null, getParentAssocs);
        VisitedNode visitedNode = this.nodesVisitedById.get(nodeId);
        if (visitedNode == null) {
            throw new IllegalStateException("Querying upwards found nodes not visited: " + nodeId);
        }
        Collection<Pair<Long, AssociationRef>> targetAssocs = this.nodeDAO.getTargetNodeAssocs(nodeId, null);
        visitedNode.targetAssocs.addAll(targetAssocs);
        Collection<Pair<Long, AssociationRef>> sourceAssocs = this.nodeDAO.getSourceNodeAssocs(nodeId, null);
        visitedNode.sourceAssocs.addAll(sourceAssocs);
    }

    public class VisitedNode {
        public final Long id;
        public final NodeRef nodeRef;
        public final QName nodeType;
        public final Pair<Long, ChildAssociationRef> primaryParentAssocPair;
        public final List<Pair<Long, ChildAssociationRef>> secondaryParentAssocs;
        public final List<Pair<Long, ChildAssociationRef>> secondaryChildAssocs;
        public final List<Pair<Long, AssociationRef>> targetAssocs;
        public final List<Pair<Long, AssociationRef>> sourceAssocs;

        private VisitedNode(Long id, NodeRef nodeRef, QName type, Pair<Long, ChildAssociationRef> primaryParentAssocPair) {
            this.id = id;
            this.nodeRef = nodeRef;
            this.nodeType = type;
            this.primaryParentAssocPair = primaryParentAssocPair;
            this.secondaryParentAssocs = new ArrayList<Pair<Long, ChildAssociationRef>>(17);
            this.secondaryChildAssocs = new ArrayList<Pair<Long, ChildAssociationRef>>(17);
            this.targetAssocs = new ArrayList<Pair<Long, AssociationRef>>();
            this.sourceAssocs = new ArrayList<Pair<Long, AssociationRef>>();
        }
    }
}

