/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.util.LinkedHashMap;
import java.util.List;
import org.alfresco.repo.node.index.AbstractReindexComponent;
import org.alfresco.repo.node.index.FullIndexRecoveryComponent;
import org.alfresco.repo.search.AVMSnapShotTriggeredIndexingMethodInterceptor;
import org.alfresco.repo.search.IndexMode;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AVMFullIndexRecoveryComponent
extends AbstractReindexComponent {
    private static Log logger = LogFactory.getLog(AVMFullIndexRecoveryComponent.class);
    private FullIndexRecoveryComponent.RecoveryMode recoveryMode;
    private boolean lockServer;
    private AVMService avmService;
    private AVMSnapShotTriggeredIndexingMethodInterceptor avmSnapShotTriggeredIndexingMethodInterceptor;

    public void setRecoveryMode(String recoveryMode) {
        this.recoveryMode = FullIndexRecoveryComponent.RecoveryMode.valueOf(recoveryMode);
    }

    public void setLockServer(boolean lockServer) {
        this.lockServer = lockServer;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setAvmSnapShotTriggeredIndexingMethodInterceptor(AVMSnapShotTriggeredIndexingMethodInterceptor avmSnapShotTriggeredIndexingMethodInterceptor) {
        this.avmSnapShotTriggeredIndexingMethodInterceptor = avmSnapShotTriggeredIndexingMethodInterceptor;
    }

    @Override
    protected void reindexImpl() {
        this.processStores();
    }

    private void processStores() {
        List<AVMStoreDescriptor> stores = this.avmService.getStores();
        LinkedHashMap<String, FullIndexRecoveryComponent.RecoveryMode> actions = new LinkedHashMap<String, FullIndexRecoveryComponent.RecoveryMode>();
        if (stores.size() == 0) {
            return;
        }
        switch (this.recoveryMode) {
            case AUTO: 
            case VALIDATE: {
                int count = 0;
                int tracker = -1;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Checking indexes for AVM Stores: " + (Object)((Object)this.recoveryMode)));
                }
                for (AVMStoreDescriptor store : stores) {
                    if (this.isShuttingDown()) {
                        return;
                    }
                    actions.put(store.getName(), this.checkStore(store.getName()));
                    if ((long)(++count) * 10L / (long)stores.size() <= (long)tracker) continue;
                    tracker = (int)((long)count * 10L / (long)stores.size());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("  Store check   " + tracker * 10 + "% complete"));
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)"Finished checking indexes for AVM Stores");
                break;
            }
            case FULL: 
            case NONE: {
                for (AVMStoreDescriptor store : stores) {
                    if (this.isShuttingDown()) {
                        return;
                    }
                    actions.put(store.getName(), this.checkStore(store.getName()));
                }
                break;
            }
        }
        int full = 0;
        int auto = 0;
        int invalid = 0;
        for (String store : actions.keySet()) {
            FullIndexRecoveryComponent.RecoveryMode mode = (FullIndexRecoveryComponent.RecoveryMode)((Object)actions.get(store));
            switch (mode) {
                case AUTO: {
                    ++auto;
                    break;
                }
                case FULL: {
                    ++full;
                    break;
                }
                case VALIDATE: {
                    ++invalid;
                    break;
                }
            }
        }
        if (this.recoveryMode != FullIndexRecoveryComponent.RecoveryMode.NONE && logger.isDebugEnabled()) {
            logger.debug((Object)("Invalid indexes: " + invalid));
            logger.debug((Object)("Indexes for full rebuild: " + full));
            logger.debug((Object)("Indexes for auto update: " + auto));
        }
        int count = 0;
        int tracker = -1;
        int total = full + auto;
        if (total > 0) {
            logger.info((Object)("Rebuilding indexes for " + total + " AVM Stores"));
            for (String store : actions.keySet()) {
                FullIndexRecoveryComponent.RecoveryMode mode = (FullIndexRecoveryComponent.RecoveryMode)((Object)actions.get(store));
                if (this.isShuttingDown()) {
                    return;
                }
                if (mode == FullIndexRecoveryComponent.RecoveryMode.FULL || mode == FullIndexRecoveryComponent.RecoveryMode.AUTO) {
                    this.processStore(store, mode);
                    ++count;
                }
                if ((long)count * 10L / (long)total <= (long)tracker) continue;
                tracker = (int)((long)count * 10L / (long)total);
                logger.info((Object)("  Reindex   " + tracker * 10 + "% complete"));
            }
            logger.info((Object)"Finished rebuilding indexes for AVM Stores");
        }
    }

    private FullIndexRecoveryComponent.RecoveryMode checkStore(String store) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking AVM store for index recovery: " + (Object)((Object)this.recoveryMode) + " on store " + store));
        }
        if (this.recoveryMode == FullIndexRecoveryComponent.RecoveryMode.NONE) {
            return FullIndexRecoveryComponent.RecoveryMode.NONE;
        }
        if (this.avmSnapShotTriggeredIndexingMethodInterceptor.getIndexMode(store) == IndexMode.UNINDEXED) {
            return FullIndexRecoveryComponent.RecoveryMode.NONE;
        }
        if (this.recoveryMode == FullIndexRecoveryComponent.RecoveryMode.FULL) {
            return FullIndexRecoveryComponent.RecoveryMode.FULL;
        }
        if (!this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated(store)) {
            logger.warn((Object)("    Index for avm store " + store + " is out of date"));
            return this.recoveryMode;
        }
        int lastActualSnapshotId = this.avmService.getLatestSnapshotID(store);
        if (lastActualSnapshotId <= 0) {
            return FullIndexRecoveryComponent.RecoveryMode.NONE;
        }
        int lastIndexedSnapshotId = this.avmSnapShotTriggeredIndexingMethodInterceptor.getLastIndexedSnapshot(store);
        if (lastActualSnapshotId != lastIndexedSnapshotId) {
            logger.warn((Object)("    Index for avm store " + store + " is out of date"));
            return this.recoveryMode;
        }
        return FullIndexRecoveryComponent.RecoveryMode.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStore(String store, FullIndexRecoveryComponent.RecoveryMode mode) {
        QName vetoName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"AVMFullIndexRecoveryComponent");
        try {
            if (this.lockServer) {
                this.transactionService.setAllowWrite(false, vetoName);
            }
            this.recoverStore(store, mode);
        }
        finally {
            this.transactionService.setAllowWrite(true, vetoName);
        }
    }

    private void recoverStore(final String store, final FullIndexRecoveryComponent.RecoveryMode mode) {
        IndexMode storeIndexMode = this.avmSnapShotTriggeredIndexingMethodInterceptor.getIndexMode(store);
        if (storeIndexMode != IndexMode.UNINDEXED) {
            if (mode == FullIndexRecoveryComponent.RecoveryMode.AUTO) {
                logger.info((Object)("    Auto recovering index for " + store));
            } else if (mode == FullIndexRecoveryComponent.RecoveryMode.FULL) {
                logger.info((Object)("    Rebuilding index for " + store));
                RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    @Override
                    public Void execute() throws Exception {
                        AVMFullIndexRecoveryComponent.this.avmSnapShotTriggeredIndexingMethodInterceptor.deleteIndex(store);
                        return null;
                    }
                };
                this.transactionService.getRetryingTransactionHelper().doInTransaction(deleteWork, true, true);
            }
            final int latest = this.avmService.getLatestSnapshotID(store);
            if (latest <= 0) {
                if (!this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated(store)) {
                    this.avmSnapShotTriggeredIndexingMethodInterceptor.createIndex(store);
                }
                return;
            }
            final int latestIndexed = this.avmSnapShotTriggeredIndexingMethodInterceptor.getLastIndexedSnapshot(store);
            RetryingTransactionHelper.RetryingTransactionCallback<Object> reindexWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Exception {
                    if (mode == FullIndexRecoveryComponent.RecoveryMode.AUTO) {
                        logger.info((Object)("        Rebuilding index for snapshots " + latestIndexed + " to " + latest));
                        AVMFullIndexRecoveryComponent.this.avmSnapShotTriggeredIndexingMethodInterceptor.indexSnapshot(store, latestIndexed, latest);
                    } else {
                        logger.info((Object)("        Rebuilding index for snapshots 0 to " + latest));
                        AVMFullIndexRecoveryComponent.this.avmSnapShotTriggeredIndexingMethodInterceptor.indexSnapshot(store, 0, latest);
                    }
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction(reindexWork, true, true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("    Index updated for " + store + "(" + storeIndexMode.toString() + ")"));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("    Index skipped for " + store + "(" + storeIndexMode.toString() + ")"));
        }
    }
}

