/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.util.List;
import org.alfresco.repo.node.index.AbstractReindexComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MissingContentReindexComponent
extends AbstractReindexComponent {
    private static Log logger = LogFactory.getLog(MissingContentReindexComponent.class);
    private boolean ftsIndexerCalled = false;

    @Override
    public void reindexImpl() {
        List storeRefs = this.nodeService.getStores();
        int count = 0;
        for (StoreRef storeRef : storeRefs) {
            if (!this.ftsIndexerCalled) {
                this.ftsIndexer.requiresIndex(storeRef);
            }
            count += this.reindexMissingContent(storeRef);
            if (!this.isShuttingDown()) continue;
            break;
        }
        this.ftsIndexerCalled = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Missing content indexing touched " + count + " content nodes"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reindexMissingContent(StoreRef storeRef) {
        SearchParameters sp = new SearchParameters();
        sp.addStore(storeRef);
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:nicm TEXT: nitf TEXT: nint");
        sp.addSort(SearchParameters.SORT_IN_DOCUMENT_ORDER_DESCENDING);
        ResultSet results = null;
        try {
            results = this.searcher.query(sp);
            int count = 0;
            for (ResultSetRow row : results) {
                final NodeRef childNodeRef = row.getNodeRef();
                RetryingTransactionHelper.RetryingTransactionCallback<Object> reindexWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    @Override
                    public Object execute() {
                        MissingContentReindexComponent.this.indexer.updateNode(childNodeRef);
                        return null;
                    }
                };
                this.transactionService.getRetryingTransactionHelper().doInTransaction(reindexWork, true);
                ++count;
                if (!this.isShuttingDown()) continue;
                break;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reindexed missing content: \n   store: " + storeRef + "\n" + "   node count: " + count));
            }
            int n = count;
            return n;
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }
}

