/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.util.List;
import org.alfresco.repo.node.integrity.AbstractIntegrityEvent;
import org.alfresco.repo.node.integrity.IntegrityRecord;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssocTargetMultiplicityIntegrityEvent
extends AbstractIntegrityEvent {
    private static Log logger = LogFactory.getLog(AssocTargetMultiplicityIntegrityEvent.class);
    private boolean isDelete;

    public AssocTargetMultiplicityIntegrityEvent(NodeService nodeService, DictionaryService dictionaryService, NodeRef sourceNodeRef, QName assocTypeQName, boolean isDelete) {
        super(nodeService, dictionaryService, sourceNodeRef, assocTypeQName, null);
        this.isDelete = isDelete;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AssocTargetMultiplicityIntegrityEvent that = (AssocTargetMultiplicityIntegrityEvent)obj;
        return this.isDelete == that.isDelete;
    }

    @Override
    public void checkIntegrity(List<IntegrityRecord> eventResults) {
        QName assocTypeQName = this.getTypeQName();
        NodeRef sourceNodeRef = this.getNodeRef();
        QName sourceNodeTypeQName = this.getNodeType(sourceNodeRef);
        if (sourceNodeTypeQName == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring integrity check - node gone: \n   event: " + this));
            }
            return;
        }
        AssociationDefinition assocDef = this.getAssocDef(eventResults, assocTypeQName);
        if (assocDef == null) {
            if (!this.isDelete) {
                IntegrityRecord result = new IntegrityRecord("Association type does not exist: \n   Source Node: " + sourceNodeRef + "\n" + "   Source Node Type: " + sourceNodeTypeQName + "\n" + "   Association Type: " + assocTypeQName);
                eventResults.add(result);
                return;
            }
            return;
        }
        this.checkTargetMultiplicity(eventResults, assocDef, assocTypeQName, sourceNodeRef);
    }

    protected void checkTargetMultiplicity(List<IntegrityRecord> eventResults, AssociationDefinition assocDef, QName assocTypeQName, NodeRef sourceNodeRef) {
        ClassDefinition classDef;
        boolean mandatory = assocDef.isTargetMandatory();
        boolean allowMany = assocDef.isTargetMany();
        if (!mandatory && allowMany) {
            return;
        }
        if (this.isDelete && (classDef = assocDef.getSourceClass()).isAspect() && !this.nodeService.hasAspect(sourceNodeRef, classDef.getName())) {
            return;
        }
        int actualSize = 0;
        if (assocDef.isChild()) {
            List childAssocRefs = this.nodeService.getChildAssocs(sourceNodeRef, (QNamePattern)assocTypeQName, RegexQNamePattern.MATCH_ALL);
            actualSize = childAssocRefs.size();
        } else {
            List targetAssocRefs = this.nodeService.getTargetAssocs(sourceNodeRef, (QNamePattern)assocTypeQName);
            actualSize = targetAssocRefs.size();
        }
        if (mandatory && actualSize == 0 || !allowMany && actualSize > 1) {
            ClassDefinition classDef2;
            if (actualSize == 0 && (classDef2 = assocDef.getSourceClass()).isAspect() && !this.nodeService.hasAspect(sourceNodeRef, classDef2.getName())) {
                return;
            }
            String childOrTargetStr = assocDef.isChild() ? "child" : "target";
            IntegrityRecord result = new IntegrityRecord("The association " + childOrTargetStr + " multiplicity has been violated: \n" + "   Source Node: " + sourceNodeRef + "\n" + "   Association: " + assocDef + "\n" + "   Required " + childOrTargetStr + " Multiplicity: " + this.getMultiplicityString(mandatory, allowMany) + "\n" + "   Actual " + childOrTargetStr + " Multiplicity: " + actualSize);
            eventResults.add(result);
        }
    }
}

