/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.ownable.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

public class OwnableServiceImpl
implements OwnableService,
InitializingBean,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.OnRemoveAspectPolicy,
NodeServicePolicies.OnDeleteNodePolicy {
    private NodeService nodeService;
    private AuthenticationService authenticationService;
    private SimpleCache<NodeRef, String> nodeOwnerCache;
    private PolicyComponent policyComponent;
    private TenantService tenantService;
    private Set<String> storesToIgnorePolicies = Collections.emptySet();

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setStoresToIgnorePolicies(Set<String> storesToIgnorePolicies) {
        this.storesToIgnorePolicies = storesToIgnorePolicies;
    }

    public void setNodeOwnerCache(SimpleCache<NodeRef, String> ownerCache) {
        this.nodeOwnerCache = ownerCache;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"authenticationService", (Object)this.authenticationService);
        PropertyCheck.mandatory((Object)this, (String)"nodeOwnerCache", this.nodeOwnerCache);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnAddAspectPolicy.QNAME, ContentModel.ASPECT_OWNABLE, (Behaviour)new JavaBehaviour(this, "onAddAspect"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.ASPECT_OWNABLE, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnRemoveAspectPolicy.QNAME, ContentModel.ASPECT_OWNABLE, (Behaviour)new JavaBehaviour(this, "onRemoveAspect"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnDeleteNodePolicy.QNAME, ContentModel.ASPECT_OWNABLE, (Behaviour)new JavaBehaviour(this, "onDeleteNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnAddAspectPolicy.QNAME, ContentModel.ASPECT_AUDITABLE, (Behaviour)new JavaBehaviour(this, "onAddAspect"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.ASPECT_AUDITABLE, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnRemoveAspectPolicy.QNAME, ContentModel.ASPECT_AUDITABLE, (Behaviour)new JavaBehaviour(this, "onRemoveAspect"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnDeleteNodePolicy.QNAME, ContentModel.ASPECT_AUDITABLE, (Behaviour)new JavaBehaviour(this, "onDeleteNode"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ContentModel.ASPECT_OWNABLE, (Behaviour)new JavaBehaviour(this, "onCopyNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ContentModel.ASPECT_AUDITABLE, (Behaviour)new JavaBehaviour(this, "onCopyNode", Behaviour.NotificationFrequency.EVERY_EVENT));
    }

    @Override
    public String getOwner(NodeRef nodeRef) {
        String userName = (String)this.nodeOwnerCache.get((Serializable)nodeRef);
        if (userName == null) {
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_OWNABLE)) {
                userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_OWNER));
            } else if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_AUDITABLE)) {
                userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CREATOR));
            }
            this.cacheOwner(nodeRef, userName);
        }
        return userName;
    }

    @Override
    public void setOwner(NodeRef nodeRef, String userName) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_OWNABLE)) {
            HashMap<QName, String> properties = new HashMap<QName, String>(1, 1.0f);
            properties.put(ContentModel.PROP_OWNER, userName);
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_OWNABLE, properties);
        } else {
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_OWNER, (Serializable)((Object)userName));
        }
        this.cacheOwner(nodeRef, userName);
    }

    @Override
    public void takeOwnership(NodeRef nodeRef) {
        this.setOwner(nodeRef, this.authenticationService.getCurrentUserName());
    }

    @Override
    public boolean hasOwner(NodeRef nodeRef) {
        return this.getOwner(nodeRef) != null;
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.nodeOwnerCache.remove((Serializable)nodeRef);
    }

    @Override
    public void onRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.nodeOwnerCache.remove((Serializable)nodeRef);
    }

    @Override
    public void onDeleteNode(ChildAssociationRef childAssocRef, boolean isNodeArchived) {
        this.nodeOwnerCache.remove((Serializable)childAssocRef.getChildRef());
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        Serializable pa;
        Serializable pb = before.get(ContentModel.PROP_OWNER);
        if (!EqualsHelper.nullSafeEquals((Object)pb, (Object)(pa = after.get(ContentModel.PROP_OWNER)))) {
            this.nodeOwnerCache.remove((Serializable)nodeRef);
            return;
        }
        pb = before.get(ContentModel.PROP_CREATOR);
        pa = after.get(ContentModel.PROP_CREATOR);
        if (pb != null && !EqualsHelper.nullSafeEquals((Object)pb, (Object)pa)) {
            this.nodeOwnerCache.remove((Serializable)nodeRef);
            return;
        }
    }

    public CopyBehaviourCallback onCopyNode(QName classRef, CopyDetails copyDetails) {
        return AuditableOwnableAspectCopyBehaviourCallback.INSTANCE;
    }

    private void cacheOwner(NodeRef nodeRef, String userName) {
        if (!this.storesToIgnorePolicies.contains(this.tenantService.getBaseName(nodeRef.getStoreRef()).toString())) {
            this.nodeOwnerCache.put((Serializable)nodeRef, (Object)userName);
        }
    }

    private static class AuditableOwnableAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new AuditableOwnableAspectCopyBehaviourCallback();

        private AuditableOwnableAspectCopyBehaviourCallback() {
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            if (classQName.equals((Object)ContentModel.ASPECT_OWNABLE)) {
                if (properties.containsKey(ContentModel.PROP_OWNER)) {
                    properties.put(ContentModel.PROP_OWNER, (Serializable)((Object)AuthenticationUtil.getFullyAuthenticatedUser()));
                }
            } else if (classQName.equals((Object)ContentModel.ASPECT_AUDITABLE)) {
                properties.remove(ContentModel.PROP_CREATED);
                properties.remove(ContentModel.PROP_CREATOR);
                properties.remove(ContentModel.PROP_MODIFIED);
                properties.remove(ContentModel.PROP_MODIFIER);
            }
            return properties;
        }

        @Override
        public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
            return true;
        }
    }
}

