/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.policy.BehaviourBinding;
import org.alfresco.repo.policy.BehaviourChangeObserver;
import org.alfresco.repo.policy.BehaviourDefinition;

class BehaviourMap<B extends BehaviourBinding> {
    int size = 0;
    private Map<B, List<BehaviourDefinition<B>>> index = new HashMap<B, List<BehaviourDefinition<B>>>();
    private List<BehaviourChangeObserver<B>> observers = new ArrayList<BehaviourChangeObserver<B>>();

    BehaviourMap() {
    }

    public void put(BehaviourDefinition<B> behaviourDefinition) {
        B binding = behaviourDefinition.getBinding();
        List<BehaviourDefinition<B>> existing = this.index.get(binding);
        if (existing == null) {
            ArrayList<BehaviourDefinition<B>> behaviourList = new ArrayList<BehaviourDefinition<B>>();
            behaviourList.add(behaviourDefinition);
            this.index.put(binding, behaviourList);
            ++this.size;
        } else if (!existing.contains(behaviourDefinition)) {
            existing.add(behaviourDefinition);
            ++this.size;
        }
        for (BehaviourChangeObserver<B> listener : this.observers) {
            listener.addition(binding, behaviourDefinition.getBehaviour());
        }
    }

    public List<BehaviourDefinition<B>> get(B binding) {
        return this.index.get(binding);
    }

    public Collection<BehaviourDefinition<B>> getAll() {
        ArrayList<BehaviourDefinition<B>> allBehaviours = new ArrayList<BehaviourDefinition<B>>(this.size);
        for (List<BehaviourDefinition<B>> behaviours : this.index.values()) {
            allBehaviours.addAll(behaviours);
        }
        return allBehaviours;
    }

    public int size() {
        return this.size;
    }

    public void addChangeObserver(BehaviourChangeObserver<B> observer) {
        this.observers.add(observer);
    }
}

