/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.policy.AssociationPolicy;
import org.alfresco.repo.policy.AssociationPolicyDelegate;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourBinding;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.ClassBehaviourBinding;
import org.alfresco.repo.policy.ClassBehaviourIndex;
import org.alfresco.repo.policy.ClassFeatureBehaviourBinding;
import org.alfresco.repo.policy.ClassPolicy;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.Policy;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyDefinition;
import org.alfresco.repo.policy.PolicyException;
import org.alfresco.repo.policy.PolicyFactory;
import org.alfresco.repo.policy.PolicyType;
import org.alfresco.repo.policy.PropertyPolicy;
import org.alfresco.repo.policy.PropertyPolicyDelegate;
import org.alfresco.repo.policy.ServiceBehaviourBinding;
import org.alfresco.repo.policy.TransactionInvocationHandlerFactory;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

public class PolicyComponentImpl
implements PolicyComponent {
    private static final Log logger = LogFactory.getLog(PolicyComponentImpl.class);
    private static String ANNOTATION_NAMESPACE = "NAMESPACE";
    private static String ANNOTATION_ARG = "ARG_";
    private DictionaryService dictionary;
    private BehaviourFilter behaviourFilter;
    private Map<PolicyKey, PolicyDefinition> registeredPolicies;
    private Map<QName, ClassBehaviourIndex<ClassBehaviourBinding>> classBehaviours = new HashMap<QName, ClassBehaviourIndex<ClassBehaviourBinding>>();
    private Map<QName, ClassBehaviourIndex<ClassFeatureBehaviourBinding>> propertyBehaviours = new HashMap<QName, ClassBehaviourIndex<ClassFeatureBehaviourBinding>>();
    private Map<QName, ClassBehaviourIndex<ClassFeatureBehaviourBinding>> associationBehaviours = new HashMap<QName, ClassBehaviourIndex<ClassFeatureBehaviourBinding>>();
    private static final QName FEATURE_WILDCARD = QName.createQName((String)"", (String)"*");

    public PolicyComponentImpl(DictionaryService dictionary) {
        this.dictionary = dictionary;
        this.registeredPolicies = new HashMap<PolicyKey, PolicyDefinition>();
    }

    public void setBehaviourFilter(BehaviourFilter filter) {
        this.behaviourFilter = filter;
    }

    public void setTenantService(TenantService tenantService) {
        PolicyFactory.setTenantService(tenantService);
    }

    public void setTransactionInvocationHandlerFactory(TransactionInvocationHandlerFactory factory) {
        PolicyFactory.setTransactionInvocationHandlerFactory(factory);
    }

    @Override
    public <P extends ClassPolicy> ClassPolicyDelegate<P> registerClassPolicy(Class<P> policy) {
        ParameterCheck.mandatory((String)"Policy interface class", policy);
        PolicyDefinition definition = this.createPolicyDefinition(policy);
        this.registeredPolicies.put(new PolicyKey(definition.getType(), definition.getName()), definition);
        ClassPolicyDelegate<P> delegate = new ClassPolicyDelegate<P>(this.dictionary, policy, this.getClassBehaviourIndex(definition.getName()));
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Registered class policy " + definition.getName() + " (" + definition.getPolicyInterface() + ")"));
        }
        return delegate;
    }

    @Override
    public <P extends PropertyPolicy> PropertyPolicyDelegate<P> registerPropertyPolicy(Class<P> policy) {
        ParameterCheck.mandatory((String)"Policy interface class", policy);
        PolicyDefinition definition = this.createPolicyDefinition(policy);
        this.registeredPolicies.put(new PolicyKey(definition.getType(), definition.getName()), definition);
        PropertyPolicyDelegate<P> delegate = new PropertyPolicyDelegate<P>(this.dictionary, policy, this.getPropertyBehaviourIndex(definition.getName()));
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Registered property policy " + definition.getName() + " (" + definition.getPolicyInterface() + ")"));
        }
        return delegate;
    }

    @Override
    public <P extends AssociationPolicy> AssociationPolicyDelegate<P> registerAssociationPolicy(Class<P> policy) {
        ParameterCheck.mandatory((String)"Policy interface class", policy);
        PolicyDefinition definition = this.createPolicyDefinition(policy);
        this.registeredPolicies.put(new PolicyKey(definition.getType(), definition.getName()), definition);
        AssociationPolicyDelegate<P> delegate = new AssociationPolicyDelegate<P>(this.dictionary, policy, this.getAssociationBehaviourIndex(definition.getName()));
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Registered association policy " + definition.getName() + " (" + definition.getPolicyInterface() + ")"));
        }
        return delegate;
    }

    @Override
    public Collection<PolicyDefinition> getRegisteredPolicies() {
        return Collections.unmodifiableCollection(this.registeredPolicies.values());
    }

    public PolicyDefinition getRegisteredPolicy(PolicyType policyType, QName policy) {
        return this.registeredPolicies.get(new PolicyKey(policyType, policy));
    }

    @Override
    public boolean isRegisteredPolicy(PolicyType policyType, QName policy) {
        return this.registeredPolicies.containsKey(new PolicyKey(policyType, policy));
    }

    @Override
    public BehaviourDefinition<ClassBehaviourBinding> bindClassBehaviour(QName policy, QName classRef, Behaviour behaviour) {
        ParameterCheck.mandatory((String)"Policy", (Object)policy);
        ParameterCheck.mandatory((String)"Class Reference", (Object)classRef);
        ParameterCheck.mandatory((String)"Behaviour", (Object)behaviour);
        ClassDefinition classDefinition = this.dictionary.getClass(classRef);
        if (classDefinition == null) {
            throw new IllegalArgumentException("Class " + classRef + " has not been defined in the data dictionary");
        }
        ClassBehaviourBinding binding = new ClassBehaviourBinding(this.dictionary, classRef);
        BehaviourDefinition<ClassBehaviourBinding> definition = this.createBehaviourDefinition(PolicyType.Class, policy, binding, behaviour);
        this.getClassBehaviourIndex(policy).putClassBehaviour(definition);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Bound " + behaviour + " to policy " + policy + " for class " + classRef));
        }
        return definition;
    }

    @Override
    public BehaviourDefinition<ServiceBehaviourBinding> bindClassBehaviour(QName policy, Object service, Behaviour behaviour) {
        ParameterCheck.mandatory((String)"Policy", (Object)policy);
        ParameterCheck.mandatory((String)"Service", (Object)service);
        ParameterCheck.mandatory((String)"Behaviour", (Object)behaviour);
        ServiceBehaviourBinding binding = new ServiceBehaviourBinding(service);
        BehaviourDefinition<ServiceBehaviourBinding> definition = this.createBehaviourDefinition(PolicyType.Class, policy, binding, behaviour);
        this.getClassBehaviourIndex(policy).putServiceBehaviour(definition);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Bound " + behaviour + " to policy " + policy + " for service " + service));
        }
        return definition;
    }

    @Override
    public BehaviourDefinition<ClassFeatureBehaviourBinding> bindPropertyBehaviour(QName policy, QName className, QName propertyName, Behaviour behaviour) {
        ParameterCheck.mandatory((String)"Policy", (Object)policy);
        ParameterCheck.mandatory((String)"Class Reference", (Object)className);
        ParameterCheck.mandatory((String)"Property Reference", (Object)propertyName);
        ParameterCheck.mandatory((String)"Behaviour", (Object)behaviour);
        PropertyDefinition propertyDefinition = this.dictionary.getProperty(className, propertyName);
        if (propertyDefinition == null) {
            throw new IllegalArgumentException("Property " + propertyName + " of class " + className + " has not been defined in the data dictionary");
        }
        ClassFeatureBehaviourBinding binding = new ClassFeatureBehaviourBinding(this.dictionary, className, propertyName);
        BehaviourDefinition<ClassFeatureBehaviourBinding> definition = this.createBehaviourDefinition(PolicyType.Property, policy, binding, behaviour);
        this.getPropertyBehaviourIndex(policy).putClassBehaviour(definition);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Bound " + behaviour + " to policy " + policy + " for property " + propertyName + " of class " + className));
        }
        return definition;
    }

    @Override
    public BehaviourDefinition<ClassFeatureBehaviourBinding> bindPropertyBehaviour(QName policy, QName className, Behaviour behaviour) {
        ParameterCheck.mandatory((String)"Policy", (Object)policy);
        ParameterCheck.mandatory((String)"Class Reference", (Object)className);
        ParameterCheck.mandatory((String)"Behaviour", (Object)behaviour);
        ClassDefinition classDefinition = this.dictionary.getClass(className);
        if (classDefinition == null) {
            throw new IllegalArgumentException("Class " + className + " has not been defined in the data dictionary");
        }
        ClassFeatureBehaviourBinding binding = new ClassFeatureBehaviourBinding(this.dictionary, className, FEATURE_WILDCARD);
        BehaviourDefinition<ClassFeatureBehaviourBinding> definition = this.createBehaviourDefinition(PolicyType.Property, policy, binding, behaviour);
        this.getPropertyBehaviourIndex(policy).putClassBehaviour(definition);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Bound " + behaviour + " to policy " + policy + " for property " + FEATURE_WILDCARD + " of class " + className));
        }
        return definition;
    }

    @Override
    public BehaviourDefinition<ServiceBehaviourBinding> bindPropertyBehaviour(QName policy, Object service, Behaviour behaviour) {
        ParameterCheck.mandatory((String)"Policy", (Object)policy);
        ParameterCheck.mandatory((String)"Service", (Object)service);
        ParameterCheck.mandatory((String)"Behaviour", (Object)behaviour);
        ServiceBehaviourBinding binding = new ServiceBehaviourBinding(service);
        BehaviourDefinition<ServiceBehaviourBinding> definition = this.createBehaviourDefinition(PolicyType.Property, policy, binding, behaviour);
        this.getPropertyBehaviourIndex(policy).putServiceBehaviour(definition);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Bound " + behaviour + " to property policy " + policy + " for service " + service));
        }
        return definition;
    }

    @Override
    public BehaviourDefinition<ClassFeatureBehaviourBinding> bindAssociationBehaviour(QName policy, QName className, QName assocName, Behaviour behaviour) {
        ParameterCheck.mandatory((String)"Policy", (Object)policy);
        ParameterCheck.mandatory((String)"Class Reference", (Object)className);
        ParameterCheck.mandatory((String)"Association Reference", (Object)assocName);
        ParameterCheck.mandatory((String)"Behaviour", (Object)behaviour);
        AssociationDefinition assocDefinition = this.dictionary.getAssociation(assocName);
        if (assocDefinition == null) {
            throw new IllegalArgumentException("Association " + assocName + " of class " + className + " has not been defined in the data dictionary");
        }
        ClassFeatureBehaviourBinding binding = new ClassFeatureBehaviourBinding(this.dictionary, className, assocName);
        BehaviourDefinition<ClassFeatureBehaviourBinding> definition = this.createBehaviourDefinition(PolicyType.Association, policy, binding, behaviour);
        this.getAssociationBehaviourIndex(policy).putClassBehaviour(definition);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Bound " + behaviour + " to policy " + policy + " for association " + assocName + " of class " + className));
        }
        return definition;
    }

    @Override
    public BehaviourDefinition<ClassFeatureBehaviourBinding> bindAssociationBehaviour(QName policy, QName className, Behaviour behaviour) {
        ParameterCheck.mandatory((String)"Policy", (Object)policy);
        ParameterCheck.mandatory((String)"Class Reference", (Object)className);
        ParameterCheck.mandatory((String)"Behaviour", (Object)behaviour);
        ClassDefinition classDefinition = this.dictionary.getClass(className);
        if (classDefinition == null) {
            throw new IllegalArgumentException("Class " + className + " has not been defined in the data dictionary");
        }
        ClassFeatureBehaviourBinding binding = new ClassFeatureBehaviourBinding(this.dictionary, className, FEATURE_WILDCARD);
        BehaviourDefinition<ClassFeatureBehaviourBinding> definition = this.createBehaviourDefinition(PolicyType.Association, policy, binding, behaviour);
        this.getAssociationBehaviourIndex(policy).putClassBehaviour(definition);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Bound " + behaviour + " to policy " + policy + " for association " + FEATURE_WILDCARD + " of class " + className));
        }
        return definition;
    }

    @Override
    public BehaviourDefinition<ServiceBehaviourBinding> bindAssociationBehaviour(QName policy, Object service, Behaviour behaviour) {
        ParameterCheck.mandatory((String)"Policy", (Object)policy);
        ParameterCheck.mandatory((String)"Service", (Object)service);
        ParameterCheck.mandatory((String)"Behaviour", (Object)behaviour);
        ServiceBehaviourBinding binding = new ServiceBehaviourBinding(service);
        BehaviourDefinition<ServiceBehaviourBinding> definition = this.createBehaviourDefinition(PolicyType.Association, policy, binding, behaviour);
        this.getAssociationBehaviourIndex(policy).putServiceBehaviour(definition);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Bound " + behaviour + " to association policy " + policy + " for service " + service));
        }
        return definition;
    }

    private synchronized ClassBehaviourIndex<ClassBehaviourBinding> getClassBehaviourIndex(QName policy) {
        ClassBehaviourIndex<ClassBehaviourBinding> index = this.classBehaviours.get(policy);
        if (index == null) {
            index = new ClassBehaviourIndex(this.behaviourFilter);
            this.classBehaviours.put(policy, index);
        }
        return index;
    }

    private synchronized ClassBehaviourIndex<ClassFeatureBehaviourBinding> getPropertyBehaviourIndex(QName policy) {
        ClassBehaviourIndex<ClassFeatureBehaviourBinding> index = this.propertyBehaviours.get(policy);
        if (index == null) {
            index = new ClassBehaviourIndex(this.behaviourFilter);
            this.propertyBehaviours.put(policy, index);
        }
        return index;
    }

    private synchronized ClassBehaviourIndex<ClassFeatureBehaviourBinding> getAssociationBehaviourIndex(QName policy) {
        ClassBehaviourIndex<ClassFeatureBehaviourBinding> index = this.associationBehaviours.get(policy);
        if (index == null) {
            index = new ClassBehaviourIndex(this.behaviourFilter);
            this.associationBehaviours.put(policy, index);
        }
        return index;
    }

    private <B extends BehaviourBinding> BehaviourDefinition<B> createBehaviourDefinition(PolicyType type, QName policy, B binding, Behaviour behaviour) {
        PolicyDefinition policyDefinition = this.getRegisteredPolicy(type, policy);
        if (policyDefinition != null) {
            behaviour.getInterface(policyDefinition.getPolicyInterface());
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("Behaviour " + behaviour + " is binding (" + binding + ") to policy " + policy + " before the policy is registered"));
        }
        return new BehaviourDefinitionImpl(this, type, policy, binding, behaviour);
    }

    private PolicyDefinition createPolicyDefinition(Class policyIF) {
        String namespaceURI = "";
        try {
            Field metadata = policyIF.getField(ANNOTATION_NAMESPACE);
            if (!String.class.isAssignableFrom(metadata.getType())) {
                throw new PolicyException("NAMESPACE metadata incorrectly specified in policy " + policyIF.getCanonicalName());
            }
            namespaceURI = (String)metadata.get(null);
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        Method[] methods = policyIF.getMethods();
        if (methods.length != 1) {
            throw new PolicyException("Policy " + policyIF.getCanonicalName() + " must declare only one method");
        }
        String name = methods[0].getName();
        Class<?>[] paramTypes = methods[0].getParameterTypes();
        Policy.Arg[] args = new Policy.Arg[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            args[i] = i == 0 ? Policy.Arg.KEY : Policy.Arg.START_VALUE;
            try {
                Field argMetadata = policyIF.getField(ANNOTATION_ARG + i);
                if (!Policy.Arg.class.isAssignableFrom(argMetadata.getType())) {
                    throw new PolicyException("ARG_" + i + " metadata incorrectly specified in policy " + policyIF.getCanonicalName());
                }
                args[i] = (Policy.Arg)((Object)argMetadata.get(null));
                if (i != 0 || args[i].equals((Object)Policy.Arg.KEY)) continue;
                throw new PolicyException("ARG_" + i + " specified in policy " + policyIF.getCanonicalName() + " must be a key");
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return new PolicyDefinitionImpl(QName.createQName((String)namespaceURI, (String)name), policyIF, args);
    }

    static class BehaviourDefinitionImpl<B extends BehaviourBinding>
    implements BehaviourDefinition<B> {
        private PolicyType type;
        private QName policy;
        private B binding;
        private Behaviour behaviour;
        final /* synthetic */ PolicyComponentImpl this$0;

        BehaviourDefinitionImpl(PolicyType type, QName policy, B binding, Behaviour behaviour) {
            this.this$0 = var1_1;
            this.type = type;
            this.policy = policy;
            this.binding = binding;
            this.behaviour = behaviour;
        }

        @Override
        public QName getPolicy() {
            return this.policy;
        }

        @Override
        public PolicyDefinition getPolicyDefinition() {
            return this.this$0.getRegisteredPolicy(this.type, this.policy);
        }

        @Override
        public B getBinding() {
            return this.binding;
        }

        @Override
        public Behaviour getBehaviour() {
            return this.behaviour;
        }
    }

    class PolicyDefinitionImpl
    implements PolicyDefinition {
        private QName policy;
        private Class policyIF;
        private Policy.Arg[] args;

        PolicyDefinitionImpl(QName policy, Class policyIF, Policy.Arg[] args) {
            this.policy = policy;
            this.policyIF = policyIF;
            this.args = args;
        }

        @Override
        public QName getName() {
            return this.policy;
        }

        public Class getPolicyInterface() {
            return this.policyIF;
        }

        @Override
        public PolicyType getType() {
            if (ClassPolicy.class.isAssignableFrom(this.policyIF)) {
                return PolicyType.Class;
            }
            if (PropertyPolicy.class.isAssignableFrom(this.policyIF)) {
                return PolicyType.Property;
            }
            return PolicyType.Association;
        }

        @Override
        public Policy.Arg getArgument(int index) {
            if (index < 0 || index > this.args.length - 1) {
                throw new IllegalArgumentException("Argument index " + index + " is invalid");
            }
            return this.args[index];
        }

        @Override
        public Policy.Arg[] getArguments() {
            return this.args;
        }
    }

    private static class PolicyKey {
        private PolicyType type;
        private QName policy;

        private PolicyKey(PolicyType type, QName policy) {
            this.type = type;
            this.policy = policy;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof PolicyKey)) {
                return false;
            }
            PolicyKey other = (PolicyKey)obj;
            return this.type.equals((Object)other.type) && this.policy.equals((Object)other.policy);
        }

        public int hashCode() {
            return 37 * this.type.hashCode() + this.policy.hashCode();
        }
    }
}

