/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.publishing.AbstractChannelType;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.publishing.PublishingDetails;
import org.alfresco.service.cmr.publishing.PublishingEvent;
import org.alfresco.service.cmr.publishing.PublishingPackageEntry;
import org.alfresco.service.cmr.publishing.PublishingService;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class PublishingIntegratedTest
extends BaseSpringTest {
    protected ServiceRegistry serviceRegistry;
    protected RetryingTransactionHelper retryingTransactionHelper;
    protected NodeService nodeService;
    protected WorkflowService workflowService;
    protected FileFolderService fileFolderService;
    protected SiteService siteService;
    private ChannelService channelService;
    private PublishingService publishingService;
    protected AuthenticationComponent authenticationComponent;
    private String siteId;
    private AbstractChannelType mockedChannelType = (AbstractChannelType)Mockito.mock(AbstractChannelType.class);
    private String channelTypeName;

    @Test
    public void testScheduleNewEvent() throws Exception {
        Channel channel = this.channelService.createChannel(this.channelTypeName, GUID.generate(), null);
        HashSet<NodeRef> nodes = new HashSet<NodeRef>();
        for (int i = 0; i < 4; ++i) {
            nodes.add(this.nodeService.createNode(channel.getNodeRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)Integer.toString(i)), ContentModel.TYPE_CONTENT).getChildRef());
        }
        Calendar schedule = Calendar.getInstance();
        schedule.add(10, 1);
        PublishingDetails details = this.publishingService.createPublishingDetails().addNodesToPublish(nodes).setPublishChannelId(channel.getId()).setSchedule(schedule);
        String eventId = this.publishingService.scheduleNewEvent(details);
        PublishingEvent event = this.publishingService.getPublishingEvent(eventId);
        Assert.assertEquals((Object)schedule, (Object)event.getScheduledTime());
        Assert.assertEquals((String)eventId, (String)event.getId());
        Collection<PublishingPackageEntry> entries = event.getPackage().getEntries();
        Assert.assertEquals((int)4, (int)entries.size());
        for (PublishingPackageEntry entry : entries) {
            Assert.assertTrue((boolean)entry.isPublish());
            Assert.assertTrue((boolean)nodes.remove(entry.getNodeRef()));
        }
        Assert.assertTrue((boolean)nodes.isEmpty());
    }

    @Test
    public void testCancelScheduledEvent() {
        Channel channel = this.channelService.createChannel(this.channelTypeName, GUID.generate(), null);
        HashSet<NodeRef> nodes = new HashSet<NodeRef>();
        for (int i = 0; i < 4; ++i) {
            nodes.add(this.nodeService.createNode(channel.getNodeRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)Integer.toString(i)), ContentModel.TYPE_CONTENT).getChildRef());
        }
        Calendar schedule = Calendar.getInstance();
        schedule.add(10, 1);
        PublishingDetails details = this.publishingService.createPublishingDetails().addNodesToPublish(nodes).setPublishChannelId(channel.getId()).setSchedule(schedule);
        String eventId = this.publishingService.scheduleNewEvent(details);
        PublishingEvent event = this.publishingService.getPublishingEvent(eventId);
        Assert.assertNotNull((Object)event);
        this.publishingService.cancelPublishingEvent(eventId);
        event = this.publishingService.getPublishingEvent(eventId);
        Assert.assertNull((Object)event);
    }

    @Before
    public void onSetUp() throws Exception {
        this.serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.serviceRegistry.getAuthenticationService().authenticate("admin", "admin".toCharArray());
        this.retryingTransactionHelper = this.serviceRegistry.getRetryingTransactionHelper();
        this.fileFolderService = this.serviceRegistry.getFileFolderService();
        this.workflowService = this.serviceRegistry.getWorkflowService();
        this.nodeService = this.serviceRegistry.getNodeService();
        this.siteService = this.serviceRegistry.getSiteService();
        this.channelService = (ChannelService)this.applicationContext.getBean("ChannelService");
        this.publishingService = (PublishingService)this.applicationContext.getBean("PublishingService");
        this.siteId = GUID.generate();
        this.siteService.createSite("test", this.siteId, "Test site created by ChannelServiceImplIntegratedTest", "Test site created by PublishingIntegratedTest", SiteVisibility.PUBLIC);
        this.channelTypeName = "MockedChannelType";
        Mockito.when((Object)this.mockedChannelType.getId()).thenReturn((Object)this.channelTypeName);
        Mockito.when((Object)this.mockedChannelType.getChannelNodeType()).thenReturn((Object)PublishingModel.TYPE_DELIVERY_CHANNEL);
        if (this.channelService.getChannelType(this.channelTypeName) == null) {
            this.channelService.register(this.mockedChannelType);
        }
    }
}

