/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.flickr.springsocial.api.impl;

import org.alfresco.repo.publishing.flickr.springsocial.api.FlickrException;
import org.alfresco.repo.publishing.flickr.springsocial.api.FlickrHelper;
import org.alfresco.repo.publishing.flickr.springsocial.api.MediaOperations;
import org.alfresco.repo.publishing.flickr.springsocial.api.PhotoInfo;
import org.alfresco.repo.publishing.flickr.springsocial.api.impl.AbstractFlickrOperations;
import org.alfresco.repo.publishing.flickr.springsocial.api.impl.xml.FlickrError;
import org.alfresco.repo.publishing.flickr.springsocial.api.impl.xml.FlickrPayload;
import org.alfresco.repo.publishing.flickr.springsocial.api.impl.xml.FlickrResponse;
import org.alfresco.repo.publishing.flickr.springsocial.api.impl.xml.Photo;
import org.alfresco.repo.publishing.flickr.springsocial.api.impl.xml.PhotoId;
import org.springframework.core.io.Resource;
import org.springframework.social.support.URIBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

class MediaTemplate
extends AbstractFlickrOperations
implements MediaOperations {
    private final RestTemplate restTemplate;
    private FlickrHelper helper;

    public MediaTemplate(FlickrHelper helper, RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
        this.helper = helper;
    }

    @Override
    public String postPhoto(Resource photo, String title, String description, String ... tags) {
        String id = null;
        this.requireAuthorization();
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        URIBuilder uriBuilder = URIBuilder.fromUri((String)this.helper.getUploadEndpoint());
        parts.set((Object)"photo", (Object)photo);
        if (description != null) {
            uriBuilder.queryParam("description", description);
            parts.set((Object)"description", (Object)description);
        }
        if (title != null) {
            uriBuilder.queryParam("title", title);
            parts.set((Object)"title", (Object)title);
        }
        if (tags.length > 0) {
            StringBuilder tagBuilder = new StringBuilder();
            for (String tag : tags) {
                tagBuilder.append(tag).append(' ');
            }
            String tagsString = tagBuilder.toString();
            uriBuilder.queryParam("tags", tagsString);
            parts.set((Object)"tags", (Object)tagsString);
        }
        this.helper.addStandardParams(uriBuilder);
        FlickrResponse response = (FlickrResponse)this.restTemplate.postForObject(uriBuilder.build(), (Object)parts, FlickrResponse.class);
        FlickrPayload payload = response.payload;
        this.checkError(payload);
        if (PhotoId.class.isAssignableFrom(payload.getClass())) {
            id = ((PhotoId)payload).id;
        }
        return id;
    }

    @Override
    public PhotoInfo getPhoto(String id) {
        Photo result = null;
        this.requireAuthorization();
        URIBuilder uriBuilder = URIBuilder.fromUri((String)this.helper.getRestEndpoint());
        this.helper.addStandardParams(uriBuilder);
        uriBuilder.queryParam("method", "flickr.photos.getInfo");
        uriBuilder.queryParam("photo_id", id);
        FlickrResponse response = (FlickrResponse)this.restTemplate.getForObject(uriBuilder.build(), FlickrResponse.class);
        FlickrPayload payload = response.payload;
        this.checkError(payload);
        if (Photo.class.isAssignableFrom(payload.getClass())) {
            result = (Photo)payload;
        }
        return result;
    }

    @Override
    public void deletePhoto(String id) {
        this.requireAuthorization();
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        this.helper.addStandardParams((MultiValueMap<String, String>)parts);
        parts.add((Object)"method", (Object)"flickr.photos.delete");
        parts.add((Object)"photo_id", (Object)id);
        FlickrResponse response = (FlickrResponse)this.restTemplate.postForObject(this.helper.getRestEndpoint(), (Object)parts, FlickrResponse.class, new Object[0]);
        FlickrPayload payload = response.payload;
        this.checkError(payload);
    }

    private void checkError(FlickrPayload payload) throws FlickrException {
        if (payload != null && FlickrError.class.isAssignableFrom(payload.getClass())) {
            FlickrError error = (FlickrError)payload;
            throw new FlickrException(error.code, error.msg);
        }
    }
}

