/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.slideshare;

import com.benfante.jslideshare.SlideShareConnector;
import com.benfante.jslideshare.SlideShareErrorException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.log4j.Logger;

public class SlideShareConnectorImpl
implements SlideShareConnector {
    private static final Logger logger = Logger.getLogger(SlideShareConnectorImpl.class);
    private String apiKey;
    private String sharedSecret;
    private HttpClient httpClient = new HttpClient();

    public SlideShareConnectorImpl() {
        this.httpClient.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
    }

    public SlideShareConnectorImpl(String apiKey, String sharedSecret) {
        this();
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public InputStream sendMessage(String url, Map<String, String> parameters) throws IOException, SlideShareErrorException {
        PostMethod method = new PostMethod(url);
        method.addParameter("api_key", this.apiKey);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            method.addParameter(entry.getKey(), entry.getValue());
        }
        Date now = new Date();
        String ts = Long.toString(now.getTime() / 1000L);
        String hash = DigestUtils.shaHex((String)(this.sharedSecret + ts)).toLowerCase();
        method.addParameter("ts", ts);
        method.addParameter("hash", hash);
        logger.debug((Object)("Sending POST message to " + method.getURI().getURI() + " with parameters " + Arrays.toString(method.getParameters())));
        int statusCode = this.httpClient.executeMethod((HttpMethod)method);
        if (statusCode != 200) {
            logger.debug((Object)("Server replied with a " + statusCode + " HTTP status code (" + HttpStatus.getStatusText((int)statusCode) + ")"));
            throw new SlideShareErrorException(statusCode, HttpStatus.getStatusText((int)statusCode));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)method.getResponseBodyAsString());
        }
        ByteArrayInputStream result = new ByteArrayInputStream(method.getResponseBody());
        method.releaseConnection();
        return result;
    }

    public InputStream sendMultiPartMessage(String url, Map<String, String> parameters, Map<String, File> files) throws IOException, SlideShareErrorException {
        PostMethod method = new PostMethod(url);
        ArrayList<Object> partList = new ArrayList<Object>();
        partList.add(this.createStringPart("api_key", this.apiKey));
        Date now = new Date();
        String ts = Long.toString(now.getTime() / 1000L);
        String hash = DigestUtils.shaHex((String)(this.sharedSecret + ts)).toLowerCase();
        partList.add(this.createStringPart("ts", ts));
        partList.add(this.createStringPart("hash", hash));
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            partList.add(this.createStringPart(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, File> entry : files.entrySet()) {
            partList.add(this.createFilePart(entry.getKey(), entry.getValue()));
        }
        MultipartRequestEntity requestEntity = new MultipartRequestEntity(partList.toArray(new Part[partList.size()]), method.getParams());
        method.setRequestEntity((RequestEntity)requestEntity);
        logger.debug((Object)("Sending multipart POST message to " + method.getURI().getURI() + " with parts " + partList));
        int statusCode = this.httpClient.executeMethod((HttpMethod)method);
        if (statusCode != 200) {
            logger.debug((Object)("Server replied with a " + statusCode + " HTTP status code (" + HttpStatus.getStatusText((int)statusCode) + ")"));
            throw new SlideShareErrorException(statusCode, HttpStatus.getStatusText((int)statusCode));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)method.getResponseBodyAsString());
        }
        ByteArrayInputStream result = new ByteArrayInputStream(method.getResponseBody());
        method.releaseConnection();
        return result;
    }

    public InputStream sendGetMessage(String url, Map<String, String> parameters) throws IOException, SlideShareErrorException {
        GetMethod method = new GetMethod(url);
        Object[] params = new NameValuePair[parameters.size() + 3];
        int i = 0;
        params[i++] = new NameValuePair("api_key", this.apiKey);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            params[i++] = new NameValuePair(entry.getKey(), entry.getValue());
        }
        Date now = new Date();
        String ts = Long.toString(now.getTime() / 1000L);
        String hash = DigestUtils.shaHex((String)(this.sharedSecret + ts)).toLowerCase();
        params[i++] = new NameValuePair("ts", ts);
        params[i++] = new NameValuePair("hash", hash);
        method.setQueryString((NameValuePair[])params);
        logger.debug((Object)("Sending GET message to " + method.getURI().getURI() + " with parameters " + Arrays.toString(params)));
        int statusCode = this.httpClient.executeMethod((HttpMethod)method);
        if (statusCode != 200) {
            logger.debug((Object)("Server replied with a " + statusCode + " HTTP status code (" + HttpStatus.getStatusText((int)statusCode) + ")"));
            throw new SlideShareErrorException(statusCode, HttpStatus.getStatusText((int)statusCode));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)method.getResponseBodyAsString());
        }
        ByteArrayInputStream result = new ByteArrayInputStream(method.getResponseBody());
        method.releaseConnection();
        return result;
    }

    private StringPart createStringPart(String name, String value) {
        StringPart stringPart = new StringPart(name, value);
        stringPart.setContentType(null);
        stringPart.setTransferEncoding(null);
        stringPart.setCharSet("UTF-8");
        return stringPart;
    }

    private FilePart createFilePart(String name, File value) throws FileNotFoundException {
        FilePart filePart = new FilePart(name, value);
        filePart.setTransferEncoding(null);
        filePart.setCharSet(null);
        return filePart;
    }
}

