/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import java.util.Collection;
import java.util.Map;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.repo.rendition.executer.BaseTemplateRenderingEngine;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateImageResolver;

public class FreemarkerRenderingEngine
extends BaseTemplateRenderingEngine {
    public static final String NAME = "freemarkerRenderingEngine";
    private static final String PARAM_IMAGE_RESOLVER = "image_resolver";
    public static final String KEY_NODE = "node";
    private Repository repository;
    private ServiceRegistry serviceRegistry;

    @Override
    protected Collection<ParameterDefinition> getParameterDefinitions() {
        Collection<ParameterDefinition> paramList = super.getParameterDefinitions();
        paramList.add(new ParameterDefinitionImpl(PARAM_IMAGE_RESOLVER, DataTypeDefinition.ANY, false, this.getParamDisplayLabel(PARAM_IMAGE_RESOLVER)));
        return paramList;
    }

    @Override
    protected Object buildModel(AbstractRenderingEngine.RenderingContext context) {
        NodeRef companyHome = this.repository.getCompanyHome();
        NodeRef templateNode = this.getTemplateNode(context);
        Map paramMap = context.getCheckedParam("model", Map.class);
        TemplateImageResolver imgResolver = context.getCheckedParam(PARAM_IMAGE_RESOLVER, TemplateImageResolver.class);
        String fullyAuthenticatedUser = AuthenticationUtil.getFullyAuthenticatedUser();
        NodeRef person = this.serviceRegistry.getPersonService().getPerson(fullyAuthenticatedUser);
        NodeRef userHome = this.repository.getUserHome(person);
        Map<String, Object> model = this.getTemplateService().buildDefaultModel(person, companyHome, userHome, templateNode, imgResolver);
        TemplateNode sourceTemplateNode = new TemplateNode(context.getSourceNode(), this.serviceRegistry, imgResolver);
        model.put(KEY_NODE, sourceTemplateNode);
        if (paramMap != null) {
            model.putAll(paramMap);
        }
        return model;
    }

    @Override
    protected String getTemplateType() {
        return "freemarker";
    }

    public void setRepositoryHelper(Repository repository) {
        this.repository = repository;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }
}

