/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.repo.rendition.executer.BaseTemplateRenderingEngine;
import org.alfresco.repo.rendition.executer.XSLTFunctions;
import org.alfresco.repo.template.TemplateProcessorMethod;
import org.alfresco.repo.template.XSLTProcessor;
import org.alfresco.repo.template.XSLTemplateModel;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.XMLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XSLTRenderingEngine
extends BaseTemplateRenderingEngine {
    public static final String NAME = "xsltRenderingEngine";
    private static final Log log = LogFactory.getLog(XSLTRenderingEngine.class);
    private XSLTFunctions xsltFunctions;
    private NamespacePrefixResolver namespacePrefixResolver;
    private FileFolderService fileFolderService;

    @Override
    protected Object buildModel(AbstractRenderingEngine.RenderingContext context) {
        Map suppliedParams = context.getCheckedParam("model", Map.class);
        NodeRef sourceNode = context.getSourceNode();
        final NodeRef parentNode = this.nodeService.getPrimaryParent(context.getSourceNode()).getParentRef();
        String sourcePath = this.getPath(sourceNode);
        final String parentPath = this.getPath(parentNode);
        XSLTemplateModel model = new XSLTemplateModel();
        model.put(QName.createQName((String)"http://www.alfresco.org", (String)"date"), (Object)new Date());
        model.put(QName.createQName((String)"alf", (String)"source_file_name", (NamespacePrefixResolver)this.namespacePrefixResolver), (Object)this.nodeService.getProperty(context.getSourceNode(), ContentModel.PROP_NAME));
        model.put(QName.createQName((String)"alf", (String)"source_path", (NamespacePrefixResolver)this.namespacePrefixResolver), (Object)sourcePath);
        model.put(QName.createQName((String)"alf", (String)"parent_path", (NamespacePrefixResolver)this.namespacePrefixResolver), (Object)parentPath);
        model.put(QName.createQName((String)"alf", (String)"encodeQuotes", (NamespacePrefixResolver)this.namespacePrefixResolver), (Object)new TemplateProcessorMethod(){

            @Override
            public Object exec(Object[] arguments) throws IOException, SAXException {
                if (arguments.length != 1) {
                    throw new IllegalArgumentException("expected 1 argument to encodeQuotes.  got " + arguments.length);
                }
                if (!(arguments[0] instanceof String)) {
                    throw new ClassCastException("expected arguments[0] to be a " + String.class.getName() + ".  got a " + arguments[0].getClass().getName() + ".");
                }
                String text = (String)arguments[0];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("tpm_encodeQuotes('" + text + "'), parentPath = " + parentPath));
                }
                String result = XSLTRenderingEngine.this.xsltFunctions.encodeQuotes(text);
                return result;
            }
        });
        model.put(QName.createQName((String)"alf", (String)"parseXMLDocument", (NamespacePrefixResolver)this.namespacePrefixResolver), (Object)new TemplateProcessorMethod(){

            @Override
            public Object exec(Object[] arguments) throws IOException, SAXException {
                if (arguments.length != 1) {
                    throw new IllegalArgumentException("expected 1 argument to parseXMLDocument.  got " + arguments.length);
                }
                if (!(arguments[0] instanceof String)) {
                    throw new ClassCastException("expected arguments[0] to be a " + String.class.getName() + ".  got a " + arguments[0].getClass().getName() + ".");
                }
                String path = (String)arguments[0];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("parseXMLDocument('" + path + "'), parentPath = " + parentPath));
                }
                Document d = null;
                try {
                    d = XSLTRenderingEngine.this.xsltFunctions.parseXMLDocument(parentNode, path);
                }
                catch (Exception ex) {
                    log.warn((Object)"Received an exception from parseXMLDocument()", (Throwable)ex);
                }
                return d == null ? null : d.getDocumentElement();
            }
        });
        model.put(QName.createQName((String)"alf", (String)"parseXMLDocuments", (NamespacePrefixResolver)this.namespacePrefixResolver), (Object)new TemplateProcessorMethod(){

            @Override
            public Object exec(Object[] arguments) throws IOException, SAXException {
                if (arguments.length > 2) {
                    throw new IllegalArgumentException("expected one or two arguments to parseXMLDocuments.  got " + arguments.length);
                }
                if (!(arguments[0] instanceof String)) {
                    throw new ClassCastException("expected arguments[0] to be a " + String.class.getName() + ".  got a " + arguments[0].getClass().getName() + ".");
                }
                if (arguments.length == 2 && !(arguments[1] instanceof String)) {
                    throw new ClassCastException("expected arguments[1] to be a " + String.class.getName() + ".  got a " + arguments[1].getClass().getName() + ".");
                }
                String path = arguments.length == 2 ? (String)arguments[1] : "";
                String typeName = (String)arguments[0];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("tpm_parseXMLDocuments('" + typeName + "','" + path + "'), parentPath = " + parentPath));
                }
                Map<String, Document> resultMap = XSLTRenderingEngine.this.xsltFunctions.parseXMLDocuments(typeName, parentNode, path);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("received " + resultMap.size() + " documents in " + path + " with form name " + typeName));
                }
                Document rootNodeDocument = XMLUtil.newDocument();
                Element rootNodeDocumentEl = rootNodeDocument.createElementNS("http://www.alfresco.org", "alf:file_list");
                rootNodeDocumentEl.setAttribute("xmlns:alf", "http://www.alfresco.org");
                rootNodeDocument.appendChild(rootNodeDocumentEl);
                ArrayList<Node> result = new ArrayList<Node>(resultMap.size());
                for (Map.Entry<String, Document> e : resultMap.entrySet()) {
                    Element documentEl = e.getValue().getDocumentElement();
                    documentEl.setAttribute("xmlns:alf", "http://www.alfresco.org");
                    documentEl.setAttributeNS("http://www.alfresco.org", "alf:file_name", e.getKey());
                    Node n = rootNodeDocument.importNode(documentEl, true);
                    rootNodeDocumentEl.appendChild(n);
                    result.add(n);
                }
                return result.toArray(new Node[result.size()]);
            }
        });
        if (suppliedParams != null) {
            for (Map.Entry suppliedParam : suppliedParams.entrySet()) {
                model.put(QName.createQName((String)((String)suppliedParam.getKey())), suppliedParam.getValue());
            }
        }
        try {
            model.put(XSLTProcessor.ROOT_NAMESPACE, (Object)XMLUtil.parse(sourceNode, this.contentService));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RenditionServiceException("Failed to parse XML from source node.", ex);
        }
        return model;
    }

    @Override
    protected String getTemplateType() {
        return "xslt";
    }

    private String getPath(NodeRef nodeRef) {
        StringBuilder sb = new StringBuilder();
        try {
            List<FileInfo> parentFileInfoList = this.fileFolderService.getNamePath(null, nodeRef);
            for (FileInfo fileInfo : parentFileInfoList) {
                sb.append('/');
                sb.append(fileInfo.getName());
            }
        }
        catch (FileNotFoundException ex) {
            log.info((Object)("Unexpected problem: error while calculating path to node " + nodeRef), (Throwable)ex);
        }
        String path = sb.toString();
        return path;
    }

    public void setXsltFunctions(XSLTFunctions xsltFunctions) {
        this.xsltFunctions = xsltFunctions;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }
}

