/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionServiceImplTest;
import org.alfresco.repo.action.executer.MailActionExecuter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.rule.RuleServiceException;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StopWatch;

public class RuleServiceCoverageTest
extends TestCase {
    static ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RuleService ruleService;
    private NodeService nodeService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private CheckOutCheckInService cociService;
    private LockService lockService;
    private ContentService contentService;
    private ServiceRegistry serviceRegistry;
    private DictionaryDAO dictionaryDAO;
    private ActionService actionService;
    private ContentTransformerRegistry transformerRegistry;
    private CopyService copyService;
    private AuthenticationComponent authenticationComponent;
    private FileFolderService fileFolderService;
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/rulesystemtest";
    private static final QName CAT_PROP_QNAME = QName.createQName((String)"http://www.alfresco.org/test/rulesystemtest", (String)"region");
    private QName regionCategorisationQName;
    private NodeRef catContainer;
    private NodeRef catRoot;
    private NodeRef catRBase;
    private NodeRef catROne;
    private NodeRef catRTwo;
    private NodeRef catRThree;
    private static final String STANDARD_TEXT_CONTENT = "standardTextContent";

    protected void setUp() throws Exception {
        this.serviceRegistry = (ServiceRegistry)applicationContext.getBean("ServiceRegistry");
        this.nodeService = this.serviceRegistry.getNodeService();
        this.ruleService = this.serviceRegistry.getRuleService();
        this.cociService = this.serviceRegistry.getCheckOutCheckInService();
        this.lockService = this.serviceRegistry.getLockService();
        this.copyService = this.serviceRegistry.getCopyService();
        this.contentService = this.serviceRegistry.getContentService();
        this.dictionaryDAO = (DictionaryDAO)applicationContext.getBean("dictionaryDAO");
        this.actionService = this.serviceRegistry.getActionService();
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.transformerRegistry = (ContentTransformerRegistry)applicationContext.getBean("contentTransformerRegistry");
        this.authenticationComponent = (AuthenticationComponent)applicationContext.getBean("authenticationComponent");
        this.fileFolderService = this.serviceRegistry.getFileFolderService();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> setUserCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                RuleServiceCoverageTest.this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(setUserCallback);
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
    }

    private Rule createRule(String ruleTypeName, String actionName, Map<String, Serializable> actionParams, String conditionName, Map<String, Serializable> conditionParams) {
        Rule rule = new Rule();
        rule.setRuleType(ruleTypeName);
        Action action = this.actionService.createAction(actionName, actionParams);
        ActionCondition condition = this.actionService.createActionCondition(conditionName, conditionParams);
        action.addActionCondition(condition);
        rule.setAction(action);
        return rule;
    }

    private void createTestCategories() {
        M2Model model = M2Model.createModel((String)"test:rulecategory");
        model.createNamespace(TEST_NAMESPACE, "test");
        model.createImport("http://www.alfresco.org/model/dictionary/1.0", "d");
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        this.regionCategorisationQName = QName.createQName((String)TEST_NAMESPACE, (String)"region");
        M2Aspect generalCategorisation = model.createAspect("test:" + this.regionCategorisationQName.getLocalName());
        generalCategorisation.setParentName("cm:" + ContentModel.ASPECT_CLASSIFIABLE.getLocalName());
        M2Property genCatProp = generalCategorisation.createProperty("test:region");
        genCatProp.setIndexed(true);
        genCatProp.setIndexedAtomically(true);
        genCatProp.setMandatory(true);
        genCatProp.setMultiValued(true);
        genCatProp.setStoredInIndex(true);
        genCatProp.setIndexTokenisationMode(IndexTokenisationMode.TRUE);
        genCatProp.setType("d:" + DataTypeDefinition.CATEGORY.getLocalName());
        this.dictionaryDAO.putModel(model);
        this.catContainer = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"categoryContainer"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.catRoot = this.nodeService.createNode(this.catContainer, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"categoryRoot"), ContentModel.TYPE_CATEGORYROOT).getChildRef();
        this.catRBase = this.nodeService.createNode(this.catRoot, ContentModel.ASSOC_CATEGORIES, QName.createQName((String)TEST_NAMESPACE, (String)"region"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catROne = this.nodeService.createNode(this.catRBase, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName((String)TEST_NAMESPACE, (String)"Europe"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catRTwo = this.nodeService.createNode(this.catRBase, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName((String)TEST_NAMESPACE, (String)"RestOfWorld"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catRThree = this.nodeService.createNode(this.catRTwo, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName((String)TEST_NAMESPACE, (String)"US"), ContentModel.TYPE_CATEGORY).getChildRef();
    }

    public void testAsyncRuleExecution() {
        final NodeRef newNodeRef = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() {
                RuleServiceCoverageTest.this.nodeService.addAspect(RuleServiceCoverageTest.this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
                HashMap<String, QName> params = new HashMap<String, QName>(1);
                params.put("aspect-name", ContentModel.ASPECT_VERSIONABLE);
                Rule rule = RuleServiceCoverageTest.this.createRule("inbound", "add-features", params, "no-condition", null);
                rule.setExecuteAsynchronously(true);
                RuleServiceCoverageTest.this.ruleService.saveRule(RuleServiceCoverageTest.this.nodeRef, rule);
                NodeRef newNodeRef = RuleServiceCoverageTest.this.nodeService.createNode(RuleServiceCoverageTest.this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)RuleServiceCoverageTest.TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, RuleServiceCoverageTest.this.getContentProperties()).getChildRef();
                RuleServiceCoverageTest.this.addContentToNode(newNodeRef);
                return newNodeRef;
            }
        });
        ActionServiceImplTest.postAsyncActionTest(this.transactionService, 5000L, 12, new ActionServiceImplTest.AsyncTest(){

            @Override
            public String executeTest() {
                boolean result = RuleServiceCoverageTest.this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE);
                return result ? null : "Expected aspect Versionable";
            }
        });
    }

    public void testAddFeaturesAction() {
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("inbound", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        HashMap<String, Serializable> params2 = new HashMap<String, Serializable>(2);
        params2.put("aspect-name", (Serializable)ApplicationModel.ASPECT_SIMPLE_WORKFLOW);
        params2.put(ApplicationModel.PROP_APPROVE_STEP.toString(), (Serializable)((Object)"approveStep"));
        params2.put(ApplicationModel.PROP_APPROVE_MOVE.toString(), Boolean.valueOf(false));
        Action action2 = this.actionService.createAction("add-features", params2);
        rule.setAction(action2);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef2);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef2, ApplicationModel.ASPECT_SIMPLE_WORKFLOW));
        RuleServiceCoverageTest.assertEquals((Object)"approveStep", (Object)this.nodeService.getProperty(newNodeRef2, ApplicationModel.PROP_APPROVE_STEP));
        RuleServiceCoverageTest.assertEquals((Object)false, (Object)this.nodeService.getProperty(newNodeRef2, ApplicationModel.PROP_APPROVE_MOVE));
    }

    public void testCheckThatModifyNameDoesNotTriggerInboundRule() throws Exception {
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "myTestFolder");
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, folderProps).getChildRef();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("inbound", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(folder, rule);
        HashMap<QName, String> contentProps = new HashMap<QName, String>(1);
        contentProps.put(ContentModel.PROP_NAME, "myTestDocument.txt");
        NodeRef newNodeRef = this.nodeService.createNode(folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"myTestDocument.txt"), ContentModel.TYPE_CONTENT, contentProps).getChildRef();
        this.nodeService.removeAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.fileFolderService.rename(newNodeRef, "myNewName.txt");
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
    }

    public void testCheckThatModifyNameDoesNotTriggerOutboundRule() throws Exception {
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "myTestFolder");
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, folderProps).getChildRef();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("outbound", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(folder, rule);
        HashMap<QName, String> contentProps = new HashMap<QName, String>(1);
        contentProps.put(ContentModel.PROP_NAME, "myTestDocument.txt");
        NodeRef newNodeRef = this.fileFolderService.create(folder, "abc.txt", ContentModel.TYPE_CONTENT).getNodeRef();
        RuleServiceCoverageTest.assertFalse((String)"Should not be versionable", (boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.fileFolderService.rename(newNodeRef, "myNewName.txt");
        RuleServiceCoverageTest.assertFalse((String)"Should not be versionable", (boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
    }

    public void testCheckThatChildRuleFiresOnMove() throws Exception {
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "myTestFolder");
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, folderProps).getChildRef();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("inbound", "add-features", params, "no-condition", null);
        rule.applyToChildren(true);
        this.ruleService.saveRule(folder, rule);
        folderProps.put(ContentModel.PROP_NAME, "myMoveFolder");
        NodeRef folderForMove = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, folderProps).getChildRef();
        NodeRef testFile = this.fileFolderService.create(folderForMove, "testFile.txt", ContentModel.TYPE_CONTENT).getNodeRef();
        this.fileFolderService.move(folderForMove, folder, null);
        RuleServiceCoverageTest.assertTrue((String)"Should be versionable", (boolean)this.nodeService.hasAspect(testFile, ContentModel.ASPECT_VERSIONABLE));
    }

    public void testUpdateAndMoveRuleOnSameFolder() throws Exception {
        NodeRef sourceFolder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}sourceFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef targetFolder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}targetFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", (Serializable)ContentModel.ASPECT_LOCKABLE);
        Rule rule = this.createRule("update", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(sourceFolder, rule);
        NodeRef testNodeOneRef = this.fileFolderService.create(sourceFolder, "one.txt", ContentModel.TYPE_CONTENT).getNodeRef();
        RuleServiceCoverageTest.assertFalse((String)"Node should not have lockable aspect", (boolean)this.nodeService.hasAspect(testNodeOneRef, ContentModel.ASPECT_LOCKABLE));
        this.nodeService.setProperty(testNodeOneRef, ContentModel.PROP_LOCALE, (Serializable)Locale.CANADA);
        RuleServiceCoverageTest.assertTrue((String)"Node should have lockable aspect", (boolean)this.nodeService.hasAspect(testNodeOneRef, ContentModel.ASPECT_LOCKABLE));
        this.fileFolderService.delete(testNodeOneRef);
        params = new HashMap(1);
        params.put("destination-folder", (Serializable)targetFolder);
        Rule copyRule = this.createRule("outbound", "copy", params, "no-condition", null);
        copyRule.applyToChildren(true);
        this.ruleService.saveRule(sourceFolder, copyRule);
        NodeRef testNodeTwoRef = this.fileFolderService.create(sourceFolder, "two.txt", ContentModel.TYPE_CONTENT).getNodeRef();
        RuleServiceCoverageTest.assertFalse((String)"Node should not have lockable aspect", (boolean)this.nodeService.hasAspect(testNodeTwoRef, ContentModel.ASPECT_LOCKABLE));
        this.fileFolderService.delete(testNodeTwoRef);
        RuleServiceCoverageTest.assertFalse((String)"Node was not deleted", (boolean)this.fileFolderService.exists(testNodeTwoRef));
        RuleServiceCoverageTest.assertEquals((String)"There should not be any children in source folder", (int)0, (int)this.fileFolderService.listFiles(sourceFolder).size());
        List<FileInfo> targetFolderFileList = this.fileFolderService.listFiles(targetFolder);
        RuleServiceCoverageTest.assertEquals((String)"Node should have been copied to target folder", (int)1, (int)targetFolderFileList.size());
        RuleServiceCoverageTest.assertFalse((String)"The node copy should not be lockable", (boolean)this.nodeService.hasAspect(targetFolderFileList.get(0).getNodeRef(), ContentModel.ASPECT_LOCKABLE));
    }

    public void testDisableIndividualRules() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", (Serializable)ApplicationModel.ASPECT_CONFIGURABLE);
        Rule rule = this.createRule("inbound", "add-features", params, "no-condition", null);
        rule.setRuleDisabled(true);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef, ApplicationModel.ASPECT_CONFIGURABLE));
        Rule rule2 = this.ruleService.getRule(rule.getNodeRef());
        rule2.setRuleDisabled(false);
        this.ruleService.saveRule(this.nodeRef, rule2);
        NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef2);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef2, ApplicationModel.ASPECT_CONFIGURABLE));
    }

    public void testDisableRule() {
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("inbound", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        this.ruleService.disableRule(rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.ruleService.enableRule(rule);
        NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef2);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef2, ContentModel.ASPECT_VERSIONABLE));
    }

    public void testAddFeaturesToAFolder() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", (Serializable)ContentModel.ASPECT_TEMPLATABLE);
        Rule rule = this.createRule("inbound", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_FOLDER).getChildRef();
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_TEMPLATABLE));
    }

    public void testCopyFolderToTriggerRules() {
        NodeRef copyToFolder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copyToFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef folderToCopy = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}folderToCopy"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef contentToCopy = this.nodeService.createNode(folderToCopy, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}contentToCopy"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(contentToCopy);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", (Serializable)ContentModel.ASPECT_TEMPLATABLE);
        Rule rule = this.createRule("inbound", "add-features", params, "no-condition", null);
        rule.applyToChildren(true);
        this.ruleService.saveRule(copyToFolder, rule);
        NodeRef copiedFolder = this.copyService.copy(folderToCopy, copyToFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}coppiedFolder"), true);
        RuleServiceCoverageTest.assertNotNull((Object)copiedFolder);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(copiedFolder, ContentModel.ASPECT_TEMPLATABLE));
        for (ChildAssociationRef childAssoc : this.nodeService.getChildAssocs(copiedFolder)) {
            RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(childAssoc.getChildRef(), ContentModel.ASPECT_TEMPLATABLE));
        }
    }

    private Map<QName, Serializable> getContentProperties() {
        return null;
    }

    public void testSimpleWorkflowAction() {
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("approve-step", (Serializable)((Object)"approveStep"));
        params.put("approve-folder", (Serializable)this.rootNodeRef);
        params.put("approve-move", Boolean.valueOf(true));
        params.put("reject-step", (Serializable)((Object)"rejectStep"));
        params.put("reject-folder", (Serializable)this.rootNodeRef);
        params.put("reject-move", Boolean.valueOf(false));
        Rule rule = this.createRule("inbound", "simple-workflow", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ApplicationModel.ASPECT_SIMPLE_WORKFLOW));
        RuleServiceCoverageTest.assertEquals((Object)"approveStep", (Object)this.nodeService.getProperty(newNodeRef, ApplicationModel.PROP_APPROVE_STEP));
        RuleServiceCoverageTest.assertEquals((Object)this.rootNodeRef, (Object)this.nodeService.getProperty(newNodeRef, ApplicationModel.PROP_APPROVE_FOLDER));
        RuleServiceCoverageTest.assertTrue((boolean)((Boolean)this.nodeService.getProperty(newNodeRef, ApplicationModel.PROP_APPROVE_MOVE)));
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ApplicationModel.ASPECT_SIMPLE_WORKFLOW));
        RuleServiceCoverageTest.assertEquals((Object)"rejectStep", (Object)this.nodeService.getProperty(newNodeRef, ApplicationModel.PROP_REJECT_STEP));
        RuleServiceCoverageTest.assertEquals((Object)this.rootNodeRef, (Object)this.nodeService.getProperty(newNodeRef, ApplicationModel.PROP_REJECT_FOLDER));
        RuleServiceCoverageTest.assertFalse((boolean)((Boolean)this.nodeService.getProperty(newNodeRef, ApplicationModel.PROP_REJECT_MOVE)));
    }

    public void testInCategoryCondition() {
        this.createTestCategories();
        try {
            HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
            params.put("category-aspect", (Serializable)this.regionCategorisationQName);
            params.put("category-value", (Serializable)this.catROne);
            HashMap<String, Serializable> params2 = new HashMap<String, Serializable>(1);
            params2.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
            Rule rule = this.createRule("inbound", "add-features", params2, "in-category", params);
            this.ruleService.saveRule(this.nodeRef, rule);
            NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"noAspect"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
            this.addContentToNode(newNodeRef2);
            RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef2, ContentModel.ASPECT_VERSIONABLE));
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback1 = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Throwable {
                    NodeRef newNodeRef = RuleServiceCoverageTest.this.nodeService.createNode(RuleServiceCoverageTest.this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)RuleServiceCoverageTest.TEST_NAMESPACE, (String)"hasAspectAndValue"), ContentModel.TYPE_CONTENT, RuleServiceCoverageTest.this.getContentProperties()).getChildRef();
                    RuleServiceCoverageTest.this.addContentToNode(newNodeRef);
                    HashMap<QName, NodeRef> catProps = new HashMap<QName, NodeRef>();
                    catProps.put(CAT_PROP_QNAME, RuleServiceCoverageTest.this.catROne);
                    RuleServiceCoverageTest.this.nodeService.addAspect(newNodeRef, RuleServiceCoverageTest.this.regionCategorisationQName, catProps);
                    return newNodeRef;
                }
            };
            NodeRef newNodeRef = this.transactionService.getRetryingTransactionHelper().doInTransaction(callback1);
            RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback3 = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Throwable {
                    NodeRef newNodeRef3 = RuleServiceCoverageTest.this.nodeService.createNode(RuleServiceCoverageTest.this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)RuleServiceCoverageTest.TEST_NAMESPACE, (String)"hasAspectAndValue"), ContentModel.TYPE_CONTENT, RuleServiceCoverageTest.this.getContentProperties()).getChildRef();
                    RuleServiceCoverageTest.this.addContentToNode(newNodeRef3);
                    HashMap<QName, NodeRef> catProps3 = new HashMap<QName, NodeRef>();
                    catProps3.put(CAT_PROP_QNAME, RuleServiceCoverageTest.this.catRTwo);
                    RuleServiceCoverageTest.this.nodeService.addAspect(newNodeRef3, RuleServiceCoverageTest.this.regionCategorisationQName, catProps3);
                    return newNodeRef3;
                }
            };
            NodeRef newNodeRef3 = this.transactionService.getRetryingTransactionHelper().doInTransaction(callback3);
            RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef3, ContentModel.ASPECT_VERSIONABLE));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void testLinkCategoryAction() {
        this.createTestCategories();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("category-aspect", (Serializable)this.regionCategorisationQName);
        params.put("category-value", (Serializable)this.catROne);
        Rule rule = this.createRule("inbound", "link-category", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"noAspect"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef2);
        PropertyDefinition catPropDef = this.dictionaryDAO.getProperty(CAT_PROP_QNAME);
        if (catPropDef == null) {
            // empty if block
        }
        Collection setValue = (Collection)((Object)this.nodeService.getProperty(newNodeRef2, CAT_PROP_QNAME));
        RuleServiceCoverageTest.assertNotNull((Object)setValue);
        RuleServiceCoverageTest.assertEquals((int)1, (int)setValue.size());
        RuleServiceCoverageTest.assertEquals((Object)this.catROne, (Object)setValue.toArray()[0]);
    }

    public void testMailAction() throws MessagingException, IOException {
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("to", (Serializable)((Object)"alfresco.test@gmail.com"));
        params.put("subject", (Serializable)((Object)"Unit test"));
        params.put("text", (Serializable)((Object)"This is a test to check that the mail action is working."));
        Rule rule = this.createRule("inbound", "mail", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        MailActionExecuter mailService = (MailActionExecuter)((ApplicationContextFactory)applicationContext.getBean("OutboundSMTP")).getApplicationContext().getBean("mail");
        mailService.setTestMode(true);
        mailService.clearLastTestMessage();
        NodeRef contentNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(contentNodeRef);
        MimeMessage lastMessage = mailService.retrieveLastTestMessage();
        RuleServiceCoverageTest.assertNotNull((String)"Message should have been sent", (Object)lastMessage);
        System.out.println("Sent email with subject: " + lastMessage.getSubject());
        System.out.println("Sent email with content: " + lastMessage.getContent());
    }

    public void testMailNotSentIfRollback() {
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("to", (Serializable)((Object)"alfresco.test@gmail.com"));
        params.put("subject", (Serializable)((Object)"testMailNotSentIfRollback()"));
        params.put("text", (Serializable)((Object)"This email should NOT have been sent."));
        Rule rule = this.createRule("inbound", "mail", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        String illegalName = "MyName.txt ";
        MailActionExecuter mailService = (MailActionExecuter)((ApplicationContextFactory)applicationContext.getBean("OutboundSMTP")).getApplicationContext().getBean("mail");
        mailService.setTestMode(true);
        mailService.clearLastTestMessage();
        try {
            this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, this.makeNameProperty(illegalName)).getChildRef();
            RuleServiceCoverageTest.fail((String)"createNode() should have failed.");
        }
        catch (IntegrityException e) {
            // empty catch block
        }
        MimeMessage lastMessage = mailService.retrieveLastTestMessage();
        RuleServiceCoverageTest.assertNull((String)"Message should NOT have been sent", (Object)lastMessage);
    }

    private Map<QName, Serializable> makeNameProperty(String name) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(1);
        properties.put(ContentModel.PROP_NAME, (Serializable)((Object)name));
        return properties;
    }

    public void testCopyAction() {
        String localName = this.getName() + System.currentTimeMillis();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("destination-folder", (Serializable)this.rootNodeRef);
        Rule rule = this.createRule("inbound", "copy", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)localName), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef);
        List origRefs = this.nodeService.getChildAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)TEST_NAMESPACE, (String)localName));
        RuleServiceCoverageTest.assertNotNull((Object)origRefs);
        RuleServiceCoverageTest.assertEquals((int)1, (int)origRefs.size());
        NodeRef origNodeRef = ((ChildAssociationRef)origRefs.get(0)).getChildRef();
        RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)origNodeRef);
        List copyChildAssocRefs = this.nodeService.getChildAssocs(this.rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)TEST_NAMESPACE, (String)localName));
        RuleServiceCoverageTest.assertNotNull((Object)copyChildAssocRefs);
        RuleServiceCoverageTest.assertEquals((int)1, (int)copyChildAssocRefs.size());
        NodeRef copyNodeRef = ((ChildAssociationRef)copyChildAssocRefs.get(0)).getChildRef();
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(copyNodeRef, ContentModel.ASPECT_COPIEDFROM));
        NodeRef source = this.copyService.getOriginal(copyNodeRef);
        RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)source);
    }

    public void testTransformAction() throws Throwable {
        ContentTransformer transformer = this.transformerRegistry.getTransformer("application/vnd.ms-excel", -1L, "text/plain", new TransformationOptions());
        if (transformer == null) {
            return;
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("mime-type", (Serializable)((Object)"text/plain"));
        params.put("destination-folder", (Serializable)this.rootNodeRef);
        params.put("assoc-type", (Serializable)ContentModel.ASSOC_CHILDREN);
        params.put("assoc-name", (Serializable)QName.createQName((String)TEST_NAMESPACE, (String)"transformed"));
        Rule rule = this.createRule("inbound", "transform", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, "test.xls");
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"origional"), ContentModel.TYPE_CONTENT, props).getChildRef();
        ContentWriter contentWriter = this.contentService.getWriter(newNodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("application/vnd.ms-excel");
        File testFile = AbstractContentTransformerTest.loadQuickTestFile("xls");
        contentWriter.putContent(testFile);
        tx.commit();
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)applicationContext.getBean("authenticationComponent");
        authenticationComponent.setCurrentUser(authenticationComponent.getSystemUserName());
        List origRefs = this.nodeService.getChildAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)TEST_NAMESPACE, (String)"origional"));
        RuleServiceCoverageTest.assertNotNull((Object)origRefs);
        RuleServiceCoverageTest.assertEquals((int)1, (int)origRefs.size());
        NodeRef origNodeRef = ((ChildAssociationRef)origRefs.get(0)).getChildRef();
        RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)origNodeRef);
        List copyChildAssocRefs = this.nodeService.getChildAssocs(this.rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)TEST_NAMESPACE, (String)"transformed"));
        RuleServiceCoverageTest.assertNotNull((Object)copyChildAssocRefs);
        RuleServiceCoverageTest.assertEquals((int)1, (int)copyChildAssocRefs.size());
        NodeRef copyNodeRef = ((ChildAssociationRef)copyChildAssocRefs.get(0)).getChildRef();
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(copyNodeRef, ContentModel.ASPECT_COPIEDFROM));
        NodeRef source = this.copyService.getOriginal(copyNodeRef);
        RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)source);
        ContentData contentData = (ContentData)this.nodeService.getProperty(copyNodeRef, ContentModel.PROP_CONTENT);
        RuleServiceCoverageTest.assertEquals((String)"text/plain", (String)contentData.getMimetype());
    }

    public void testImageTransformAction() throws Throwable {
        ContentTransformer transformer = this.transformerRegistry.getTransformer("image/gif", -1L, "image/jpeg", new TransformationOptions());
        if (transformer == null) {
            return;
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("destination-folder", (Serializable)this.rootNodeRef);
        params.put("assoc-type", (Serializable)ContentModel.ASSOC_CHILDREN);
        params.put("mime-type", (Serializable)((Object)"image/jpeg"));
        params.put("assoc-name", (Serializable)QName.createQName((String)TEST_NAMESPACE, (String)"transformed"));
        params.put("convert-command", (Serializable)((Object)"-negate"));
        Rule rule = this.createRule("inbound", "transform-image", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, "test.gif");
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"origional"), ContentModel.TYPE_CONTENT, props).getChildRef();
        ContentWriter contentWriter = this.contentService.getWriter(newNodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("image/gif");
        File testFile = AbstractContentTransformerTest.loadQuickTestFile("gif");
        contentWriter.putContent(testFile);
        tx.commit();
        List origRefs = this.nodeService.getChildAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)TEST_NAMESPACE, (String)"origional"));
        RuleServiceCoverageTest.assertNotNull((Object)origRefs);
        RuleServiceCoverageTest.assertEquals((int)1, (int)origRefs.size());
        NodeRef origNodeRef = ((ChildAssociationRef)origRefs.get(0)).getChildRef();
        RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)origNodeRef);
        List copyChildAssocRefs = this.nodeService.getChildAssocs(this.rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)TEST_NAMESPACE, (String)"transformed"));
        RuleServiceCoverageTest.assertNotNull((Object)copyChildAssocRefs);
        RuleServiceCoverageTest.assertEquals((int)1, (int)copyChildAssocRefs.size());
        NodeRef copyNodeRef = ((ChildAssociationRef)copyChildAssocRefs.get(0)).getChildRef();
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(copyNodeRef, ContentModel.ASPECT_COPIEDFROM));
        NodeRef source = this.copyService.getOriginal(copyNodeRef);
        RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)source);
    }

    public void testMoveAction() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("destination-folder", (Serializable)this.rootNodeRef);
        Rule rule = this.createRule("inbound", "move", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"origional"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(newNodeRef);
        List origRefs = this.nodeService.getChildAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)TEST_NAMESPACE, (String)"origional"));
        RuleServiceCoverageTest.assertNotNull((Object)origRefs);
        RuleServiceCoverageTest.assertEquals((int)0, (int)origRefs.size());
        List copyChildAssocRefs = this.nodeService.getChildAssocs(this.rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)TEST_NAMESPACE, (String)"origional"));
        RuleServiceCoverageTest.assertNotNull((Object)copyChildAssocRefs);
        RuleServiceCoverageTest.assertEquals((int)1, (int)copyChildAssocRefs.size());
        NodeRef movedNodeRef = ((ChildAssociationRef)copyChildAssocRefs.get(0)).getChildRef();
        RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)movedNodeRef);
    }

    public void testCheckOutAction() {
        Rule rule = this.createRule("inbound", "check-out", null, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = null;
        UserTransaction tx = this.transactionService.getUserTransaction();
        try {
            tx.begin();
            newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"checkout"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
            this.addContentToNode(newNodeRef);
            tx.commit();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        List children = this.nodeService.getChildAssocs(this.nodeRef);
        RuleServiceCoverageTest.assertNotNull((Object)children);
        RuleServiceCoverageTest.assertEquals((int)3, (int)children.size());
        for (ChildAssociationRef child : children) {
            NodeRef childNodeRef = child.getChildRef();
            if (childNodeRef.equals((Object)newNodeRef)) {
                LockStatus lockStatus = this.lockService.getLockStatus(childNodeRef);
                RuleServiceCoverageTest.assertEquals((Object)((Object)LockStatus.LOCK_OWNER), (Object)((Object)lockStatus));
                continue;
            }
            if (!this.nodeService.hasAspect(childNodeRef, ContentModel.ASPECT_WORKING_COPY)) continue;
            NodeRef copiedFromNodeRef = this.copyService.getOriginal(childNodeRef);
            RuleServiceCoverageTest.assertEquals((Object)newNodeRef, (Object)copiedFromNodeRef);
        }
    }

    public void testCheckInAction() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("description", (Serializable)((Object)"The version description."));
        Rule rule = this.createRule("inbound", "check-in", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        List<NodeRef> list = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

            @Override
            public List<NodeRef> execute() {
                NodeRef newNodeRef = RuleServiceCoverageTest.this.nodeService.createNode(RuleServiceCoverageTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)RuleServiceCoverageTest.TEST_NAMESPACE, (String)"origional"), ContentModel.TYPE_CONTENT, RuleServiceCoverageTest.this.getContentProperties()).getChildRef();
                NodeRef workingCopy = RuleServiceCoverageTest.this.cociService.checkout(newNodeRef);
                RuleServiceCoverageTest.this.nodeService.moveNode(workingCopy, RuleServiceCoverageTest.this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)RuleServiceCoverageTest.TEST_NAMESPACE, (String)"moved"));
                ArrayList<NodeRef> result = new ArrayList<NodeRef>();
                result.add(newNodeRef);
                result.add(workingCopy);
                return result;
            }
        });
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.exists(list.get(1)));
        RuleServiceCoverageTest.assertEquals((Object)((Object)LockStatus.NO_LOCK), (Object)((Object)this.lockService.getLockStatus(list.get(0))));
    }

    public void testRulesDisabled() {
        HashMap<String, Serializable> actionParams = new HashMap<String, Serializable>(1);
        actionParams.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("inbound", "add-features", actionParams, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> noRulesWork = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                RuleServiceCoverageTest.this.ruleService.disableRules(RuleServiceCoverageTest.this.nodeRef);
                NodeRef newNodeRef = RuleServiceCoverageTest.this.nodeService.createNode(RuleServiceCoverageTest.this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)RuleServiceCoverageTest.TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, RuleServiceCoverageTest.this.getContentProperties()).getChildRef();
                RuleServiceCoverageTest.this.addContentToNode(newNodeRef);
                return newNodeRef;
            }
        };
        NodeRef newNodeRef = this.transactionService.getRetryingTransactionHelper().doInTransaction(noRulesWork);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> withRulesWork = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                NodeRef newNodeRef2 = RuleServiceCoverageTest.this.nodeService.createNode(RuleServiceCoverageTest.this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)RuleServiceCoverageTest.TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, RuleServiceCoverageTest.this.getContentProperties()).getChildRef();
                RuleServiceCoverageTest.this.addContentToNode(newNodeRef2);
                return newNodeRef2;
            }
        };
        NodeRef newNodeRef2 = this.transactionService.getRetryingTransactionHelper().doInTransaction(withRulesWork);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef2, ContentModel.ASPECT_VERSIONABLE));
    }

    private void addContentToNode(NodeRef nodeRef) {
        ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        RuleServiceCoverageTest.assertNotNull((Object)contentWriter);
        contentWriter.putContent(STANDARD_TEXT_CONTENT + System.currentTimeMillis());
    }

    public void testCheckMandatoryProperties() {
        HashMap<String, Serializable> actionParams = new HashMap<String, Serializable>(1);
        actionParams.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        HashMap<String, Serializable> condParams = new HashMap<String, Serializable>(1);
        Rule rule = this.createRule("inbound", "add-features", actionParams, "compare-property-value", condParams);
        this.ruleService.saveRule(this.nodeRef, rule);
        try {
            Map<QName, Serializable> props2 = this.getContentProperties();
            props2.put(ContentModel.PROP_NAME, (Serializable)((Object)"bobbins.doc"));
            NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, props2).getChildRef();
            this.addContentToNode(newNodeRef2);
            RuleServiceCoverageTest.fail((String)"An exception should have been thrown since a mandatory parameter was missing from the condition.");
        }
        catch (Throwable ruleServiceException) {
            // empty catch block
        }
    }

    public void testContainsTextCondition() {
        HashMap<String, Serializable> actionParams = new HashMap<String, Serializable>(1);
        actionParams.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        HashMap<String, Serializable> condParams = new HashMap<String, Serializable>(1);
        condParams.put("value", (Serializable)((Object)".doc"));
        Rule rule = this.createRule("inbound", "add-features", actionParams, "compare-property-value", condParams);
        this.ruleService.saveRule(this.nodeRef, rule);
        HashMap<QName, String> props1 = new HashMap<QName, String>();
        props1.put(ContentModel.PROP_NAME, "bobbins.txt");
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, props1).getChildRef();
        this.addContentToNode(newNodeRef);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        HashMap<QName, String> props2 = new HashMap<QName, String>();
        props2.put(ContentModel.PROP_NAME, "bobbins.doc");
        NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, props2).getChildRef();
        this.addContentToNode(newNodeRef2);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef2, ContentModel.ASPECT_VERSIONABLE));
        try {
            NodeRef newNodeRef3 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
            this.addContentToNode(newNodeRef3);
        }
        catch (RuleServiceException exception) {
            // empty catch block
        }
        HashMap<String, Serializable> condParamsBegins = new HashMap<String, Serializable>(1);
        condParamsBegins.put("value", (Serializable)((Object)"bob*"));
        rule.getAction().removeAllActionConditions();
        ActionCondition condition1 = this.actionService.createActionCondition("compare-property-value", condParamsBegins);
        rule.getAction().addActionCondition(condition1);
        this.ruleService.saveRule(this.nodeRef, rule);
        HashMap<QName, String> propsx = new HashMap<QName, String>();
        propsx.put(ContentModel.PROP_NAME, "mybobbins.doc");
        NodeRef newNodeRefx = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, propsx).getChildRef();
        this.addContentToNode(newNodeRefx);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRefx, ContentModel.ASPECT_VERSIONABLE));
        HashMap<QName, String> propsy = new HashMap<QName, String>();
        propsy.put(ContentModel.PROP_NAME, "bobbins.doc");
        NodeRef newNodeRefy = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, propsy).getChildRef();
        this.addContentToNode(newNodeRefy);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRefy, ContentModel.ASPECT_VERSIONABLE));
        HashMap<String, Serializable> condParamsEnds = new HashMap<String, Serializable>(1);
        condParamsEnds.put("value", (Serializable)((Object)"*s.doc"));
        rule.getAction().removeAllActionConditions();
        ActionCondition condition2 = this.actionService.createActionCondition("compare-property-value", condParamsEnds);
        rule.getAction().addActionCondition(condition2);
        this.ruleService.saveRule(this.nodeRef, rule);
        HashMap<QName, String> propsa = new HashMap<QName, String>();
        propsa.put(ContentModel.PROP_NAME, "bobbins.document");
        NodeRef newNodeRefa = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, propsa).getChildRef();
        this.addContentToNode(newNodeRefa);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRefa, ContentModel.ASPECT_VERSIONABLE));
        HashMap<QName, String> propsb = new HashMap<QName, String>();
        propsb.put(ContentModel.PROP_NAME, "bobbins.doc");
        NodeRef newNodeRefb = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT, propsb).getChildRef();
        this.addContentToNode(newNodeRefb);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRefb, ContentModel.ASPECT_VERSIONABLE));
    }

    public void testInboundRuleType() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("inbound", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTAINER).getChildRef();
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        NodeRef contentNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT).getChildRef();
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.addContentToNode(contentNodeRef);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
        NodeRef moveNode = this.nodeService.createNode(newNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT).getChildRef();
        this.addContentToNode(moveNode);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(moveNode, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.moveNode(moveNode, this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"));
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(moveNode, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.removeAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"name.txt"));
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.addContentToNode(contentNodeRef);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
    }

    public void testUpdateRuleType() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("update", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.removeAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.setProperty(newNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"testName"));
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        NodeRef contentNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.removeAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.addContentToNode(contentNodeRef);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.addContentToNode(contentNodeRef);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE));
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, "testName");
        NodeRef nodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_FOLDER, props).getChildRef();
        this.nodeService.removeAspect(nodeRef2, ContentModel.ASPECT_VERSIONABLE);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(nodeRef2, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.setProperty(nodeRef2, ContentModel.PROP_NAME, (Serializable)((Object)"testName"));
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(nodeRef2, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.setProperty(nodeRef2, ContentModel.PROP_NAME, (Serializable)((Object)"testName2"));
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef2, ContentModel.ASPECT_VERSIONABLE));
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                HashMap<QName, String> props = new HashMap<QName, String>(1);
                props.put(ContentModel.PROP_NAME, "testName");
                NodeRef nodeRef3 = RuleServiceCoverageTest.this.nodeService.createNode(RuleServiceCoverageTest.this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)RuleServiceCoverageTest.TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_FOLDER, props).getChildRef();
                Assert.assertFalse((boolean)RuleServiceCoverageTest.this.nodeService.hasAspect(nodeRef3, ContentModel.ASPECT_VERSIONABLE));
                RuleServiceCoverageTest.this.nodeService.setProperty(nodeRef3, ContentModel.PROP_NAME, (Serializable)((Object)"testName2"));
                Assert.assertFalse((boolean)RuleServiceCoverageTest.this.nodeService.hasAspect(nodeRef3, ContentModel.ASPECT_VERSIONABLE));
                return null;
            }
        });
    }

    public void testAssociationUpdateRule() {
        NodeRef sourceFolder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}sourceFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("update", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(sourceFolder, rule);
        NodeRef testNodeOneRef = this.nodeService.createNode(sourceFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)TEST_NAMESPACE, (String)"original1"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(testNodeOneRef);
        NodeRef testNodeTwoRef = this.nodeService.createNode(sourceFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)TEST_NAMESPACE, (String)"original2"), ContentModel.TYPE_CONTENT, this.getContentProperties()).getChildRef();
        this.addContentToNode(testNodeTwoRef);
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(testNodeOneRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.addAspect(testNodeOneRef, ContentModel.ASPECT_REFERENCING, null);
        this.nodeService.createAssociation(testNodeOneRef, testNodeTwoRef, ContentModel.ASSOC_REFERENCES);
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(testNodeOneRef, ContentModel.ASPECT_VERSIONABLE));
    }

    public void testOutboundRuleType() {
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        Rule rule = this.createRule("outbound", "add-features", params, "no-condition", null);
        this.ruleService.saveRule(this.nodeRef, rule);
        NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTAINER).getChildRef();
        RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.moveNode(newNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"));
        RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(newNodeRef, ContentModel.ASPECT_VERSIONABLE));
        NodeRef newNodeRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.deleteNode(newNodeRef2);
    }

    public void xtestPerformanceOfRuleExecution() {
        try {
            StopWatch sw = new StopWatch();
            sw.start("create nodes with no rule executed");
            UserTransaction userTransaction1 = this.transactionService.getUserTransaction();
            userTransaction1.begin();
            for (int i = 0; i < 100; ++i) {
                this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTAINER).getChildRef();
                RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
            }
            userTransaction1.commit();
            sw.stop();
            HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
            params.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
            Rule rule = this.createRule("inbound", "add-features", params, "no-condition", null);
            this.ruleService.saveRule(this.nodeRef, rule);
            sw.start("create nodes with one rule run (apply versionable aspect)");
            UserTransaction userTransaction2 = this.transactionService.getUserTransaction();
            userTransaction2.begin();
            NodeRef[] nodeRefs = new NodeRef[100];
            for (int i = 0; i < 100; ++i) {
                NodeRef nodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"children"), ContentModel.TYPE_CONTAINER).getChildRef();
                this.addContentToNode(nodeRef);
                nodeRefs[i] = nodeRef;
                RuleServiceCoverageTest.assertFalse((boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE));
            }
            userTransaction2.commit();
            sw.stop();
            for (NodeRef ref : nodeRefs) {
                RuleServiceCoverageTest.assertTrue((boolean)this.nodeService.hasAspect(ref, ContentModel.ASPECT_VERSIONABLE));
            }
            System.out.println(sw.prettyPrint());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void testAsyncExecutionWithPotentialLoop() {
        if (this.transformerRegistry.getTransformer("application/vnd.ms-excel", -1L, "text/plain", new TransformationOptions()) != null) {
            try {
                HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
                params.put("mime-type", (Serializable)((Object)"text/plain"));
                params.put("destination-folder", (Serializable)this.nodeRef);
                params.put("assoc-type", (Serializable)ContentModel.ASSOC_CONTAINS);
                params.put("assoc-name", (Serializable)QName.createQName((String)TEST_NAMESPACE, (String)"transformed"));
                Rule rule = this.createRule("inbound", "transform", params, "no-condition", null);
                rule.setExecuteAsynchronously(true);
                rule.setTitle("Transform document to text");
                UserTransaction tx0 = this.transactionService.getUserTransaction();
                tx0.begin();
                this.ruleService.saveRule(this.nodeRef, rule);
                tx0.commit();
                UserTransaction tx = this.transactionService.getUserTransaction();
                tx.begin();
                HashMap<QName, String> props = new HashMap<QName, String>(1);
                props.put(ContentModel.PROP_NAME, "test.xls");
                NodeRef newNodeRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)"origional"), ContentModel.TYPE_CONTENT, props).getChildRef();
                ContentWriter contentWriter = this.contentService.getWriter(newNodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter.setMimetype("application/vnd.ms-excel");
                File testFile = AbstractContentTransformerTest.loadQuickTestFile("xls");
                contentWriter.putContent(testFile);
                tx.commit();
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

