/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class SearchServiceTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuthenticationComponent authenticationComponent;
    private MutableAuthenticationService authenticationService;
    private MutableAuthenticationDao authenticationDAO;
    private UserTransaction tx;
    private SearchService pubSearchService;
    private NodeRef rootNodeRef;
    private NodeRef n1;
    private NodeRef n2;
    private NodeRef n3;
    private NodeRef n4;
    private NodeRef n6;
    private NodeRef n5;
    private NodeRef n7;
    private NodeRef n8;
    private NodeRef n9;
    private NodeRef n10;
    private NodeService nodeService;
    private PermissionService pubPermissionService;

    public void setUp() throws Exception {
        this.nodeService = (NodeService)ctx.getBean("dbNodeService");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("authenticationService");
        this.authenticationDAO = (MutableAuthenticationDao)ctx.getBean("authenticationDao");
        this.pubSearchService = (SearchService)ctx.getBean("SearchService");
        this.pubPermissionService = (PermissionService)ctx.getBean("PermissionService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        TransactionService transactionService = (TransactionService)ctx.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        this.tx = transactionService.getUserTransaction();
        this.tx.begin();
        if (!this.authenticationDAO.userExists("andy")) {
            this.authenticationService.createAuthentication("andy", "andy".toCharArray());
        }
        if (!this.authenticationDAO.userExists(AuthenticationUtil.getAdminUserName())) {
            this.authenticationService.createAuthentication(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        }
        if (!this.authenticationDAO.userExists("administrator")) {
            this.authenticationService.createAuthentication("administrator", "administrator".toCharArray());
        }
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}01"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.pubPermissionService.setPermission(this.n1, "andy", "Read", true);
        this.n2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}02"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.pubPermissionService.setPermission(this.n2, "andy", "Read", true);
        this.n3 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}03"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.pubPermissionService.setPermission(this.n3, "andy", "Read", true);
        this.n4 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}04"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.pubPermissionService.setPermission(this.n4, "andy", "Read", true);
        this.n5 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}05"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.pubPermissionService.setPermission(this.n5, "andy", "Read", true);
        this.n6 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}06"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n7 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}07"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n8 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}08"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n9 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}09"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n10 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}10"), ContentModel.TYPE_CONTAINER).getChildRef();
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        this.tx.rollback();
        super.tearDown();
    }

    public void testAdmim() {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//*\"");
        sp.addStore(this.rootNodeRef.getStoreRef());
        ResultSet results = this.pubSearchService.query(sp);
        SearchServiceTest.assertEquals((int)10, (int)results.length());
        SearchServiceTest.assertNotNull((Object)results.getResultSetMetaData());
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getLimitedBy(), (Object)LimitBy.UNLIMITED);
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getPermissionEvaluationMode(), (Object)PermissionEvaluationMode.EAGER);
        results.close();
        sp.setLimitBy(LimitBy.FINAL_SIZE);
        sp.setLimit(20);
        results = this.pubSearchService.query(sp);
        SearchServiceTest.assertEquals((int)results.length(), (int)10);
        SearchServiceTest.assertNotNull((Object)results.getResultSetMetaData());
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getLimitedBy(), (Object)LimitBy.UNLIMITED);
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getPermissionEvaluationMode(), (Object)PermissionEvaluationMode.EAGER);
        results.close();
        sp.setLimitBy(LimitBy.FINAL_SIZE);
        sp.setLimit(10);
        results = this.pubSearchService.query(sp);
        SearchServiceTest.assertEquals((int)results.length(), (int)10);
        SearchServiceTest.assertNotNull((Object)results.getResultSetMetaData());
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getLimitedBy(), (Object)LimitBy.UNLIMITED);
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getPermissionEvaluationMode(), (Object)PermissionEvaluationMode.EAGER);
        results.close();
        sp.setLimitBy(LimitBy.FINAL_SIZE);
        sp.setLimit(9);
        results = this.pubSearchService.query(sp);
        SearchServiceTest.assertEquals((int)results.length(), (int)9);
        SearchServiceTest.assertNotNull((Object)results.getResultSetMetaData());
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getLimitedBy(), (Object)LimitBy.FINAL_SIZE);
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getPermissionEvaluationMode(), (Object)PermissionEvaluationMode.EAGER);
        results.close();
        sp.setLimitBy(LimitBy.FINAL_SIZE);
        sp.setLimit(5);
        results = this.pubSearchService.query(sp);
        SearchServiceTest.assertEquals((int)results.length(), (int)5);
        SearchServiceTest.assertNotNull((Object)results.getResultSetMetaData());
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getLimitedBy(), (Object)LimitBy.FINAL_SIZE);
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getPermissionEvaluationMode(), (Object)PermissionEvaluationMode.EAGER);
        results.close();
    }

    public void testAndy() {
        this.authenticationComponent.setCurrentUser("andy");
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//*\"");
        sp.addStore(this.rootNodeRef.getStoreRef());
        ResultSet results = this.pubSearchService.query(sp);
        SearchServiceTest.assertEquals((int)results.length(), (int)5);
        SearchServiceTest.assertNotNull((Object)results.getResultSetMetaData());
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getLimitedBy(), (Object)LimitBy.UNLIMITED);
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getPermissionEvaluationMode(), (Object)PermissionEvaluationMode.EAGER);
        results.close();
        sp.setLimitBy(LimitBy.FINAL_SIZE);
        sp.setLimit(20);
        results = this.pubSearchService.query(sp);
        SearchServiceTest.assertEquals((int)results.length(), (int)5);
        SearchServiceTest.assertNotNull((Object)results.getResultSetMetaData());
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getLimitedBy(), (Object)LimitBy.UNLIMITED);
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getPermissionEvaluationMode(), (Object)PermissionEvaluationMode.EAGER);
        results.close();
        sp.setLimitBy(LimitBy.FINAL_SIZE);
        sp.setLimit(5);
        results = this.pubSearchService.query(sp);
        SearchServiceTest.assertEquals((int)results.length(), (int)5);
        SearchServiceTest.assertNotNull((Object)results.getResultSetMetaData());
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getLimitedBy(), (Object)LimitBy.UNLIMITED);
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getPermissionEvaluationMode(), (Object)PermissionEvaluationMode.EAGER);
        results.close();
        sp.setLimitBy(LimitBy.FINAL_SIZE);
        sp.setLimit(4);
        results = this.pubSearchService.query(sp);
        SearchServiceTest.assertEquals((int)results.length(), (int)4);
        SearchServiceTest.assertNotNull((Object)results.getResultSetMetaData());
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getLimitedBy(), (Object)LimitBy.FINAL_SIZE);
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getPermissionEvaluationMode(), (Object)PermissionEvaluationMode.EAGER);
        results.close();
        sp.setLimitBy(LimitBy.FINAL_SIZE);
        sp.setLimit(2);
        results = this.pubSearchService.query(sp);
        SearchServiceTest.assertEquals((int)results.length(), (int)2);
        SearchServiceTest.assertNotNull((Object)results.getResultSetMetaData());
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getLimitedBy(), (Object)LimitBy.FINAL_SIZE);
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getPermissionEvaluationMode(), (Object)PermissionEvaluationMode.EAGER);
        results.close();
    }
}

