/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.noindex;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.alfresco.error.StackTraceUtil;
import org.alfresco.repo.search.EmptyResultSet;
import org.alfresco.repo.search.impl.NodeSearcher;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.XPathException;
import org.alfresco.service.cmr.search.QueryParameter;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NoIndexSearchService
implements SearchService {
    private static Log s_logger = LogFactory.getLog(NoIndexSearchService.class);
    private NodeService nodeService;
    private DictionaryService dictionaryService;

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public ResultSet query(StoreRef store, String language, String query) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("query   store = " + store + "   language = " + language + "   query = " + query));
        }
        this.trace();
        return new EmptyResultSet();
    }

    private void trace() {
        if (s_logger.isTraceEnabled()) {
            Exception e = new Exception();
            e.fillInStackTrace();
            StringBuilder sb = new StringBuilder(1024);
            StackTraceUtil.buildStackTrace((String)"Search trace ...", (StackTraceElement[])e.getStackTrace(), (StringBuilder)sb, (int)-1);
            s_logger.trace((Object)sb);
        }
    }

    public ResultSet query(StoreRef store, String language, String query, QueryParameterDefinition[] queryParameterDefinitions) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("query   store = " + store + "   language = " + language + "   query = " + query + "   queryParameterDefinitions = " + Arrays.toString(queryParameterDefinitions)));
        }
        this.trace();
        return new EmptyResultSet();
    }

    public ResultSet query(StoreRef store, QName queryId, QueryParameter[] queryParameters) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("query   store = " + store + "   queryId = " + queryId + "   queryParameters = " + Arrays.toString(queryParameters)));
        }
        this.trace();
        return new EmptyResultSet();
    }

    public ResultSet query(SearchParameters searchParameters) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("query   searchParameters = " + searchParameters));
        }
        this.trace();
        return new EmptyResultSet();
    }

    public List<NodeRef> selectNodes(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks) throws InvalidNodeRefException, XPathException {
        return this.selectNodes(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, "xpath");
    }

    public List<NodeRef> selectNodes(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks, String language) throws InvalidNodeRefException, XPathException {
        NodeSearcher nodeSearcher = new NodeSearcher(this.nodeService, this.dictionaryService, this);
        return nodeSearcher.selectNodes(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, language);
    }

    public List<Serializable> selectProperties(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks) throws InvalidNodeRefException, XPathException {
        return this.selectProperties(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, "xpath");
    }

    public List<Serializable> selectProperties(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks, String language) throws InvalidNodeRefException, XPathException {
        NodeSearcher nodeSearcher = new NodeSearcher(this.nodeService, this.dictionaryService, this);
        return nodeSearcher.selectProperties(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, language);
    }

    public boolean contains(NodeRef nodeRef, QName propertyQName, String googleLikePattern) throws InvalidNodeRefException {
        return this.contains(nodeRef, propertyQName, googleLikePattern, SearchParameters.Operator.OR);
    }

    public boolean contains(NodeRef nodeRef, QName propertyQName, String googleLikePattern, SearchParameters.Operator defaultOperator) throws InvalidNodeRefException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("contains   nodeRef = " + nodeRef + "   propertyQName = " + propertyQName + "   googleLikePattern = " + googleLikePattern + "   defaultOperator = " + defaultOperator));
        }
        this.trace();
        return false;
    }

    public boolean like(NodeRef nodeRef, QName propertyQName, String sqlLikePattern, boolean includeFTS) throws InvalidNodeRefException {
        if (includeFTS) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("contains   nodeRef = " + nodeRef + "   propertyQName = " + propertyQName + "   sqlLikePattern = " + sqlLikePattern + "   includeFTS = " + includeFTS));
            }
            this.trace();
        }
        return false;
    }
}

