/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.transaction;

import java.io.UnsupportedEncodingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.alfresco.repo.search.transaction.XidException;
import org.alfresco.repo.search.transaction.XidTransaction;
import org.alfresco.util.GUID;

public class SimpleTransaction
implements XidTransaction {
    private static final int DEFAULT_TIMEOUT = 600;
    private boolean isRollBackOnly;
    private int timeout;
    public static final int FORMAT_ID = 12321;
    private static final String CHAR_SET = "UTF-8";
    private byte[] globalTransactionId;
    private byte[] branchQualifier;
    private String guid;
    private static ThreadLocal<SimpleTransaction> transaction = new ThreadLocal();

    private SimpleTransaction(int timeout) {
        this.timeout = timeout;
        this.guid = GUID.generate();
        try {
            this.globalTransactionId = this.guid.getBytes(CHAR_SET);
        }
        catch (UnsupportedEncodingException e) {
            throw new XidException(e);
        }
        this.branchQualifier = new byte[0];
    }

    private SimpleTransaction() {
        this(600);
    }

    public static SimpleTransaction getTransaction() {
        return transaction.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        try {
            if (this.isRollBackOnly) {
                throw new RollbackException("Commit failed: Transaction marked for rollback");
            }
        }
        finally {
            transaction.set(null);
        }
    }

    public boolean delistResource(XAResource arg0, int arg1) throws IllegalStateException, SystemException {
        throw new UnsupportedOperationException();
    }

    public boolean enlistResource(XAResource arg0) throws RollbackException, IllegalStateException, SystemException {
        throw new UnsupportedOperationException();
    }

    public int getStatus() throws SystemException {
        throw new UnsupportedOperationException();
    }

    public void registerSynchronization(Synchronization arg0) throws RollbackException, IllegalStateException, SystemException {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws IllegalStateException, SystemException {
        throw new UnsupportedOperationException();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.isRollBackOnly = true;
    }

    static SimpleTransaction suspend() {
        SimpleTransaction tx = SimpleTransaction.getTransaction();
        transaction.set(null);
        return tx;
    }

    static void begin() throws NotSupportedException {
        if (SimpleTransaction.getTransaction() != null) {
            throw new NotSupportedException("Nested transactions are not supported");
        }
        transaction.set(new SimpleTransaction());
    }

    static void resume(SimpleTransaction tx) {
        if (SimpleTransaction.getTransaction() != null) {
            throw new IllegalStateException("A transaction is already associated with the thread");
        }
        transaction.set(tx);
    }

    public String getGUID() {
        return this.guid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleTransaction)) {
            return false;
        }
        SimpleTransaction other = (SimpleTransaction)o;
        return this.getGUID().equals(other.getGUID());
    }

    public int hashCode() {
        return this.getGUID().hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("Simple Transaction GUID = " + this.getGUID());
        return buffer.toString();
    }

    @Override
    public int getFormatId() {
        return 12321;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }
}

