/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.security.authority.AuthorityInfo;
import org.alfresco.repo.security.authority.AuthorityInfoEntity;
import org.alfresco.repo.security.authority.GetAuthoritiesCannedQueryParams;
import org.alfresco.repo.security.permissions.impl.acegi.AbstractCannedQueryPermissions;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetAuthoritiesCannedQuery
extends AbstractCannedQueryPermissions<AuthorityInfo> {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String QUERY_NAMESPACE = "alfresco.query.authorities";
    private static final String QUERY_SELECT_GET_AUTHORITIES = "select_GetAuthoritiesCannedQuery";
    private CannedQueryDAO cannedQueryDAO;
    private TenantService tenantService;

    public GetAuthoritiesCannedQuery(CannedQueryDAO cannedQueryDAO, TenantService tenantService, MethodSecurityBean<AuthorityInfo> methodSecurity, CannedQueryParameters params) {
        super(params, methodSecurity);
        this.cannedQueryDAO = cannedQueryDAO;
        this.tenantService = tenantService;
    }

    protected List<AuthorityInfo> queryAndFilter(CannedQueryParameters parameters) {
        Long start = this.logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        GetAuthoritiesCannedQueryParams params = (GetAuthoritiesCannedQueryParams)parameters.getParameterBean();
        final AuthorityType type = params.getType();
        final String nameFilter = params.getDisplayNameFilter();
        final ArrayList<AuthorityInfo> auths = new ArrayList<AuthorityInfo>(100);
        QueryCallback callback = new QueryCallback(){

            @Override
            public boolean handle(AuthorityInfo auth) {
                if (GetAuthoritiesCannedQuery.this.includeFilter(auth, type, nameFilter)) {
                    auths.add(auth);
                }
                return true;
            }
        };
        ResultHandler resultHandler = new ResultHandler(callback);
        this.cannedQueryDAO.executeQuery(QUERY_NAMESPACE, QUERY_SELECT_GET_AUTHORITIES, params, 0, Integer.MAX_VALUE, resultHandler);
        resultHandler.done();
        if (start != null) {
            this.logger.debug((Object)("Base query: " + auths.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return auths;
    }

    protected boolean isApplyPostQuerySorting() {
        return true;
    }

    protected List<AuthorityInfo> applyPostQuerySorting(List<AuthorityInfo> results, CannedQuerySortDetails sortDetails) {
        List sortPairs = sortDetails.getSortPairs();
        if (sortPairs.size() > 0) {
            Collections.sort(results, new AuthComparator((CannedQuerySortDetails.SortOrder)((Pair)sortPairs.get(0)).getSecond()));
        }
        return results;
    }

    private boolean includeFilter(AuthorityInfo auth, AuthorityType type, String nameFilterLower) {
        String authDisplayNameLower;
        String authName = auth.getAuthorityName();
        AuthorityType authType = AuthorityType.getAuthorityType((String)authName);
        if (authName == null || type != null && !type.equals((Object)authType)) {
            return false;
        }
        if (nameFilterLower == null) {
            return true;
        }
        String string = authDisplayNameLower = auth.getAuthorityDisplayName() != null ? auth.getAuthorityDisplayName().toLowerCase() : null;
        if (authDisplayNameLower != null && authDisplayNameLower.startsWith(nameFilterLower)) {
            return true;
        }
        if (authType.isPrefixed()) {
            authName = authName.substring(authType.getPrefixString().length());
        }
        return authName.toLowerCase().startsWith(nameFilterLower);
    }

    private class ResultHandler
    implements CannedQueryDAO.ResultHandler<AuthorityInfoEntity> {
        private final QueryCallback resultsCallback;
        private boolean more = true;

        private ResultHandler(QueryCallback resultsCallback) {
            this.resultsCallback = resultsCallback;
        }

        @Override
        public boolean handleResult(AuthorityInfoEntity result) {
            if (!this.more) {
                return false;
            }
            boolean more = this.resultsCallback.handle(new AuthorityInfo(GetAuthoritiesCannedQuery.this.tenantService.getBaseName(result.getNode().getNodeRef()), result.getAuthorityDisplayName(), result.getAuthorityName()));
            if (!more) {
                this.more = false;
            }
            return more;
        }

        public void done() {
        }
    }

    private static interface QueryCallback {
        public boolean handle(AuthorityInfo var1);
    }

    private class AuthComparator
    implements Comparator<AuthorityInfo> {
        private CannedQuerySortDetails.SortOrder sortOrder;
        private Collator collator;

        public AuthComparator(CannedQuerySortDetails.SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            this.collator = Collator.getInstance();
        }

        @Override
        public int compare(AuthorityInfo auth1In, AuthorityInfo auth2In) {
            AuthorityInfo auth1 = auth1In;
            AuthorityInfo auth2 = auth2In;
            if (this.sortOrder.equals((Object)CannedQuerySortDetails.SortOrder.DESCENDING)) {
                auth1 = auth2In;
                auth2 = auth1In;
            }
            String s1 = auth1.getAuthorityDisplayName();
            String s2 = auth2.getAuthorityDisplayName();
            if (s1 == null) {
                s1 = auth1.getAuthorityName();
            }
            if (s2 == null) {
                s2 = auth1.getAuthorityName();
            }
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            if (s2 == null) {
                return 1;
            }
            return this.collator.compare(s1, s2);
        }
    }
}

