/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.security.PublicServiceAccessService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class AbstractPermissionTest
extends TestCase {
    private static ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
    protected static final String ROLE_AUTHENTICATED = "ROLE_AUTHENTICATED";
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected PermissionServiceSPI permissionService;
    protected MutableAuthenticationService authenticationService;
    private MutableAuthenticationDao authenticationDAO;
    protected LocalSessionFactoryBean sessionFactory;
    protected NodeRef rootNodeRef;
    protected NamespacePrefixResolver namespacePrefixResolver;
    protected ServiceRegistry serviceRegistry;
    protected NodeRef systemNodeRef;
    protected AuthenticationComponent authenticationComponent;
    protected ModelDAO permissionModelDAO;
    protected PersonService personService;
    protected AuthorityService authorityService;
    protected AuthorityDAO authorityDAO;
    protected NodeDAO nodeDAO;
    protected AclDAO aclDaoComponent;
    protected RetryingTransactionHelper retryingTransactionHelper;
    private TransactionService transactionService;
    private UserTransaction testTX;
    protected PermissionServiceImpl permissionServiceImpl;
    protected PublicServiceAccessService publicServiceAccessService;

    public void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new AlfrescoRuntimeException("A previous tests did not clean up transaction: " + AlfrescoTransactionSupport.getTransactionId());
        }
        this.nodeService = (NodeService)applicationContext.getBean("nodeService");
        this.dictionaryService = (DictionaryService)applicationContext.getBean(ServiceRegistry.DICTIONARY_SERVICE.getLocalName());
        this.permissionService = (PermissionServiceSPI)applicationContext.getBean("permissionService");
        this.permissionServiceImpl = (PermissionServiceImpl)applicationContext.getBean("permissionServiceImpl");
        this.namespacePrefixResolver = (NamespacePrefixResolver)applicationContext.getBean(ServiceRegistry.NAMESPACE_SERVICE.getLocalName());
        this.authenticationService = (MutableAuthenticationService)applicationContext.getBean("authenticationService");
        this.authenticationComponent = (AuthenticationComponent)applicationContext.getBean("authenticationComponent");
        this.serviceRegistry = (ServiceRegistry)applicationContext.getBean("ServiceRegistry");
        this.permissionModelDAO = (ModelDAO)applicationContext.getBean("permissionsModelDAO");
        this.personService = (PersonService)applicationContext.getBean("personService");
        this.authorityService = (AuthorityService)applicationContext.getBean("authorityService");
        this.authorityDAO = (AuthorityDAO)applicationContext.getBean("authorityDAO");
        this.authenticationComponent.setCurrentUser(this.authenticationComponent.getSystemUserName());
        this.authenticationDAO = (MutableAuthenticationDao)applicationContext.getBean("authenticationDao");
        this.nodeDAO = (NodeDAO)applicationContext.getBean("nodeDAO");
        this.aclDaoComponent = (AclDAO)applicationContext.getBean("aclDAO");
        this.publicServiceAccessService = (PublicServiceAccessService)applicationContext.getBean("publicServiceAccessService");
        this.retryingTransactionHelper = (RetryingTransactionHelper)applicationContext.getBean("retryingTransactionHelper");
        this.transactionService = (TransactionService)applicationContext.getBean("transactionComponent");
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.nanoTime());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        QName children = ContentModel.ASSOC_CHILDREN;
        QName system = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"system");
        QName container = ContentModel.TYPE_CONTAINER;
        QName types = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"people");
        this.systemNodeRef = this.nodeService.createNode(this.rootNodeRef, children, system, container).getChildRef();
        NodeRef typesNodeRef = this.nodeService.createNode(this.systemNodeRef, children, types, container).getChildRef();
        Map<QName, Serializable> props = this.createPersonProperties("andy");
        this.nodeService.createNode(typesNodeRef, children, ContentModel.TYPE_PERSON, container, props).getChildRef();
        props = this.createPersonProperties("lemur");
        this.nodeService.createNode(typesNodeRef, children, ContentModel.TYPE_PERSON, container, props).getChildRef();
        if (this.authenticationDAO.userExists("andy")) {
            this.authenticationService.deleteAuthentication("andy");
        }
        this.authenticationService.createAuthentication("andy", "andy".toCharArray());
        if (this.authenticationDAO.userExists("lemur")) {
            this.authenticationService.deleteAuthentication("lemur");
        }
        this.authenticationService.createAuthentication("lemur", "lemur".toCharArray());
        if (this.authenticationDAO.userExists(AuthenticationUtil.getAdminUserName())) {
            this.authenticationService.deleteAuthentication(AuthenticationUtil.getAdminUserName());
        }
        this.authenticationService.createAuthentication(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        AbstractPermissionTest.assertTrue((boolean)this.permissionServiceImpl.getAnyDenyDenies());
    }

    protected void tearDown() throws Exception {
        try {
            this.testTX.rollback();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    protected void runAs(String userName) {
        this.authenticationService.authenticate(userName, userName.toCharArray());
        AbstractPermissionTest.assertNotNull((Object)this.authenticationService.getCurrentUserName());
    }

    private Map<QName, Serializable> createPersonProperties(String userName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        return properties;
    }

    protected PermissionReference getPermission(String permission) {
        return this.permissionModelDAO.getPermissionReference(null, permission);
    }
}

